/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item;

import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.pipenet.IPipeNode;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.List;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class PipeBlockItem
extends BlockItem {
    public PipeBlockItem(PipeBlock block, Item.Properties properties) {
        super((Block)block, properties);
    }

    public PipeBlock getBlock() {
        return (PipeBlock)super.getBlock();
    }

    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> tooltip, TooltipFlag isAdvanced) {
        super.appendHoverText(stack, level, tooltip, isAdvanced);
        if (GTUtil.isShiftDown()) {
            GTToolType tool = this.getBlock().getPipeTuneTool();
            tooltip.add((Component)Component.translatable((String)("gtceu.tool_action." + tool.name + ".connect")));
        } else {
            tooltip.add((Component)Component.translatable((String)"gtceu.tool_action.show_tooltips"));
        }
    }

    public boolean placeBlock(BlockPlaceContext context, BlockState state) {
        boolean superVal;
        Direction sideAttach;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction side = context.getClickedFace();
        BlockPos realPos = pos.relative(side.getOpposite());
        IPipeNode baseNode = this.getBlock().getPipeTile((BlockGetter)level, realPos);
        if (baseNode != null && (sideAttach = ICoverable.traceCoverSide(new BlockHitResult(context.getClickLocation(), side, realPos, false))) != null && context.getLevel().isEmptyBlock(realPos.relative(sideAttach))) {
            pos = realPos.relative(sideAttach);
            side = sideAttach;
            context = new BlockPlaceContext(level, context.getPlayer(), context.getHand(), context.getItemInHand(), new BlockHitResult(context.getClickLocation(), sideAttach, realPos, false));
        }
        if ((superVal = super.placeBlock(context, state)) && !level.isClientSide) {
            IPipeNode selfTile = this.getBlock().getPipeTile((BlockGetter)level, pos);
            if (selfTile == null) {
                return true;
            }
            if (selfTile.getPipeBlock().canConnect(selfTile, side.getOpposite())) {
                selfTile.setConnection(side.getOpposite(), true, false);
            }
            for (Direction facing : GTUtil.DIRECTIONS) {
                BlockEntity te = selfTile.getNeighbor(facing);
                if (te instanceof IPipeNode) {
                    IPipeNode otherPipe = (IPipeNode)te;
                    if (!otherPipe.isConnected(facing.getOpposite())) continue;
                    if (otherPipe.getPipeBlock().canPipesConnect(otherPipe, facing.getOpposite(), selfTile)) {
                        selfTile.setConnection(facing, true, true);
                        continue;
                    }
                    otherPipe.setConnection(facing.getOpposite(), false, true);
                    continue;
                }
                if (ConfigHolder.INSTANCE.machines.gt6StylePipesCables || !selfTile.getPipeBlock().canPipeConnectToBlock(selfTile, facing, te)) continue;
                selfTile.setConnection(facing, true, false);
            }
        }
        return superVal;
    }
}

