/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.armor;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.common.data.GTSoundEntries;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.ServerGamePacketListenerImplAccessor;
import com.gregtechceu.gtceu.utils.ItemStackHashStrategy;
import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenCustomHashMap;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.NonNullList;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.event.ForgeEventFactory;

public class ArmorUtils {
    public static final int MIN_NIGHTVISION_CHARGE = 4;
    public static final int NIGHTVISION_DURATION = 400;
    public static final int NIGHT_VISION_RESET = 240;

    public static boolean isPossibleToCharge(ItemStack chargeable) {
        IElectricItem container = GTCapabilityHelper.getElectricItem(chargeable);
        if (container != null) {
            return container.getCharge() < container.getMaxCharge() && container.getCharge() + container.getTransferLimit() <= container.getMaxCharge();
        }
        return false;
    }

    public static List<Pair<NonNullList<ItemStack>, IntList>> getChargeableItem(Player player, int tier) {
        ItemStack offHand;
        IElectricItem offHandItem;
        ArrayList<Pair<NonNullList<ItemStack>, IntList>> inventorySlotMap = new ArrayList<Pair<NonNullList<ItemStack>, IntList>>();
        IntArrayList openMainSlots = new IntArrayList();
        for (int i = 0; i < player.getInventory().items.size(); ++i) {
            ItemStack current = (ItemStack)player.getInventory().items.get(i);
            IElectricItem item = GTCapabilityHelper.getElectricItem(current);
            if (item == null || !ArmorUtils.isPossibleToCharge(current) || item.getTier() > tier) continue;
            openMainSlots.add(i);
        }
        if (!openMainSlots.isEmpty()) {
            inventorySlotMap.add(Pair.of((Object)player.getInventory().items, (Object)openMainSlots));
        }
        IntArrayList openArmorSlots = new IntArrayList();
        for (int i = 0; i < player.getInventory().armor.size(); ++i) {
            ItemStack current = (ItemStack)player.getInventory().armor.get(i);
            IElectricItem item = GTCapabilityHelper.getElectricItem(current);
            if (item == null || !ArmorUtils.isPossibleToCharge(current) || item.getTier() > tier) continue;
            openArmorSlots.add(i);
        }
        if (!openArmorSlots.isEmpty()) {
            inventorySlotMap.add(Pair.of((Object)player.getInventory().armor, (Object)openArmorSlots));
        }
        if ((offHandItem = GTCapabilityHelper.getElectricItem(offHand = (ItemStack)player.getInventory().offhand.get(0))) == null) {
            return inventorySlotMap;
        }
        if (ArmorUtils.isPossibleToCharge(offHand) && offHandItem.getTier() <= tier) {
            inventorySlotMap.add((Pair<NonNullList<ItemStack>, IntList>)Pair.of((Object)player.getInventory().offhand, (Object)new IntArrayList(new int[]{0})));
        }
        return inventorySlotMap;
    }

    public static void spawnParticle(Level world, Player player, ParticleOptions type, double speedY) {
        if (type != null) {
            Vec3 forward = player.getForward();
            world.addParticle(type, player.getX() - forward.x, player.getY() + 0.5, player.getZ() - forward.z, 0.0, speedY, 0.0);
        }
    }

    public static void playJetpackSound(@Nonnull Player player) {
        if (player.level().isClientSide()) {
            float cons = (float)player.getDeltaMovement().y + player.moveDist;
            cons = Mth.clamp((float)cons, (float)0.6f, (float)1.0f);
            if (player.getDeltaMovement().y > (double)0.05f) {
                cons += 0.1f;
            }
            if (player.getDeltaMovement().y < (double)-0.05f) {
                cons -= 0.4f;
            }
            player.playSound(GTSoundEntries.JET_ENGINE.getMainEvent(), 0.3f, cons);
        }
    }

    public static void resetPlayerFloatingTime(Player player) {
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ((ServerGamePacketListenerImplAccessor)serverPlayer.connection).setAboveGroundTickCount(0);
        }
    }

    public static InteractionResultHolder<ItemStack> eat(Player player, ItemStack food) {
        if (!food.isEdible()) {
            return InteractionResultHolder.fail((Object)food);
        }
        FoodProperties foodItem = food.getFoodProperties((LivingEntity)player);
        if (foodItem != null && player.getFoodData().needsFood()) {
            ItemStack result = ForgeEventFactory.onItemUseFinish((LivingEntity)player, (ItemStack)food.copy(), (int)player.getUseItemRemainingTicks(), (ItemStack)food.finishUsingItem(player.level(), (LivingEntity)player));
            return InteractionResultHolder.success((Object)result);
        }
        return InteractionResultHolder.fail((Object)food);
    }

    public static List<ItemStack> format(List<ItemStack> input) {
        Object2IntOpenCustomHashMap items = new Object2IntOpenCustomHashMap((Hash.Strategy)ItemStackHashStrategy.comparingAllButCount());
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (ItemStack itemStack : input) {
            if (items.containsKey((Object)itemStack)) {
                int amount = items.getInt((Object)itemStack);
                items.replace((Object)itemStack, ++amount);
                continue;
            }
            items.put((Object)itemStack, 1);
        }
        for (Object2IntMap.Entry entry : items.object2IntEntrySet()) {
            ItemStack stack = ((ItemStack)entry.getKey()).copy();
            stack.setCount(entry.getIntValue());
            output.add(stack);
        }
        return output;
    }

    @Nonnull
    public static String format(long value) {
        return new DecimalFormat("###,###.##").format(value);
    }

    public static String format(double value) {
        return new DecimalFormat("###,###.##").format(value);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class ModularHUD {
        private byte stringAmount = 0;
        private final List<Component> stringList = new ArrayList<Component>();
        private static final Minecraft mc = Minecraft.getInstance();

        public void newString(Component string) {
            this.stringAmount = (byte)(this.stringAmount + 1);
            this.stringList.add(string);
        }

        public void draw(GuiGraphics poseStack) {
            for (int i = 0; i < this.stringAmount; ++i) {
                IntIntPair coords = this.getStringCoord(i);
                poseStack.drawString(ModularHUD.mc.font, this.stringList.get(i), coords.firstInt(), coords.secondInt(), 0xFFFFFF, false);
            }
        }

        @Nonnull
        private IntIntPair getStringCoord(int index) {
            int posX;
            Objects.requireNonNull(ModularHUD.mc.font);
            int fontHeight = 9;
            int windowHeight = mc.getWindow().getGuiScaledHeight();
            int windowWidth = mc.getWindow().getGuiScaledWidth();
            int stringWidth = ModularHUD.mc.font.width((FormattedText)this.stringList.get(index));
            return IntIntPair.of((int)posX, (int)(switch (ConfigHolder.INSTANCE.client.armorHud.hudLocation) {
                case 1 -> {
                    posX = 1 + ConfigHolder.INSTANCE.client.armorHud.hudOffsetX;
                    yield 1 + ConfigHolder.INSTANCE.client.armorHud.hudOffsetY + fontHeight * index;
                }
                case 2 -> {
                    posX = windowWidth - (1 + ConfigHolder.INSTANCE.client.armorHud.hudOffsetX) - stringWidth;
                    yield 1 + ConfigHolder.INSTANCE.client.armorHud.hudOffsetY + fontHeight * index;
                }
                case 3 -> {
                    posX = 1 + ConfigHolder.INSTANCE.client.armorHud.hudOffsetX;
                    yield windowHeight - fontHeight * (this.stringAmount - index) - 1 - ConfigHolder.INSTANCE.client.armorHud.hudOffsetY;
                }
                case 4 -> {
                    posX = windowWidth - (1 + ConfigHolder.INSTANCE.client.armorHud.hudOffsetX) - stringWidth;
                    yield windowHeight - fontHeight * (this.stringAmount - index) - 1 - ConfigHolder.INSTANCE.client.armorHud.hudOffsetY;
                }
                default -> throw new IllegalArgumentException("Armor Hud config hudLocation is improperly configured. Allowed values: [1,2,3,4]");
            }));
        }

        public void reset() {
            this.stringAmount = 0;
            this.stringList.clear();
        }
    }
}

