/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool;

import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.PropertyKey;
import com.gregtechceu.gtceu.api.data.chemical.material.properties.ToolProperty;
import com.gregtechceu.gtceu.data.recipe.CustomTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MaterialToolTier
implements Tier {
    public final Material material;
    public final ToolProperty property;

    public MaterialToolTier(Material material) {
        this.material = material;
        if (!material.hasProperty(PropertyKey.TOOL)) {
            throw new IllegalArgumentException("material %s hasn't got Tool Property".formatted(material));
        }
        this.property = material.getProperty(PropertyKey.TOOL);
    }

    public int getUses() {
        return this.property.getDurability() * this.property.getDurabilityMultiplier();
    }

    public float getSpeed() {
        return this.property.getHarvestSpeed();
    }

    public float getAttackDamageBonus() {
        return this.property.getAttackDamage();
    }

    public int getLevel() {
        return this.property.getHarvestLevel();
    }

    public int getEnchantmentValue() {
        return this.property.getEnchantability();
    }

    @NotNull
    public Ingredient getRepairIngredient() {
        return Ingredient.EMPTY;
    }

    @Nullable
    public TagKey<Block> getTag() {
        return CustomTags.TOOL_TIERS[this.getLevel()];
    }
}

