/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool.aoe;

import com.google.common.base.Preconditions;
import net.minecraft.nbt.CompoundTag;
import org.jetbrains.annotations.Nullable;

public class AoESymmetrical {
    public final int column;
    public final int row;
    public final int layer;
    public static final AoESymmetrical ZERO = new AoESymmetrical();

    private AoESymmetrical() {
        this.column = 0;
        this.row = 0;
        this.layer = 0;
    }

    private AoESymmetrical(int column, int row, int layer) {
        this.column = column;
        this.row = row;
        this.layer = layer;
    }

    public boolean isZero() {
        return this == ZERO;
    }

    public static AoESymmetrical of(int column, int row, int layer) {
        Preconditions.checkArgument((column >= 0 ? 1 : 0) != 0, (Object)"Height cannot be negative.");
        Preconditions.checkArgument((row >= 0 ? 1 : 0) != 0, (Object)"Width cannot be negative.");
        Preconditions.checkArgument((layer >= 0 ? 1 : 0) != 0, (Object)"Depth cannot be negative.");
        return column == 0 && row == 0 && layer == 0 ? ZERO : new AoESymmetrical(column, row, layer);
    }

    public static AoESymmetrical readMax(CompoundTag tag) {
        int column = 0;
        int row = 0;
        int layer = 0;
        if (tag.contains("MaxAoEColumn", 3)) {
            column = tag.getInt("MaxAoEColumn");
        }
        if (tag.contains("MaxAoERow", 3)) {
            row = tag.getInt("MaxAoERow");
        }
        if (tag.contains("MaxAoELayer", 3)) {
            layer = tag.getInt("MaxAoELayer");
        }
        return column == 0 && row == 0 && layer == 0 ? ZERO : AoESymmetrical.of(column, row, layer);
    }

    public static AoESymmetrical read(CompoundTag tag, @Nullable AoESymmetrical defaultDefinition) {
        int layer;
        int row;
        int column;
        if (tag.contains("AoEColumn", 3)) {
            column = tag.getInt("AoEColumn");
        } else {
            int n = column = defaultDefinition == null ? 0 : defaultDefinition.column;
        }
        if (tag.contains("AoERow", 3)) {
            row = tag.getInt("AoERow");
        } else {
            int n = row = defaultDefinition == null ? 0 : defaultDefinition.row;
        }
        if (tag.contains("AoELayer", 3)) {
            layer = tag.getInt("AoELayer");
        } else {
            int n = layer = defaultDefinition == null ? 0 : defaultDefinition.layer;
        }
        if (column == 0 && row == 0 && layer == 0) {
            return ZERO;
        }
        tag.putInt("AoEColumn", column);
        tag.putInt("AoERow", row);
        tag.putInt("AoELayer", layer);
        return AoESymmetrical.of(column, row, layer);
    }

    public static int getColumn(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (tag.contains("AoEColumn", 3)) {
            return tag.getInt("AoEColumn");
        }
        return defaultDefinition.column;
    }

    public static int getRow(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (tag.contains("AoERow", 3)) {
            return tag.getInt("AoERow");
        }
        return defaultDefinition.row;
    }

    public static int getLayer(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (tag.contains("AoELayer", 3)) {
            return tag.getInt("AoELayer");
        }
        return defaultDefinition.layer;
    }

    public static void increaseColumn(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (!tag.contains("AoEColumn", 3)) {
            tag.putInt("AoEColumn", defaultDefinition.column);
        } else {
            int currentColumn = tag.getInt("AoEColumn");
            if (currentColumn < defaultDefinition.column) {
                tag.putInt("AoEColumn", currentColumn + 1);
            }
        }
    }

    public static void increaseRow(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (!tag.contains("AoERow", 3)) {
            tag.putInt("AoERow", defaultDefinition.row);
        } else {
            int currentRow = tag.getInt("AoERow");
            if (currentRow < defaultDefinition.row) {
                tag.putInt("AoERow", currentRow + 1);
            }
        }
    }

    public static void increaseLayer(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (!tag.contains("AoELayer", 3)) {
            tag.putInt("AoELayer", defaultDefinition.layer);
        } else {
            int currentLayer = tag.getInt("AoELayer");
            if (currentLayer < defaultDefinition.layer) {
                tag.putInt("AoELayer", currentLayer + 1);
            }
        }
    }

    public static void decreaseColumn(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (!tag.contains("AoEColumn", 3)) {
            tag.putInt("AoEColumn", defaultDefinition.column);
        } else {
            int currentColumn = tag.getInt("AoEColumn");
            if (currentColumn > 0) {
                tag.putInt("AoEColumn", currentColumn - 1);
            }
        }
    }

    public static void decreaseRow(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (!tag.contains("AoERow", 3)) {
            tag.putInt("AoERow", defaultDefinition.row);
        } else {
            int currentRow = tag.getInt("AoERow");
            if (currentRow > 0) {
                tag.putInt("AoERow", currentRow - 1);
            }
        }
    }

    public static void decreaseLayer(CompoundTag tag, AoESymmetrical defaultDefinition) {
        if (!tag.contains("AoELayer", 3)) {
            tag.putInt("AoELayer", defaultDefinition.layer);
        } else {
            int currentLayer = tag.getInt("AoELayer");
            if (currentLayer > 0) {
                tag.putInt("AoELayer", currentLayer - 1);
            }
        }
    }
}

