/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.item.tool.behavior;

import com.gregtechceu.gtceu.api.item.IGTTool;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ToolAction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IToolBehavior {
    default public void init(IGTTool toolItem) {
    }

    default public void hitEntity(@NotNull ItemStack stack, @NotNull LivingEntity target, @NotNull LivingEntity attacker) {
    }

    default public void onBlockStartBreak(@NotNull ItemStack stack, @NotNull BlockPos pos, @NotNull Player player) {
    }

    default public void onBlockDestroyed(@NotNull ItemStack stack, @NotNull Level world, @NotNull BlockState state, @NotNull BlockPos pos, @NotNull LivingEntity entityLiving) {
    }

    default public void onEntitySwing(@NotNull LivingEntity entityLiving, @NotNull ItemStack stack) {
    }

    default public boolean canDisableShield(ItemStack stack, ItemStack shield, LivingEntity entity, LivingEntity attacker) {
        return false;
    }

    default public InteractionResult onItemUseFirst(ItemStack stack, UseOnContext context) {
        return InteractionResult.PASS;
    }

    default public boolean canPerformAction(ItemStack stack, ToolAction action) {
        return false;
    }

    @NotNull
    default public InteractionResult onItemUse(UseOnContext context) {
        return InteractionResult.PASS;
    }

    @NotNull
    default public InteractionResultHolder<ItemStack> onItemRightClick(@NotNull Level world, @NotNull Player player, @NotNull InteractionHand hand) {
        return InteractionResultHolder.pass((Object)player.getItemInHand(hand));
    }

    default public boolean shouldOpenUIAfterUse(UseOnContext context) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    default public void addInformation(@NotNull ItemStack stack, @Nullable Level world, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
    }

    default public void addBehaviorNBT(@NotNull ItemStack stack, @NotNull CompoundTag tag) {
    }
}

