/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.feature;

import com.gregtechceu.gtceu.api.capability.IControllable;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.gui.fancy.ConfiguratorPanel;
import com.gregtechceu.gtceu.api.gui.fancy.FancyMachineUIWidget;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfigurator;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyConfiguratorButton;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyTooltip;
import com.gregtechceu.gtceu.api.gui.fancy.IFancyUIProvider;
import com.gregtechceu.gtceu.api.gui.fancy.TabsWidget;
import com.gregtechceu.gtceu.api.gui.fancy.TooltipsPanel;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.CombinedDirectionalFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.fancyconfigurator.MachineModeFancyConfigurator;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.IUIMachine;
import com.lowdragmc.lowdraglib.gui.modular.IUIHolder;
import com.lowdragmc.lowdraglib.gui.modular.ModularUI;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SceneWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public interface IFancyUIMachine
extends IUIMachine,
IFancyUIProvider {
    default public ModularUI createUI(Player entityPlayer) {
        return new ModularUI(176, 166, (IUIHolder)this, entityPlayer).widget((Widget)new FancyMachineUIWidget(this, 176, 166));
    }

    @Override
    default public Widget createMainPage(FancyMachineUIWidget widget) {
        EditableMachineUI editableUI = this.self().getDefinition().getEditableUI();
        if (editableUI != null) {
            WidgetGroup template = editableUI.createCustomUI();
            if (template == null) {
                template = editableUI.createDefault();
            }
            editableUI.setupUI(template, this.self());
            return template;
        }
        return this.createUIWidget();
    }

    default public Widget createUIWidget() {
        WidgetGroup group = new WidgetGroup(0, 0, 100, 100);
        if (this.isRemote()) {
            group.addWidget((Widget)new ImageWidget(26, 60, 48, 16, (IGuiTexture)GuiTextures.SCENE));
            TrackedDummyWorld world = new TrackedDummyWorld();
            world.addBlock(BlockPos.ZERO, BlockInfo.fromBlockState((BlockState)this.self().getBlockState()));
            SceneWidget sceneWidget = new SceneWidget(0, 0, 100, 100, (Level)world){

                @OnlyIn(value=Dist.CLIENT)
                public void drawInBackground(@NotNull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
                    if (this.renderer != null) {
                        this.rotationPitch = (partialTicks + (float)this.getGui().getTickCount()) * 2.0f;
                        this.renderer.setCameraLookAt(this.center, (double)0.1f, Math.toRadians(this.rotationPitch), Math.toRadians(this.rotationYaw));
                    }
                    super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
                }
            };
            sceneWidget.useOrtho(true).setOrthoRange(0.5f).setScalable(false).setDraggable(false).setRenderFacing(false).setRenderSelect(false);
            sceneWidget.getRenderer().setFov(30.0f);
            group.addWidget((Widget)sceneWidget);
            sceneWidget.setRenderedCore(List.of(BlockPos.ZERO), null);
        }
        return group;
    }

    @Override
    default public IGuiTexture getTabIcon() {
        return new ItemStackTexture(new Item[]{this.self().getDefinition().getItem()});
    }

    @Override
    default public void attachSideTabs(TabsWidget sideTabs) {
        CombinedDirectionalFancyConfigurator directionalConfigurator;
        IRecipeLogicMachine rLMachine;
        sideTabs.setMainTab(this);
        IFancyUIMachine iFancyUIMachine = this;
        if (iFancyUIMachine instanceof IRecipeLogicMachine && (rLMachine = (IRecipeLogicMachine)((Object)iFancyUIMachine)).getRecipeTypes().length > 1) {
            sideTabs.attachSubTab(new MachineModeFancyConfigurator(rLMachine));
        }
        if ((directionalConfigurator = CombinedDirectionalFancyConfigurator.of(this.self(), this.self())) != null) {
            sideTabs.attachSubTab(directionalConfigurator);
        }
    }

    @Override
    default public void attachConfigurators(ConfiguratorPanel configuratorPanel) {
        Direction[] directionArray = this;
        if (directionArray instanceof IControllable) {
            IControllable controllable = (IControllable)directionArray;
            IFancyConfigurator[] iFancyConfiguratorArray = new IFancyConfigurator[1];
            iFancyConfiguratorArray[0] = new IFancyConfiguratorButton.Toggle((IGuiTexture)GuiTextures.BUTTON_POWER.getSubTexture(0.0, 0.0, 1.0, 0.5), (IGuiTexture)GuiTextures.BUTTON_POWER.getSubTexture(0.0, 0.5, 1.0, 0.5), controllable::isWorkingEnabled, (clickData, pressed) -> controllable.setWorkingEnabled((boolean)pressed)).setTooltipsSupplier(pressed -> List.of(Component.translatable((String)(pressed != false ? "behaviour.soft_hammer.enabled" : "behaviour.soft_hammer.disabled"))));
            configuratorPanel.attachConfigurators(iFancyConfiguratorArray);
        }
        if ((directionArray = this) instanceof MetaMachine) {
            MetaMachine machine = (MetaMachine)directionArray;
            for (Direction direction : Direction.values()) {
                IFancyConfigurator configurator;
                if (!machine.getCoverContainer().hasCover(direction) || (configurator = machine.getCoverContainer().getCoverAtSide(direction).getConfigurator()) == null) continue;
                configuratorPanel.attachConfigurators(configurator);
            }
        }
    }

    @Override
    default public void attachTooltips(TooltipsPanel tooltipsPanel) {
        tooltipsPanel.attachTooltips(this.self());
        this.self().getTraits().stream().filter(IFancyTooltip.class::isInstance).map(IFancyTooltip.class::cast).forEach(xva$0 -> tooltipsPanel.attachTooltips((IFancyTooltip)xva$0));
    }

    @Override
    default public List<Component> getTabTooltips() {
        ArrayList<Component> list = new ArrayList<Component>();
        list.add((Component)Component.translatable((String)this.self().getDefinition().getDescriptionId()));
        return list;
    }

    @Override
    default public Component getTitle() {
        return Component.translatable((String)this.self().getDefinition().getDescriptionId());
    }
}

