/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.multiblock;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.block.property.GTBlockStateProperties;
import com.gregtechceu.gtceu.api.capability.IParallelHatch;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.pattern.MultiblockState;
import com.gregtechceu.gtceu.api.pattern.MultiblockWorldSavedData;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.annotation.RequireRerender;
import com.lowdragmc.lowdraglib.syncdata.annotation.UpdateListener;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MultiblockControllerMachine
extends MetaMachine
implements IMultiController {
    protected static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MultiblockControllerMachine.class, MetaMachine.MANAGED_FIELD_HOLDER);
    private MultiblockState multiblockState;
    private final List<IMultiPart> parts = new ArrayList<IMultiPart>();
    @Nullable
    private IParallelHatch parallelHatch = null;
    @DescSynced
    @UpdateListener(methodName="onPartsUpdated")
    private BlockPos[] partPositions = new BlockPos[0];
    @Persisted
    @DescSynced
    @RequireRerender
    protected boolean isFormed;
    @Persisted
    @DescSynced
    protected boolean isFlipped;
    private final Lock patternLock = new ReentrantLock();

    public MultiblockControllerMachine(IMachineBlockEntity holder) {
        super(holder);
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public MultiblockMachineDefinition getDefinition() {
        return (MultiblockMachineDefinition)super.getDefinition();
    }

    @Override
    public void onLoad() {
        super.onLoad();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MultiblockWorldSavedData.getOrCreate(serverLevel).addAsyncLogic(this);
        }
    }

    @Override
    public void onUnload() {
        super.onUnload();
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MultiblockWorldSavedData.getOrCreate(serverLevel).removeAsyncLogic(this);
        }
    }

    @Override
    @NotNull
    public MultiblockState getMultiblockState() {
        if (this.multiblockState == null) {
            this.multiblockState = new MultiblockState(this.getLevel(), this.getPos());
        }
        return this.multiblockState;
    }

    protected void onPartsUpdated(BlockPos[] newValue, BlockPos[] oldValue) {
        this.parts.clear();
        for (BlockPos pos : newValue) {
            MetaMachine metaMachine = MultiblockControllerMachine.getMachine((BlockGetter)this.getLevel(), pos);
            if (!(metaMachine instanceof IMultiPart)) continue;
            IMultiPart part = (IMultiPart)((Object)metaMachine);
            this.parts.add(part);
        }
    }

    protected void updatePartPositions() {
        this.partPositions = this.parts.isEmpty() ? new BlockPos[]{} : (BlockPos[])this.parts.stream().map(part -> part.self().getPos()).toArray(BlockPos[]::new);
    }

    @Override
    public List<IMultiPart> getParts() {
        if (this.parts.size() != this.partPositions.length) {
            this.parts.clear();
            for (BlockPos pos : this.partPositions) {
                MetaMachine metaMachine = MultiblockControllerMachine.getMachine((BlockGetter)this.getLevel(), pos);
                if (!(metaMachine instanceof IMultiPart)) continue;
                IMultiPart part = (IMultiPart)((Object)metaMachine);
                this.parts.add(part);
            }
        }
        return this.parts;
    }

    @Override
    public Optional<IParallelHatch> getParallelHatch() {
        return Optional.ofNullable(this.parallelHatch);
    }

    @Override
    public void asyncCheckPattern(long periodID) {
        Level level;
        if ((this.getMultiblockState().hasError() || !this.isFormed) && (this.getHolder().getOffset() + periodID) % 4L == 0L && this.checkPatternWithTryLock() && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.getServer().execute(() -> {
                this.patternLock.lock();
                if (this.checkPatternWithLock()) {
                    this.setFlipped(this.getMultiblockState().isNeededFlip());
                    this.onStructureFormed();
                    MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
                    mwsd.addMapping(this.getMultiblockState());
                    mwsd.removeAsyncLogic(this);
                }
                this.patternLock.unlock();
            });
        }
    }

    @Override
    public void onStructureFormed() {
        this.isFormed = true;
        MachineRenderState renderState = this.getRenderState();
        if (renderState.hasProperty((Property)GTMachineModelProperties.IS_FORMED)) {
            this.setRenderState((MachineRenderState)((Object)renderState.setValue((Property)GTMachineModelProperties.IS_FORMED, Boolean.valueOf(true))));
        }
        this.parts.clear();
        Set set = this.getMultiblockState().getMatchContext().getOrCreate("parts", Collections::emptySet);
        for (IMultiPart part : set) {
            if (!this.shouldAddPartToController(part)) continue;
            this.parts.add(part);
        }
        this.parts.sort(this.getPartSorter());
        for (IMultiPart part : this.parts) {
            if (part instanceof IParallelHatch) {
                IParallelHatch pHatch;
                this.parallelHatch = pHatch = (IParallelHatch)((Object)part);
            }
            part.addedToController(this);
        }
        this.updatePartPositions();
    }

    @Override
    public void onStructureInvalid() {
        this.isFormed = false;
        MachineRenderState renderState = this.getRenderState();
        if (renderState.hasProperty((Property)GTMachineModelProperties.IS_FORMED)) {
            this.setRenderState((MachineRenderState)((Object)renderState.setValue((Property)GTMachineModelProperties.IS_FORMED, Boolean.valueOf(false))));
        }
        for (IMultiPart part : this.parts) {
            part.removedFromController(this);
        }
        this.parallelHatch = null;
        this.parts.clear();
        this.updatePartPositions();
    }

    @Override
    public void onPartUnload() {
        this.parts.removeIf(part -> part.self().isInValid());
        this.getMultiblockState().setError(MultiblockState.UNLOAD_ERROR);
        Level level = this.getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            MultiblockWorldSavedData.getOrCreate(serverLevel).addAsyncLogic(this);
        }
        this.updatePartPositions();
    }

    @Override
    public void onRotated(Direction oldFacing, Direction newFacing) {
        Level level;
        if (oldFacing != newFacing && (level = this.getLevel()) instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            this.onStructureInvalid();
            MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
            mwsd.removeMapping(this.getMultiblockState());
            mwsd.addAsyncLogic(this);
        }
    }

    public boolean allowFlip() {
        return this.getDefinition().isAllowFlip();
    }

    @Override
    public void setUpwardsFacing(@NotNull Direction upwardsFacing) {
        if (!this.getDefinition().isAllowExtendedFacing()) {
            return;
        }
        if (upwardsFacing.getAxis() == Direction.Axis.Y) {
            GTCEu.LOGGER.error("Tried to set upwards facing to invalid facing {}! Skipping", (Object)upwardsFacing);
            return;
        }
        BlockState blockState = this.getBlockState();
        if (blockState.getBlock() instanceof MetaMachineBlock && blockState.getValue((Property)GTBlockStateProperties.UPWARDS_FACING) != upwardsFacing) {
            this.getLevel().setBlockAndUpdate(this.getPos(), (BlockState)blockState.setValue((Property)GTBlockStateProperties.UPWARDS_FACING, (Comparable)upwardsFacing));
            if (this.getLevel() != null && !this.getLevel().isClientSide) {
                this.notifyBlockUpdate();
                this.markDirty();
                this.checkPattern();
            }
        }
    }

    @Override
    protected InteractionResult onWrenchClick(Player playerIn, InteractionHand hand, Direction gridSide, BlockHitResult hitResult) {
        if (gridSide == this.getFrontFacing() && this.allowExtendedFacing()) {
            this.setUpwardsFacing(playerIn.isShiftKeyDown() ? this.getUpwardsFacing().getCounterClockWise() : this.getUpwardsFacing().getClockWise());
            return InteractionResult.sidedSuccess((boolean)playerIn.level().isClientSide);
        }
        if (playerIn.isShiftKeyDown()) {
            if (gridSide == this.getFrontFacing() || !this.isFacingValid(gridSide)) {
                return InteractionResult.FAIL;
            }
            if (!this.isRemote()) {
                this.setFrontFacing(gridSide);
            }
            return InteractionResult.sidedSuccess((boolean)playerIn.level().isClientSide);
        }
        return super.onWrenchClick(playerIn, hand, gridSide, hitResult);
    }

    @Override
    public void setFrontFacing(Direction facing) {
        super.setFrontFacing(facing);
        if (this.getLevel() != null && !this.getLevel().isClientSide) {
            this.checkPattern();
        }
    }

    @Generated
    public BlockPos[] getPartPositions() {
        return this.partPositions;
    }

    @Override
    @Generated
    public boolean isFormed() {
        return this.isFormed;
    }

    @Generated
    public boolean isFlipped() {
        return this.isFlipped;
    }

    @Generated
    public void setFlipped(boolean isFlipped) {
        this.isFlipped = isFlipped;
    }

    @Override
    @Generated
    public Lock getPatternLock() {
        return this.patternLock;
    }
}

