/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableItemStackHandler;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ItemHandlerProxyTrait
extends MachineTrait
implements IItemHandlerModifiable,
ICapabilityTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(ItemHandlerProxyTrait.class);
    public final IO capabilityIO;
    @Nullable
    public IItemHandlerModifiable proxy;

    public ItemHandlerProxyTrait(MetaMachine machine, IO capabilityIO) {
        super(machine);
        this.capabilityIO = capabilityIO;
    }

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public int getSlots() {
        return this.proxy == null ? 0 : this.proxy.getSlots();
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.proxy == null ? ItemStack.EMPTY : this.proxy.getStackInSlot(slot);
    }

    public void setStackInSlot(int index, ItemStack stack) {
        if (this.proxy != null) {
            this.proxy.setStackInSlot(index, stack);
        }
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.proxy != null && this.canCapInput()) {
            return this.proxy.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack insertItemInternal(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.proxy == null ? stack : this.proxy.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.proxy != null && this.canCapOutput()) {
            return this.proxy.extractItem(slot, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        return this.proxy == null ? ItemStack.EMPTY : this.proxy.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.proxy == null ? 0 : this.proxy.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.proxy != null && this.proxy.isItemValid(slot, stack);
    }

    public boolean isEmpty() {
        IItemHandlerModifiable iItemHandlerModifiable = this.proxy;
        if (iItemHandlerModifiable instanceof NotifiableItemStackHandler) {
            NotifiableItemStackHandler itemStackHandler = (NotifiableItemStackHandler)iItemHandlerModifiable;
            return itemStackHandler.isEmpty();
        }
        boolean isEmpty = true;
        if (this.proxy != null) {
            for (int i = 0; i < this.proxy.getSlots(); ++i) {
                if (this.proxy.getStackInSlot(i).isEmpty()) continue;
                isEmpty = false;
                break;
            }
        }
        return isEmpty;
    }

    public void exportToNearby(Direction ... facings) {
        if (this.isEmpty()) {
            return;
        }
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            Predicate<ItemStack> filter = this.getMachine().getItemCapFilter(facing, IO.OUT);
            GTTransferUtils.getAdjacentItemHandler(level, pos, facing).ifPresent(adj -> GTTransferUtils.transferItemsFiltered((IItemHandler)this, adj, filter));
        }
    }

    @Override
    @Generated
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }

    @NotNull
    @Generated
    public ItemHandlerProxyTrait setProxy(@Nullable IItemHandlerModifiable proxy) {
        this.proxy = proxy;
        return this;
    }

    @Nullable
    @Generated
    public IItemHandlerModifiable getProxy() {
        return this.proxy;
    }
}

