/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationHatch;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationProvider;
import com.gregtechceu.gtceu.api.capability.IOpticalComputationReceiver;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.capability.recipe.CWURecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.trait.MachineTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.common.blockentity.OpticalPipeBlockEntity;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import lombok.Generated;
import net.minecraft.core.Direction;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotifiableComputationContainer
extends NotifiableRecipeHandlerTrait<Integer>
implements IOpticalComputationHatch,
IOpticalComputationReceiver {
    protected IO handlerIO;
    protected boolean transmitter;
    protected long lastTimeStamp;
    private int currentOutputCwu = 0;
    private int lastOutputCwu = 0;

    public NotifiableComputationContainer(MetaMachine machine, IO handlerIO, boolean transmitter) {
        super(machine);
        this.handlerIO = handlerIO;
        this.transmitter = transmitter;
        this.lastTimeStamp = Long.MIN_VALUE;
    }

    @Override
    public int requestCWUt(int cwut, boolean simulate, @NotNull Collection<IOpticalComputationProvider> seen) {
        long latestTimeStamp = this.getMachine().getOffsetTimer();
        if (this.lastTimeStamp < latestTimeStamp) {
            this.lastOutputCwu = this.currentOutputCwu;
            this.currentOutputCwu = 0;
            this.lastTimeStamp = latestTimeStamp;
        }
        seen.add(this);
        if (this.handlerIO == IO.IN) {
            if (this.isTransmitter()) {
                Object object = this.machine;
                if (object instanceof IOpticalComputationProvider) {
                    IOpticalComputationProvider provider = (IOpticalComputationProvider)object;
                    return provider.requestCWUt(cwut, simulate, seen);
                }
                object = this.machine;
                if (object instanceof IMultiPart) {
                    IMultiPart part = (IMultiPart)object;
                    if (!part.isFormed()) {
                        return 0;
                    }
                    for (IMultiController controller : part.getControllers()) {
                        if (controller instanceof IOpticalComputationProvider) {
                            IOpticalComputationProvider provider = (IOpticalComputationProvider)((Object)controller);
                            return provider.requestCWUt(cwut, simulate, seen);
                        }
                        for (MachineTrait trait : controller.self().getTraits()) {
                            if (!(trait instanceof IOpticalComputationProvider)) continue;
                            IOpticalComputationProvider provider = (IOpticalComputationProvider)((Object)trait);
                            return provider.requestCWUt(cwut, simulate, seen);
                        }
                    }
                    GTCEu.LOGGER.error("NotifiableComputationContainer could request CWU/t from its machine's controller!");
                    return 0;
                }
                GTCEu.LOGGER.error("NotifiableComputationContainer could request CWU/t from its machine!");
                return 0;
            }
            IOpticalComputationProvider provider = this.getOpticalNetProvider();
            if (provider == null) {
                return 0;
            }
            return provider.requestCWUt(cwut, simulate, seen);
        }
        this.lastOutputCwu -= cwut;
        return Math.min(this.lastOutputCwu, cwut);
    }

    @Override
    public int getMaxCWUt(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        if (this.handlerIO == IO.IN) {
            if (this.isTransmitter()) {
                Object object = this.machine;
                if (object instanceof IOpticalComputationProvider) {
                    IOpticalComputationProvider provider = (IOpticalComputationProvider)object;
                    return provider.getMaxCWUt(seen);
                }
                object = this.machine;
                if (object instanceof IMultiPart) {
                    IMultiPart part = (IMultiPart)object;
                    if (!part.isFormed()) {
                        return 0;
                    }
                    for (IMultiController controller : part.getControllers()) {
                        if (!controller.isFormed()) continue;
                        if (controller instanceof IOpticalComputationProvider) {
                            IOpticalComputationProvider provider = (IOpticalComputationProvider)((Object)controller);
                            return provider.getMaxCWUt(seen);
                        }
                        for (MachineTrait trait : controller.self().getTraits()) {
                            if (!(trait instanceof IOpticalComputationProvider)) continue;
                            IOpticalComputationProvider provider = (IOpticalComputationProvider)((Object)trait);
                            return provider.getMaxCWUt(seen);
                        }
                    }
                    GTCEu.LOGGER.error("NotifiableComputationContainer could not get maximum CWU/t from its machine's controller!");
                    return 0;
                }
                GTCEu.LOGGER.error("NotifiableComputationContainer could not get maximum CWU/t from its machine!");
                return 0;
            }
            IOpticalComputationProvider provider = this.getOpticalNetProvider();
            if (provider == null) {
                return 0;
            }
            return provider.getMaxCWUt(seen);
        }
        return this.lastOutputCwu;
    }

    @Override
    public boolean canBridge(@NotNull Collection<IOpticalComputationProvider> seen) {
        seen.add(this);
        if (this.handlerIO == IO.IN) {
            if (this.isTransmitter()) {
                Object object = this.machine;
                if (object instanceof IOpticalComputationProvider) {
                    IOpticalComputationProvider provider = (IOpticalComputationProvider)object;
                    return provider.canBridge(seen);
                }
                object = this.machine;
                if (object instanceof IMultiPart) {
                    IMultiPart part = (IMultiPart)object;
                    if (!part.isFormed()) {
                        return false;
                    }
                    for (IMultiController controller : part.getControllers()) {
                        if (!controller.isFormed()) continue;
                        if (controller instanceof IOpticalComputationProvider) {
                            IOpticalComputationProvider provider = (IOpticalComputationProvider)((Object)controller);
                            return provider.canBridge(seen);
                        }
                        for (MachineTrait trait : controller.self().getTraits()) {
                            if (!(trait instanceof IOpticalComputationProvider)) continue;
                            IOpticalComputationProvider provider = (IOpticalComputationProvider)((Object)trait);
                            return provider.canBridge(seen);
                        }
                    }
                    GTCEu.LOGGER.error("NotifiableComputationContainer could not test bridge status of its machine's controller!");
                    return false;
                }
                GTCEu.LOGGER.error("NotifiableComputationContainer could not test bridge status of its machine!");
                return false;
            }
            IOpticalComputationProvider provider = this.getOpticalNetProvider();
            if (provider == null) {
                return true;
            }
            return provider.canBridge(seen);
        }
        return false;
    }

    @Override
    public List<Integer> handleRecipeInner(IO io, GTRecipe recipe, List<Integer> left, boolean simulate) {
        IOpticalComputationProvider provider = this.getOpticalNetProvider();
        if (provider == null) {
            return left;
        }
        int sum = left.stream().mapToInt(Integer::intValue).sum();
        if (io == IO.IN) {
            int availableCWUt = this.requestCWUt(Integer.MAX_VALUE, true);
            if (availableCWUt >= sum) {
                if (recipe.data.getBoolean("duration_is_total_cwu")) {
                    int drawn = provider.requestCWUt(availableCWUt, simulate);
                    if (!simulate) {
                        Object object = this.machine;
                        if (object instanceof IRecipeLogicMachine) {
                            IRecipeLogicMachine rlm = (IRecipeLogicMachine)object;
                            --rlm.getRecipeLogic().progress;
                            rlm.getRecipeLogic().progress += drawn;
                        } else {
                            object = this.machine;
                            if (object instanceof IMultiPart) {
                                IMultiPart multiPart = (IMultiPart)object;
                                for (IMultiController controller : multiPart.getControllers()) {
                                    if (!(controller instanceof IRecipeLogicMachine)) continue;
                                    IRecipeLogicMachine rlm = (IRecipeLogicMachine)((Object)controller);
                                    --rlm.getRecipeLogic().progress;
                                    rlm.getRecipeLogic().progress += drawn;
                                }
                            }
                        }
                    }
                    sum -= drawn;
                } else {
                    sum -= provider.requestCWUt(sum, simulate);
                }
            }
        } else if (io == IO.OUT) {
            int canInput = this.getMaxCWUt() - this.lastOutputCwu;
            if (!simulate) {
                this.currentOutputCwu = Math.min(canInput, sum);
            }
            sum -= canInput;
        }
        return sum <= 0 ? null : Collections.singletonList(sum);
    }

    @Override
    @NotNull
    public List<Object> getContents() {
        return List.of(Integer.valueOf(this.lastOutputCwu));
    }

    @Override
    public double getTotalContentAmount() {
        return this.lastOutputCwu;
    }

    @Override
    public RecipeCapability<Integer> getCapability() {
        return CWURecipeCapability.CAP;
    }

    @Override
    @Nullable
    public IOpticalComputationProvider getComputationProvider() {
        IOpticalComputationProvider provider;
        IRecipeCapabilityHolder recipeCapabilityHolder;
        List<IRecipeHandler<?>> cwuCap;
        if (this.handlerIO.support(IO.OUT)) {
            return this;
        }
        MetaMachine metaMachine = this.machine;
        if (metaMachine instanceof IOpticalComputationReceiver) {
            IOpticalComputationReceiver receiver = (IOpticalComputationReceiver)((Object)metaMachine);
            return receiver.getComputationProvider();
        }
        metaMachine = this.machine;
        if (metaMachine instanceof IOpticalComputationProvider) {
            IOpticalComputationProvider provider2 = (IOpticalComputationProvider)((Object)metaMachine);
            return provider2;
        }
        metaMachine = this.machine;
        if (metaMachine instanceof IRecipeCapabilityHolder && !(cwuCap = (recipeCapabilityHolder = (IRecipeCapabilityHolder)((Object)metaMachine)).getCapabilitiesFlat(IO.IN, CWURecipeCapability.CAP)).isEmpty() && (provider = (IOpticalComputationProvider)((Object)cwuCap.get(0))) != this) {
            return provider;
        }
        for (Direction direction : GTUtil.DIRECTIONS) {
            IOpticalComputationProvider provider3;
            BlockEntity blockEntity = this.machine.getLevel().getBlockEntity(this.machine.getPos().relative(direction));
            if (blockEntity == null || (provider3 = (IOpticalComputationProvider)blockEntity.getCapability(GTCapability.CAPABILITY_COMPUTATION_PROVIDER, direction.getOpposite()).orElse(null)) == null || provider3 == this) continue;
            return provider3;
        }
        return null;
    }

    @Nullable
    private IOpticalComputationProvider getOpticalNetProvider() {
        for (Direction direction : GTUtil.DIRECTIONS) {
            BlockEntity blockEntity = this.machine.getLevel().getBlockEntity(this.machine.getPos().relative(direction));
            if (!(blockEntity instanceof OpticalPipeBlockEntity)) continue;
            return (IOpticalComputationProvider)blockEntity.getCapability(GTCapability.CAPABILITY_COMPUTATION_PROVIDER, direction.getOpposite()).orElse(null);
        }
        return null;
    }

    @Override
    @Generated
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    @Generated
    public boolean isTransmitter() {
        return this.transmitter;
    }
}

