/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.ItemRecipeCapability;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.trait.ICapabilityTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.recipe.DummyCraftingContainer;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.SizedIngredient;
import com.gregtechceu.gtceu.api.transfer.item.CustomItemStackHandler;
import com.gregtechceu.gtceu.utils.GTTransferUtils;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NotifiableItemStackHandler
extends NotifiableRecipeHandlerTrait<Ingredient>
implements ICapabilityTrait,
IItemHandlerModifiable {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(NotifiableItemStackHandler.class, NotifiableRecipeHandlerTrait.MANAGED_FIELD_HOLDER);
    public final IO handlerIO;
    public final IO capabilityIO;
    @Persisted
    @DescSynced
    public final CustomItemStackHandler storage;
    private boolean shouldSearchContent = true;
    private Boolean isEmpty;

    public NotifiableItemStackHandler(MetaMachine machine, int slots, @NotNull IO handlerIO, @NotNull IO capabilityIO, IntFunction<CustomItemStackHandler> storageFactory) {
        super(machine);
        this.handlerIO = handlerIO;
        this.storage = storageFactory.apply(slots);
        this.capabilityIO = capabilityIO;
        this.storage.setOnContentsChanged(this::onContentsChanged);
    }

    public NotifiableItemStackHandler(MetaMachine machine, int slots, @NotNull IO handlerIO, @NotNull IO capabilityIO) {
        this(machine, slots, handlerIO, capabilityIO, CustomItemStackHandler::new);
    }

    public NotifiableItemStackHandler(MetaMachine machine, int slots, @NotNull IO handlerIO) {
        this(machine, slots, handlerIO, handlerIO);
    }

    public NotifiableItemStackHandler setFilter(Predicate<ItemStack> filter) {
        this.storage.setFilter(filter);
        return this;
    }

    public void onContentsChanged() {
        this.isEmpty = null;
        this.notifyListeners();
    }

    @Override
    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    @Override
    public List<Ingredient> handleRecipeInner(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate) {
        return NotifiableItemStackHandler.handleRecipe(io, recipe, left, simulate, this.handlerIO, this.storage);
    }

    public static List<Ingredient> handleRecipe(IO io, GTRecipe recipe, List<Ingredient> left, boolean simulate, IO handlerIO, CustomItemStackHandler storage) {
        if (io != handlerIO) {
            return left;
        }
        if (io != IO.IN && io != IO.OUT) {
            return left.isEmpty() ? null : left;
        }
        Runnable listener = storage.getOnContentsChanged();
        storage.setOnContentsChanged(() -> {});
        boolean changed = false;
        ItemStack[] visited = new ItemStack[storage.getSlots()];
        ListIterator<Ingredient> it = left.listIterator();
        while (it.hasNext()) {
            int amount;
            ItemStack[] items;
            Ingredient ingredient = it.next();
            if (ingredient.isEmpty()) {
                it.remove();
                continue;
            }
            if (ingredient instanceof IntProviderIngredient) {
                ItemStack output;
                IntProviderIngredient provider = (IntProviderIngredient)ingredient;
                provider.setItemStacks(null);
                provider.setSampledCount(-1);
                if (simulate) {
                    output = provider.getMaxSizeStack();
                    items = new ItemStack[]{output};
                } else {
                    items = provider.getItems();
                    if (items.length == 0 || items[0].isEmpty()) {
                        it.remove();
                        continue;
                    }
                    output = items[0];
                }
                amount = output.getCount();
                if (io == IO.OUT) {
                    int outputStorageLimit = 0;
                    for (int slot = 0; slot < storage.getSlots(); ++slot) {
                        ItemStack stack = storage.getStackInSlot(slot);
                        if (!stack.isEmpty() && !ItemStack.isSameItemSameTags((ItemStack)stack, (ItemStack)output)) continue;
                        outputStorageLimit += storage.getSlotLimit(slot) - stack.getCount();
                    }
                    if (provider.getCountProvider().getMinValue() > outputStorageLimit) {
                        it.remove();
                        continue;
                    }
                    amount = simulate ? provider.getCountProvider().getMaxValue() : Math.min(output.getCount(), outputStorageLimit);
                }
            } else {
                items = ingredient.getItems();
                if (items.length == 0 || items[0].isEmpty()) {
                    it.remove();
                    continue;
                }
                if (ingredient instanceof SizedIngredient) {
                    SizedIngredient si = (SizedIngredient)ingredient;
                    amount = si.getAmount();
                } else {
                    amount = items[0].getCount();
                }
            }
            for (int slot = 0; slot < storage.getSlots(); ++slot) {
                ItemStack current = visited[slot] == null ? storage.getStackInSlot(slot) : visited[slot];
                int count = current.getCount();
                if (io == IO.IN) {
                    if (current.isEmpty()) continue;
                    if (ingredient.test(current)) {
                        ItemStack extracted = NotifiableItemStackHandler.getActioned(storage, slot, recipe.ingredientActions);
                        if (extracted == null) {
                            extracted = storage.extractItem(slot, Math.min(count, amount), simulate);
                        }
                        if (!extracted.isEmpty()) {
                            changed = true;
                            visited[slot] = extracted.copyWithCount(count - extracted.getCount());
                        }
                        amount -= extracted.getCount();
                    }
                } else {
                    ItemStack output = items[0].copyWithCount(amount);
                    if ((visited[slot] == null || ItemStack.isSameItemSameTags((ItemStack)visited[slot], (ItemStack)output)) && count < output.getMaxStackSize() && count < storage.getSlotLimit(slot)) {
                        ItemStack remainder = NotifiableItemStackHandler.getActioned(storage, slot, recipe.ingredientActions);
                        if (remainder == null) {
                            remainder = storage.insertItem(slot, output, simulate);
                        }
                        if (remainder.getCount() < amount) {
                            changed = true;
                            visited[slot] = output.copyWithCount(count + amount - remainder.getCount());
                        }
                        amount = remainder.getCount();
                    }
                }
                if (amount > 0) continue;
                it.remove();
                break;
            }
            if (amount <= 0) continue;
            if (ingredient instanceof SizedIngredient) {
                SizedIngredient si = (SizedIngredient)ingredient;
                si.setAmount(amount);
                continue;
            }
            items[0].setCount(amount);
        }
        storage.setOnContentsChanged(listener);
        if (changed && !simulate) {
            listener.run();
        }
        return left.isEmpty() ? null : left;
    }

    @Nullable
    private static ItemStack getActioned(CustomItemStackHandler storage, int index, List<?> actions) {
        if (!GTCEu.Mods.isKubeJSLoaded()) {
            return null;
        }
        ItemStack actioned = KJSCallWrapper.applyIngredientAction(storage, index, actions);
        if (!actioned.isEmpty()) {
            return actioned;
        }
        return null;
    }

    @Override
    public RecipeCapability<Ingredient> getCapability() {
        return ItemRecipeCapability.CAP;
    }

    public int getSlots() {
        return this.storage.getSlots();
    }

    @Override
    public int getSize() {
        return this.getSlots();
    }

    @Override
    @NotNull
    public List<Object> getContents() {
        ArrayList<ItemStack> stacks = new ArrayList<ItemStack>();
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            stacks.add(stack);
        }
        return new ArrayList<Object>(stacks);
    }

    @Override
    public double getTotalContentAmount() {
        long amount = 0L;
        for (int i = 0; i < this.getSlots(); ++i) {
            ItemStack stack = this.getStackInSlot(i);
            if (stack.isEmpty()) continue;
            amount += (long)stack.getCount();
        }
        return amount;
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (int i = 0; i < this.storage.getSlots(); ++i) {
                if (this.storage.getStackInSlot(i).isEmpty()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    public void exportToNearby(Direction ... facings) {
        if (this.isEmpty()) {
            return;
        }
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            Predicate<ItemStack> filter = this.getMachine().getItemCapFilter(facing, IO.OUT);
            GTTransferUtils.getAdjacentItemHandler(level, pos, facing).ifPresent(adj -> GTTransferUtils.transferItemsFiltered((IItemHandler)this, adj, filter));
        }
    }

    public void importFromNearby(Direction ... facings) {
        Level level = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        for (Direction facing : facings) {
            Predicate<ItemStack> filter = this.getMachine().getItemCapFilter(facing, IO.IN);
            GTTransferUtils.getAdjacentItemHandler(level, pos, facing).ifPresent(adj -> GTTransferUtils.transferItemsFiltered(adj, (IItemHandler)this, filter));
        }
    }

    @NotNull
    public ItemStack getStackInSlot(int slot) {
        return this.storage.getStackInSlot(slot);
    }

    public void setStackInSlot(int index, @NotNull ItemStack stack) {
        this.storage.setStackInSlot(index, stack);
    }

    @NotNull
    public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate) {
        if (this.canCapInput()) {
            return this.storage.insertItem(slot, stack, simulate);
        }
        return stack;
    }

    public ItemStack insertItemInternal(int slot, @NotNull ItemStack stack, boolean simulate) {
        return this.storage.insertItem(slot, stack, simulate);
    }

    @NotNull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.canCapOutput()) {
            return this.storage.extractItem(slot, amount, simulate);
        }
        return ItemStack.EMPTY;
    }

    public ItemStack extractItemInternal(int slot, int amount, boolean simulate) {
        return this.storage.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.storage.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @NotNull ItemStack stack) {
        return this.storage.isItemValid(slot, stack);
    }

    @Override
    @Generated
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Override
    @Generated
    public IO getCapabilityIO() {
        return this.capabilityIO;
    }

    @Override
    @Generated
    public boolean shouldSearchContent() {
        return this.shouldSearchContent;
    }

    @NotNull
    @Generated
    public NotifiableItemStackHandler shouldSearchContent(boolean shouldSearchContent) {
        this.shouldSearchContent = shouldSearchContent;
        return this;
    }

    public static class KJSCallWrapper {
        public static ItemStack applyIngredientAction(CustomItemStackHandler storage, int index, List<IngredientAction> ingredientActions) {
            ItemStack stack = storage.getStackInSlot(index);
            if (stack.isEmpty()) {
                return ItemStack.EMPTY;
            }
            DummyCraftingContainer container = new DummyCraftingContainer((IItemHandlerModifiable)storage);
            for (IngredientAction action : ingredientActions) {
                if (!action.checkFilter(index, stack)) continue;
                return action.transform(stack.copy(), index, (CraftingContainer)container);
            }
            return ItemStack.EMPTY;
        }
    }
}

