/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.machine.trait;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeHandler;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.IRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.NotifiableRecipeHandlerTrait;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroup;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroupColor;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroupDistinctness;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.lowdragmc.lowdraglib.syncdata.ISubscription;
import it.unimi.dsi.fastutil.objects.ObjectIterator;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;

public class RecipeHandlerList {
    public static final RecipeHandlerList NO_DATA = new RecipeHandlerList(IO.NONE);
    public static final Comparator<RecipeHandlerList> COMPARATOR = (h1, h2) -> {
        int cmp = Long.compare(h1.getPriority(), h2.getPriority());
        if (cmp != 0) {
            return cmp;
        }
        boolean b1 = h1.getTotalContentAmount() > 0.0;
        boolean b2 = h2.getTotalContentAmount() > 0.0;
        return Boolean.compare(b1, b2);
    };
    private final Map<RecipeCapability<?>, List<IRecipeHandler<?>>> handlerMap = new Reference2ObjectOpenHashMap();
    private final List<IRecipeHandler<?>> allHandlers = new ArrayList();
    private final List<NotifiableRecipeHandlerTrait<?>> allHandlerTraits = new ArrayList();
    private final IO handlerIO;
    private int color = -1;
    @NotNull
    private RecipeHandlerGroup group = RecipeHandlerGroupColor.UNDYED;

    protected RecipeHandlerList(IO handlerIO) {
        this.handlerIO = handlerIO;
    }

    public static RecipeHandlerList of(IO io, int color, IRecipeHandler<?> ... handlers) {
        RecipeHandlerList rhl = new RecipeHandlerList(io);
        rhl.addHandlers(handlers);
        rhl.setColor(color);
        return rhl;
    }

    public static RecipeHandlerList of(IO io, IRecipeHandler<?> ... handlers) {
        RecipeHandlerList rhl = new RecipeHandlerList(io);
        rhl.addHandlers(handlers);
        return rhl;
    }

    public static RecipeHandlerList of(IO io, Iterable<IRecipeHandler<?>> handlers) {
        RecipeHandlerList rhl = new RecipeHandlerList(io);
        rhl.addHandlers(handlers);
        return rhl;
    }

    public static RecipeHandlerList of(IO io, int color, Iterable<IRecipeHandler<?>> handlers) {
        RecipeHandlerList rhl = new RecipeHandlerList(io);
        rhl.addHandlers(handlers);
        rhl.setColor(color);
        return rhl;
    }

    public void addHandler(IRecipeHandler<?> handler) {
        this.addHandlers(List.of(handler));
    }

    public void addHandlers(IRecipeHandler<?> ... handlers) {
        this.addHandlers(Arrays.asList(handlers));
    }

    public void addHandlers(Iterable<IRecipeHandler<?>> handlers) {
        for (IRecipeHandler<?> handler : handlers) {
            this.getHandlerMap().computeIfAbsent(handler.getCapability(), c -> new ArrayList()).add(handler);
            this.allHandlers.add(handler);
            if (!(handler instanceof NotifiableRecipeHandlerTrait)) continue;
            NotifiableRecipeHandlerTrait rht = (NotifiableRecipeHandlerTrait)handler;
            this.allHandlerTraits.add(rht);
        }
        if (this.handlerIO.support(IO.OUT)) {
            this.sort();
        }
    }

    private void sort() {
        for (List<IRecipeHandler<?>> list : this.getHandlerMap().values()) {
            list.sort(IRecipeHandler.ENTRY_COMPARATOR);
        }
    }

    public final void setDistinctAndNotify(boolean distinct) {
        this.setDistinct(distinct, true);
    }

    public final void setDistinct(boolean distinct) {
        this.setDistinct(distinct, false);
    }

    protected void setDistinct(boolean distinct, boolean notify) {
        boolean currentDistinct = this.isDistinct();
        if (currentDistinct != distinct) {
            this.group = currentDistinct ? new RecipeHandlerGroupColor(this.color) : RecipeHandlerGroupDistinctness.BUS_DISTINCT;
            for (NotifiableRecipeHandlerTrait<?> rht : this.allHandlerTraits) {
                rht.setDistinct(distinct);
                if (!notify) continue;
                rht.notifyListeners();
            }
        }
    }

    public boolean isDistinct() {
        return this.group == RecipeHandlerGroupDistinctness.BUS_DISTINCT;
    }

    public void setColor(int color) {
        this.setColor(color, false);
    }

    public void setColor(int color, boolean notify) {
        this.color = color;
        if (this.group != RecipeHandlerGroupDistinctness.BUS_DISTINCT) {
            this.group = new RecipeHandlerGroupColor(color);
        }
        if (notify) {
            for (NotifiableRecipeHandlerTrait<?> rht : this.allHandlerTraits) {
                rht.notifyListeners();
            }
        }
    }

    public boolean hasCapability(RecipeCapability<?> cap) {
        return this.getHandlerMap().containsKey(cap);
    }

    @NotNull
    public List<IRecipeHandler<?>> getCapability(RecipeCapability<?> cap) {
        return this.getHandlerMap().getOrDefault(cap, Collections.emptyList());
    }

    @NotNull
    public Set<RecipeCapability<?>> getCapabilities() {
        return this.getHandlerMap().keySet();
    }

    public boolean doesCapabilityBypassDistinct() {
        for (RecipeCapability<?> capability : this.getCapabilities()) {
            if (!capability.shouldBypassDistinct()) continue;
            return true;
        }
        return false;
    }

    public boolean isValid(IO extIO) {
        if (this == NO_DATA || this.handlerIO == IO.NONE) {
            return false;
        }
        return extIO == IO.BOTH || this.handlerIO == IO.BOTH || extIO == this.handlerIO;
    }

    public long getPriority() {
        long priority = 0L;
        for (IRecipeHandler<?> handler : this.allHandlers) {
            priority += (long)handler.getPriority();
        }
        return priority;
    }

    public double getTotalContentAmount() {
        double sum = 0.0;
        for (IRecipeHandler<?> handler : this.allHandlers) {
            sum += handler.getTotalContentAmount();
        }
        return sum;
    }

    @Contract(pure=true)
    public Map<RecipeCapability<?>, List<Object>> handleRecipe(IO io, GTRecipe recipe, Map<RecipeCapability<?>, List<Object>> contents, boolean simulate) {
        if (this.getHandlerMap().isEmpty()) {
            return contents;
        }
        Reference2ObjectOpenHashMap copy = new Reference2ObjectOpenHashMap(contents);
        ObjectIterator it = copy.reference2ObjectEntrySet().fastIterator();
        block0: while (it.hasNext()) {
            Reference2ObjectMap.Entry entry = (Reference2ObjectMap.Entry)it.next();
            List<IRecipeHandler<?>> handlerList = this.getCapability((RecipeCapability)entry.getKey());
            for (IRecipeHandler<?> handler : handlerList) {
                List<?> left = handler.handleRecipe(io, recipe, (List)entry.getValue(), simulate);
                if (left == null) {
                    it.remove();
                    continue block0;
                }
                entry.setValue(new ArrayList(left));
            }
        }
        return copy;
    }

    public ISubscription subscribe(Runnable listener) {
        ArrayList<ISubscription> subs = new ArrayList<ISubscription>(this.allHandlerTraits.size());
        this.allHandlerTraits.forEach(rht -> subs.add(rht.addChangedListener(listener)));
        return new Subscription(subs);
    }

    public ISubscription subscribe(Runnable listener, RecipeCapability<?> cap) {
        List<IRecipeHandler<?>> capList = this.getCapability(cap);
        ArrayList<ISubscription> subs = new ArrayList<ISubscription>(capList.size());
        for (IRecipeHandler<?> handler : capList) {
            if (!(handler instanceof IRecipeHandlerTrait)) continue;
            IRecipeHandlerTrait trait = (IRecipeHandlerTrait)handler;
            subs.add(trait.addChangedListener(listener));
        }
        return new Subscription(subs);
    }

    @Generated
    public Map<RecipeCapability<?>, List<IRecipeHandler<?>>> getHandlerMap() {
        return this.handlerMap;
    }

    @Generated
    public IO getHandlerIO() {
        return this.handlerIO;
    }

    @Generated
    public int getColor() {
        return this.color;
    }

    @Generated
    public void setGroup(@NotNull RecipeHandlerGroup group) {
        if (group == null) {
            throw new NullPointerException("group is marked non-null but is null");
        }
        this.group = group;
    }

    @NotNull
    @Generated
    public RecipeHandlerGroup getGroup() {
        return this.group;
    }

    private record Subscription(List<ISubscription> subs) implements ISubscription
    {
        public void unsubscribe() {
            this.subs.forEach(ISubscription::unsubscribe);
        }
    }
}

