/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.gregtechceu.gtceu.GTCEu;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;

public class ImageCache {
    public static final long REFRESH_SECS = 120L;
    public static final long EXPIRE_SECS = 300L;
    private static final byte[] NULL_MARKER = new byte[0];
    private static boolean downloading = false;
    private static final LoadingCache<String, byte[]> CACHE = CacheBuilder.newBuilder().refreshAfterWrite(120L, TimeUnit.SECONDS).expireAfterAccess(300L, TimeUnit.SECONDS).concurrencyLevel(3).build(CacheLoader.from(url -> {
        if (downloading) {
            return NULL_MARKER;
        }
        downloading = true;
        try {
            byte[] byArray;
            block12: {
                InputStream stream = new URL((String)url).openStream();
                try {
                    byArray = stream.readAllBytes();
                    if (stream == null) break block12;
                }
                catch (Throwable throwable) {
                    try {
                        if (stream != null) {
                            try {
                                stream.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        GTCEu.LOGGER.error("Could not load image {}", url, (Object)e);
                        downloading = false;
                        byte[] byArray2 = NULL_MARKER;
                        return byArray2;
                    }
                }
                stream.close();
            }
            return byArray;
        }
        finally {
            GTCEu.LOGGER.debug("Downloaded image {}! Executing callback", url);
            downloading = false;
        }
    }));

    public static void queryServerImage(String url, Consumer<byte[]> callback) {
        try {
            if (downloading) {
                return;
            }
            byte[] image = (byte[])CACHE.get((Object)url);
            if (image != NULL_MARKER) {
                callback.accept(image);
            } else {
                CACHE.invalidate((Object)url);
            }
        }
        catch (ExecutionException e) {
            Throwable t = e;
            if (t.getCause() != null) {
                t = t.getCause();
            }
            GTCEu.LOGGER.error("Could not load image {}", (Object)url, (Object)t);
        }
    }
}

