/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc.virtualregistry;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.misc.virtualregistry.EntryTypes;
import com.gregtechceu.gtceu.api.misc.virtualregistry.VirtualEntry;
import com.gregtechceu.gtceu.api.misc.virtualregistry.VirtualRegistryMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraftforge.server.ServerLifecycleHooks;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VirtualEnderRegistry
extends SavedData {
    private static final String DATA_ID = "gtceu.virtual_entry_data";
    private static final String PUBLIC_KEY = "Public";
    private static final String PRIVATE_KEY = "Private";
    private static volatile VirtualEnderRegistry data;
    private final Map<UUID, VirtualRegistryMap> VIRTUAL_REGISTRIES = new HashMap<UUID, VirtualRegistryMap>();

    public VirtualEnderRegistry() {
    }

    public VirtualEnderRegistry(CompoundTag name) {
        this.readFromNBT(name);
    }

    public static VirtualEnderRegistry getInstance() {
        MinecraftServer server;
        if (data == null && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            data = (VirtualEnderRegistry)server.overworld().getDataStorage().computeIfAbsent(VirtualEnderRegistry::new, VirtualEnderRegistry::new, DATA_ID);
        }
        return data;
    }

    public static void release() {
        if (data != null) {
            data = null;
            GTCEu.LOGGER.debug("VirtualEnderRegistry has been unloaded");
        }
    }

    public <T extends VirtualEntry> T getEntry(@Nullable UUID owner, EntryTypes<T> type, String name) {
        return this.getRegistry(owner).getEntry(type, name);
    }

    public void addEntry(@Nullable UUID owner, String name, VirtualEntry entry) {
        this.getRegistry(owner).addEntry(name, entry);
    }

    public boolean hasEntry(@Nullable UUID owner, EntryTypes<?> type, String name) {
        return this.getRegistry(owner).contains(type, name);
    }

    @NotNull
    public <T extends VirtualEntry> T getOrCreateEntry(@Nullable UUID owner, EntryTypes<T> type, String name) {
        if (!this.hasEntry(owner, type, name)) {
            this.addEntry(owner, name, (VirtualEntry)type.createInstance());
        }
        return this.getEntry(owner, type, name);
    }

    public void deleteEntry(@Nullable UUID owner, EntryTypes<?> type, String name) {
        VirtualRegistryMap registry = this.getRegistry(owner);
        if (registry.contains(type, name)) {
            registry.deleteEntry(type, name);
            return;
        }
        GTCEu.LOGGER.warn("Attempted to delete {} entry {} of type {}, which does not exist", (Object)(owner == null ? "public" : String.format("private [%s]", owner)), (Object)name, type);
    }

    public <T extends VirtualEntry> void deleteEntryIf(@Nullable UUID owner, EntryTypes<T> type, String name, Predicate<T> shouldDelete) {
        T entry = this.getEntry(owner, type, name);
        if (entry != null && shouldDelete.test(entry)) {
            this.deleteEntry(owner, type, name);
        }
    }

    public Set<String> getEntryNames(UUID owner, EntryTypes<?> type) {
        return this.getRegistry(owner).getEntryNames(type);
    }

    private VirtualRegistryMap getRegistry(UUID owner) {
        if (data == null) {
            VirtualEnderRegistry.getInstance();
        }
        return VirtualEnderRegistry.data.VIRTUAL_REGISTRIES.computeIfAbsent(owner, key -> new VirtualRegistryMap());
    }

    public final void readFromNBT(CompoundTag nbt) {
        if (nbt.contains(PUBLIC_KEY)) {
            this.VIRTUAL_REGISTRIES.put(null, new VirtualRegistryMap(nbt.getCompound(PUBLIC_KEY)));
        }
        if (nbt.contains(PRIVATE_KEY)) {
            CompoundTag privateEntries = nbt.getCompound(PRIVATE_KEY);
            for (String owner : privateEntries.getAllKeys()) {
                CompoundTag privateMap = privateEntries.getCompound(owner);
                this.VIRTUAL_REGISTRIES.put(UUID.fromString(owner), new VirtualRegistryMap(privateMap));
            }
        }
    }

    @NotNull
    public final CompoundTag save(@NotNull CompoundTag tag) {
        CompoundTag privateTag = new CompoundTag();
        for (UUID owner : this.VIRTUAL_REGISTRIES.keySet()) {
            CompoundTag mapTag = this.VIRTUAL_REGISTRIES.get(owner).serializeNBT();
            if (owner != null) {
                privateTag.put(owner.toString(), (Tag)mapTag);
                continue;
            }
            tag.put(PUBLIC_KEY, (Tag)mapTag);
        }
        tag.put(PRIVATE_KEY, (Tag)privateTag);
        return tag;
    }

    public boolean isDirty() {
        return true;
    }
}

