/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.misc.virtualregistry.entries;

import com.gregtechceu.gtceu.api.misc.virtualregistry.EntryTypes;
import com.gregtechceu.gtceu.api.misc.virtualregistry.VirtualEntry;
import it.unimi.dsi.fastutil.objects.Object2ShortMap;
import it.unimi.dsi.fastutil.objects.Object2ShortOpenHashMap;
import java.util.UUID;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;

public class VirtualRedstone
extends VirtualEntry {
    private static final String MEMBERS_KEY = "members";
    private final Object2ShortMap<UUID> members = new Object2ShortOpenHashMap();

    public int getSignal() {
        return this.members.values().intStream().max().orElse(0);
    }

    public void addMember(UUID uuid) {
        this.members.put((Object)uuid, (short)0);
    }

    public void setSignal(UUID uuid, int signal) {
        if (!this.members.containsKey((Object)uuid)) {
            return;
        }
        this.members.put((Object)uuid, (short)signal);
    }

    public void removeMember(UUID uuid) {
        this.members.removeShort((Object)uuid);
    }

    @Override
    public EntryTypes<? extends VirtualEntry> getType() {
        return EntryTypes.ENDER_REDSTONE;
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        CompoundTag tag2 = new CompoundTag();
        for (Object2ShortMap.Entry entry : this.members.object2ShortEntrySet()) {
            tag2.putShort(((UUID)entry.getKey()).toString(), entry.getShortValue());
        }
        tag.put(MEMBERS_KEY, (Tag)tag2);
        return tag;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        super.deserializeNBT(nbt);
        CompoundTag tag = nbt.getCompound(MEMBERS_KEY);
        for (String uuid : tag.getAllKeys()) {
            this.members.put((Object)UUID.fromString(uuid), tag.getShort(uuid));
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof VirtualRedstone)) {
            return false;
        }
        VirtualRedstone other = (VirtualRedstone)o;
        return other.members == this.members;
    }

    @Override
    public boolean canRemove() {
        return super.canRemove() && this.members.isEmpty();
    }

    @Generated
    public Object2ShortMap<UUID> getMembers() {
        return this.members;
    }
}

