/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.ActiveBlock;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.pattern.MultiblockWorldSavedData;
import com.gregtechceu.gtceu.api.pattern.TraceabilityPredicate;
import com.gregtechceu.gtceu.api.pattern.error.PatternError;
import com.gregtechceu.gtceu.api.pattern.error.PatternStringError;
import com.gregtechceu.gtceu.api.pattern.predicates.SimplePredicate;
import com.gregtechceu.gtceu.api.pattern.util.PatternMatchContext;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.longs.LongSet;
import it.unimi.dsi.fastutil.longs.LongSets;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.Collection;
import java.util.stream.Collectors;
import lombok.Generated;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class MultiblockState {
    public static final PatternError UNLOAD_ERROR = new PatternStringError("multiblocked.pattern.error.chunk");
    public static final PatternError UNINIT_ERROR = new PatternStringError("multiblocked.pattern.error.init");
    private BlockPos pos;
    private BlockState blockState;
    private BlockEntity tileEntity;
    private boolean tileEntityInitialized;
    private final PatternMatchContext matchContext;
    private Object2IntOpenHashMap<SimplePredicate> globalCount;
    private Object2IntOpenHashMap<SimplePredicate> layerCount;
    public TraceabilityPredicate predicate;
    public IO io;
    public PatternError error;
    private boolean neededFlip = false;
    public final Level world;
    public final BlockPos controllerPos;
    public IMultiController lastController;
    public LongOpenHashSet cache;

    public MultiblockState(Level world, BlockPos controllerPos) {
        this.world = world;
        this.controllerPos = controllerPos;
        this.error = UNINIT_ERROR;
        this.matchContext = new PatternMatchContext();
    }

    public void clean() {
        this.matchContext.reset();
        this.globalCount = new Object2IntOpenHashMap();
        this.layerCount = new Object2IntOpenHashMap();
        this.cache = new LongOpenHashSet();
    }

    public boolean update(BlockPos posIn, TraceabilityPredicate predicate) {
        this.pos = posIn;
        this.blockState = null;
        this.tileEntity = null;
        this.tileEntityInitialized = false;
        this.predicate = predicate;
        this.error = null;
        if (!this.world.isLoaded(posIn)) {
            this.error = UNLOAD_ERROR;
            return false;
        }
        return true;
    }

    public IMultiController getController() {
        if (this.world.isLoaded(this.controllerPos)) {
            IMachineBlockEntity machineBlockEntity;
            Object object = this.world.getBlockEntity(this.controllerPos);
            if (object instanceof IMachineBlockEntity && (object = (machineBlockEntity = (IMachineBlockEntity)object).getMetaMachine()) instanceof IMultiController) {
                IMultiController controller;
                this.lastController = controller = (IMultiController)object;
                return this.lastController;
            }
        } else {
            this.error = UNLOAD_ERROR;
        }
        return null;
    }

    public boolean hasError() {
        return this.error != null;
    }

    public void setError(PatternError error) {
        this.error = error;
        if (error != null) {
            error.setWorldState(this);
        }
    }

    public BlockState getBlockState() {
        if (this.blockState == null) {
            this.blockState = this.world.getBlockState(this.pos);
        }
        if (this.blockState == null) {
            GTCEu.LOGGER.error("could not get BlockState at " + String.valueOf(this.pos) + " in MultiblockState");
        }
        return this.blockState;
    }

    @Nullable
    public BlockEntity getTileEntity() {
        if (!this.getBlockState().hasBlockEntity()) {
            return null;
        }
        if (this.tileEntity == null && !this.tileEntityInitialized) {
            this.tileEntity = this.world.getBlockEntity(this.pos);
            this.tileEntityInitialized = true;
        }
        return this.tileEntity;
    }

    public BlockPos getPos() {
        return this.pos.immutable();
    }

    public BlockState getOffsetState(Direction face) {
        if (this.pos instanceof BlockPos.MutableBlockPos) {
            ((BlockPos.MutableBlockPos)this.pos).move(face);
            BlockState blockState = this.world.getBlockState(this.pos);
            ((BlockPos.MutableBlockPos)this.pos).move(face.getOpposite());
            return blockState;
        }
        return this.world.getBlockState(this.pos.relative(face));
    }

    public Level getWorld() {
        return this.world;
    }

    public void addPosCache(BlockPos pos) {
        this.cache.add(pos.asLong());
    }

    public boolean isPosInCache(BlockPos pos) {
        return this.cache.contains(pos.asLong());
    }

    public Collection<BlockPos> getCache() {
        return this.cache.longStream().mapToObj(BlockPos::of).collect(Collectors.toSet());
    }

    public void onBlockStateChanged(BlockPos pos, BlockState state) {
        Level level = this.world;
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            if (pos.equals((Object)this.controllerPos)) {
                if (this.lastController != null && !state.is(this.lastController.self().getBlockState().getBlock())) {
                    this.lastController.onStructureInvalid();
                    MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
                    mwsd.removeMapping(this);
                }
            } else {
                IMultiController controller = this.getController();
                if (controller == null && this.error == UNLOAD_ERROR && !serverLevel.isLoaded(this.controllerPos)) {
                    GTCEu.LOGGER.info("Controller not loaded, pos {}", (Object)this.controllerPos);
                }
                if (controller != null) {
                    LongSet activeBlocks;
                    if (controller.isFormed() && state.getBlock() instanceof ActiveBlock && (activeBlocks = this.getMatchContext().getOrDefault("vaBlocks", LongSets.emptySet())).contains(pos.asLong())) {
                        return;
                    }
                    if (controller.checkPatternWithLock()) {
                        controller.self().setFlipped(this.neededFlip);
                        controller.onStructureFormed();
                    } else {
                        controller.self().setFlipped(false);
                        controller.onStructureInvalid();
                        MultiblockWorldSavedData mwsd = MultiblockWorldSavedData.getOrCreate(serverLevel);
                        mwsd.removeMapping(this);
                        mwsd.addAsyncLogic(controller);
                    }
                }
            }
        }
    }

    @Generated
    public PatternMatchContext getMatchContext() {
        return this.matchContext;
    }

    @Generated
    public Object2IntOpenHashMap<SimplePredicate> getGlobalCount() {
        return this.globalCount;
    }

    @Generated
    public Object2IntOpenHashMap<SimplePredicate> getLayerCount() {
        return this.layerCount;
    }

    @Generated
    public boolean isNeededFlip() {
        return this.neededFlip;
    }

    @Generated
    public void setNeededFlip(boolean neededFlip) {
        this.neededFlip = neededFlip;
    }
}

