/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pattern.util;

import com.gregtechceu.gtceu.utils.GTUtil;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

public enum RelativeDirection implements StringRepresentable
{
    UP(dir -> dir.getAxis() == Direction.Axis.Y ? Direction.NORTH : Direction.UP, Direction.UP),
    DOWN(dir -> dir.getAxis() == Direction.Axis.Y ? Direction.SOUTH : Direction.DOWN, Direction.DOWN),
    LEFT(dir -> {
        if (dir == Direction.UP) {
            return Direction.EAST;
        }
        if (dir == Direction.DOWN) {
            return Direction.WEST;
        }
        return dir.getCounterClockWise();
    }, Direction.WEST),
    RIGHT(dir -> {
        if (dir == Direction.UP) {
            return Direction.WEST;
        }
        if (dir == Direction.DOWN) {
            return Direction.EAST;
        }
        return dir.getClockWise();
    }, Direction.EAST),
    FRONT(UnaryOperator.identity(), Direction.NORTH),
    BACK(Direction::getOpposite, Direction.SOUTH);

    public static final StringRepresentable.EnumCodec<RelativeDirection> CODEC;
    public static final RelativeDirection[] VALUES;
    private static final RelativeDirection[] BY_GLOBAL_DIRECTION;
    private final UnaryOperator<Direction> actualDirection;
    public final Direction global;

    private RelativeDirection(UnaryOperator<Direction> actualDirection, Direction global) {
        this.actualDirection = actualDirection;
        this.global = global;
    }

    @NotNull
    public String getSerializedName() {
        return this.name().toLowerCase(Locale.ROOT);
    }

    public RelativeDirection getOpposite() {
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case UP -> DOWN;
            case DOWN -> UP;
            case LEFT -> RIGHT;
            case RIGHT -> LEFT;
            case FRONT -> BACK;
            case BACK -> FRONT;
        };
    }

    public Direction getActualDirection(Direction direction) {
        return (Direction)this.actualDirection.apply(direction);
    }

    public boolean isSameAxis(RelativeDirection other) {
        return this.global.getAxis() == other.global.getAxis();
    }

    public Vec3i applyVec3i(Direction facing) {
        return this.getActualDirection(facing).getNormal();
    }

    @Deprecated(since="7.0.0", forRemoval=true)
    @ApiStatus.ScheduledForRemoval(inVersion="8.0.0")
    public Direction getRelativeFacing(Direction frontFacing, Direction upwardsFacing, boolean isFlipped) {
        return this.getRelative(frontFacing, upwardsFacing, isFlipped);
    }

    public Direction getRelative(Direction frontDir, Direction upwardsDir, boolean isFlipped) {
        Direction.Axis frontAxis = frontDir.getAxis();
        return switch (this) {
            default -> throw new IncompatibleClassChangeError();
            case UP -> {
                if (frontAxis == Direction.Axis.Y) {
                    yield upwardsDir;
                }
                switch (upwardsDir) {
                    case NORTH: {
                        yield Direction.UP;
                    }
                    case SOUTH: {
                        yield Direction.DOWN;
                    }
                    case EAST: {
                        yield frontDir.getCounterClockWise();
                    }
                }
                yield frontDir.getClockWise();
            }
            case DOWN -> {
                if (frontAxis == Direction.Axis.Y) {
                    yield upwardsDir.getOpposite();
                }
                switch (upwardsDir) {
                    case NORTH: {
                        yield Direction.DOWN;
                    }
                    case SOUTH: {
                        yield Direction.UP;
                    }
                    case EAST: {
                        yield frontDir.getClockWise();
                    }
                }
                yield frontDir.getCounterClockWise();
            }
            case LEFT -> {
                Direction direction;
                if (frontAxis == Direction.Axis.Y) {
                    direction = frontDir.getStepY() > 0 ? upwardsDir.getClockWise() : upwardsDir.getCounterClockWise();
                } else {
                    switch (upwardsDir) {
                        case NORTH: {
                            Direction v1 = frontDir.getCounterClockWise();
                            break;
                        }
                        case SOUTH: {
                            Direction v1 = frontDir.getClockWise();
                            break;
                        }
                        case EAST: {
                            Direction v1 = Direction.DOWN;
                            break;
                        }
                        default: {
                            Direction v1 = direction = Direction.UP;
                        }
                    }
                }
                if (isFlipped) {
                    yield direction.getOpposite();
                }
                yield direction;
            }
            case RIGHT -> {
                Direction direction;
                if (frontAxis == Direction.Axis.Y) {
                    direction = frontDir.getStepY() > 0 ? upwardsDir.getCounterClockWise() : upwardsDir.getClockWise();
                } else {
                    switch (upwardsDir) {
                        case NORTH: {
                            Direction v2 = frontDir.getClockWise();
                            break;
                        }
                        case SOUTH: {
                            Direction v2 = frontDir.getCounterClockWise();
                            break;
                        }
                        case EAST: {
                            Direction v2 = Direction.UP;
                            break;
                        }
                        default: {
                            Direction v2 = direction = Direction.DOWN;
                        }
                    }
                }
                if (isFlipped) {
                    yield direction.getOpposite();
                }
                yield direction;
            }
            case FRONT -> frontDir;
            case BACK -> frontDir.getOpposite();
        };
    }

    public Comparator<BlockPos> getSorter(Direction frontDir, Direction upwardsDir, boolean isFlipped) {
        Direction sorterDirection = this.getRelative(frontDir, upwardsDir, isFlipped);
        return switch (sorterDirection) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.UP -> Comparator.comparingInt(Vec3i::getY);
            case Direction.DOWN -> Comparator.comparingInt(pos -> -pos.getY());
            case Direction.NORTH -> Comparator.comparingInt(pos -> -pos.getZ());
            case Direction.EAST -> Comparator.comparingInt(Vec3i::getX);
            case Direction.SOUTH -> Comparator.comparingInt(Vec3i::getZ);
            case Direction.WEST -> Comparator.comparingInt(pos -> -pos.getX());
        };
    }

    public static Direction simulateAxisRotation(Direction newFrontDir, Direction oldFrontDir, Direction upwardsDir) {
        if (newFrontDir == oldFrontDir) {
            return upwardsDir;
        }
        Direction.Axis newAxis = newFrontDir.getAxis();
        Direction.Axis oldAxis = oldFrontDir.getAxis();
        if (newAxis != Direction.Axis.Y && oldAxis != Direction.Axis.Y) {
            return upwardsDir;
        }
        if (newAxis == Direction.Axis.Y && oldAxis != Direction.Axis.Y) {
            Direction newUpwardsDir = switch (upwardsDir) {
                case Direction.NORTH -> oldFrontDir.getOpposite();
                case Direction.SOUTH -> oldFrontDir;
                case Direction.EAST -> oldFrontDir.getCounterClockWise();
                default -> oldFrontDir.getClockWise();
            };
            return newFrontDir == Direction.DOWN && upwardsDir.getAxis() == Direction.Axis.Z ? newUpwardsDir.getOpposite() : newUpwardsDir;
        }
        if (newAxis != Direction.Axis.Y) {
            Direction newUpwardsDir = upwardsDir == newFrontDir ? Direction.SOUTH : (upwardsDir == newFrontDir.getOpposite() ? Direction.NORTH : (upwardsDir == newFrontDir.getClockWise() ? Direction.WEST : Direction.EAST));
            return oldFrontDir == Direction.DOWN && newUpwardsDir.getAxis() == Direction.Axis.Z ? newUpwardsDir.getOpposite() : newUpwardsDir;
        }
        return upwardsDir.getOpposite();
    }

    public static BlockPos offsetPos(BlockPos pos, Direction frontDir, Direction upwardsDir, boolean isFlipped, int upOffset, int leftOffset, int forwardOffset) {
        if (upOffset == 0 && leftOffset == 0 && forwardOffset == 0) {
            return pos;
        }
        int oX = 0;
        int oY = 0;
        int oZ = 0;
        Direction relUp = UP.getRelative(frontDir, upwardsDir, isFlipped);
        oX += relUp.getStepX() * upOffset;
        oY += relUp.getStepY() * upOffset;
        oZ += relUp.getStepZ() * upOffset;
        Direction relLeft = LEFT.getRelative(frontDir, upwardsDir, isFlipped);
        oX += relLeft.getStepX() * leftOffset;
        oY += relLeft.getStepY() * leftOffset;
        oZ += relLeft.getStepZ() * leftOffset;
        Direction relForward = FRONT.getRelative(frontDir, upwardsDir, isFlipped);
        return pos.offset(oX += relForward.getStepX() * forwardOffset, oY += relForward.getStepY() * forwardOffset, oZ += relForward.getStepZ() * forwardOffset);
    }

    public static RelativeDirection fromGlobalDirection(Direction direction) {
        return BY_GLOBAL_DIRECTION[direction.ordinal()];
    }

    public static Direction getActualDirection(Direction original, Direction current, Direction direction) {
        return RelativeDirection.findRelativeOf(original, current).getActualDirection(direction);
    }

    public static RelativeDirection findRelativeOf(Direction baseDir, Direction relativeDir) {
        return RelativeDirection.findRelativeOf(baseDir, relativeDir, Direction.NORTH);
    }

    public static RelativeDirection findRelativeOf(Direction baseDir, Direction relativeDir, Direction upwardsDir) {
        if (baseDir == relativeDir) {
            return FRONT;
        }
        if (baseDir.getOpposite() == relativeDir) {
            return BACK;
        }
        if (baseDir.getAxis().isHorizontal()) {
            if (relativeDir == Direction.UP) {
                return UP;
            }
            if (relativeDir == Direction.DOWN) {
                return DOWN;
            }
            if (relativeDir == baseDir.getCounterClockWise()) {
                return LEFT;
            }
            return RIGHT;
        }
        if (upwardsDir.getAxis() == Direction.Axis.Y) {
            throw new IllegalStateException("upwardsDir must be a horizontal direction! is " + String.valueOf(upwardsDir));
        }
        if (relativeDir == upwardsDir.getCounterClockWise()) {
            return LEFT;
        }
        if (relativeDir == upwardsDir.getClockWise()) {
            return RIGHT;
        }
        RelativeDirection dir = relativeDir == upwardsDir.getOpposite() ? UP : DOWN;
        if (baseDir == Direction.DOWN) {
            dir = dir.getOpposite();
        }
        return dir;
    }

    static {
        CODEC = StringRepresentable.fromEnum(RelativeDirection::values);
        VALUES = RelativeDirection.values();
        BY_GLOBAL_DIRECTION = new RelativeDirection[GTUtil.DIRECTIONS.length];
        RelativeDirection[] relativeDirectionArray = VALUES;
        int n = relativeDirectionArray.length;
        for (int i = 0; i < n; ++i) {
            RelativeDirection relative;
            RelativeDirection.BY_GLOBAL_DIRECTION[relative.global.ordinal()] = relative = relativeDirectionArray[i];
        }
    }
}

