/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.block.PipeBlock;
import com.gregtechceu.gtceu.api.blockentity.IPaintable;
import com.gregtechceu.gtceu.api.blockentity.ITickSubscription;
import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.pipenet.LevelPipeNet;
import com.gregtechceu.gtceu.api.pipenet.PipeNet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IPipeNode<PipeType extends Enum<PipeType>, NodeDataType>
extends ITickSubscription,
IPaintable {
    public long getOffsetTimer();

    public ICoverable getCoverContainer();

    default public boolean isBlocked(Direction side) {
        return PipeBlockEntity.isFaceBlocked(this.getBlockedConnections(), side);
    }

    public void setConnections(int var1);

    public int getConnections();

    public int getNumConnections();

    public void setBlocked(Direction var1, boolean var2);

    public boolean canAttachTo(Direction var1);

    public int getVisualConnections();

    default public boolean isConnected(Direction side) {
        return PipeBlockEntity.isConnected(this.getConnections(), side);
    }

    public void setConnection(Direction var1, boolean var2, boolean var3);

    default public boolean canHaveBlockedFaces() {
        return true;
    }

    public int getBlockedConnections();

    default public BlockEntity self() {
        return (BlockEntity)this;
    }

    default public Level getPipeLevel() {
        return this.self().getLevel();
    }

    default public BlockPos getPipePos() {
        return this.self().getBlockPos();
    }

    default public void markAsDirty() {
        this.self().setChanged();
    }

    default public boolean isInValid() {
        return this.self().isRemoved();
    }

    default public boolean isRemote() {
        Level level = this.getPipeLevel();
        if (level == null) {
            return GTCEu.isClientThread();
        }
        return level.isClientSide;
    }

    default public PipeBlock<PipeType, NodeDataType, ?> getPipeBlock() {
        return (PipeBlock)this.self().getBlockState().getBlock();
    }

    @Nullable
    default public PipeNet<NodeDataType> getPipeNet() {
        Level level = this.getPipeLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return ((LevelPipeNet)((Object)this.getPipeBlock().getWorldPipeNet(serverLevel))).getNetFromPos(this.getPipePos());
        }
        return null;
    }

    default public PipeType getPipeType() {
        return this.getPipeBlock().pipeType;
    }

    @Nullable
    default public NodeDataType getNodeData() {
        PipeNet<NodeDataType> net = this.getPipeNet();
        if (net != null) {
            return net.getNodeAt((BlockPos)this.getPipePos()).data;
        }
        return null;
    }

    public void notifyBlockUpdate();

    default public void scheduleRenderUpdate() {
        BlockPos pos = this.getPipePos();
        Level level = this.getPipeLevel();
        if (level != null) {
            BlockState state = level.getBlockState(pos);
            if (level.isClientSide) {
                level.sendBlockUpdated(pos, state, state, 8);
            } else {
                level.blockEvent(pos, state.getBlock(), 1, 0);
            }
        }
    }

    default public void serverTick() {
    }

    default public void scheduleNeighborShapeUpdate() {
        Level level = this.getPipeLevel();
        BlockPos pos = this.getPipePos();
        if (level == null || pos == null) {
            return;
        }
        level.getBlockState(pos).updateNeighbourShapes((LevelAccessor)level, pos, 3);
    }

    default public BlockEntity getNeighbor(Direction direction) {
        return this.getPipeLevel().getBlockEntity(this.getPipePos().relative(direction));
    }

    @Override
    default public int getDefaultPaintingColor() {
        return 0xFFFFFF;
    }

    @NotNull
    public Material getFrameMaterial();
}

