/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet.longdistance;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDNetworkPart;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistancePipeType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface ILDEndpoint
extends ILDNetworkPart {
    @NotNull
    public IO getIoType();

    public void setIoType(IO var1);

    default public boolean isInput() {
        return this.getIoType() == IO.IN;
    }

    default public boolean isOutput() {
        return this.getIoType() == IO.OUT;
    }

    @Nullable
    public ILDEndpoint getLink();

    public void invalidateLink();

    @NotNull
    public Direction getFrontFacing();

    @NotNull
    public Direction getOutputFacing();

    @Override
    @NotNull
    public LongDistancePipeType getPipeType();

    public BlockPos getPos();

    public Level getLevel();

    public boolean isInValid();

    @Nullable
    public static ILDEndpoint tryGet(LevelAccessor world, BlockPos pos) {
        IMachineBlockEntity gte;
        MetaMachine metaMachine;
        BlockEntity te = world.getBlockEntity(pos);
        if (te instanceof IMachineBlockEntity && (metaMachine = (gte = (IMachineBlockEntity)te).getMetaMachine()) instanceof ILDEndpoint) {
            ILDEndpoint endpoint = (ILDEndpoint)((Object)metaMachine);
            return endpoint;
        }
        return null;
    }
}

