/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.pipenet.longdistance;

import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDEndpoint;
import com.gregtechceu.gtceu.api.pipenet.longdistance.ILDNetworkPart;
import com.gregtechceu.gtceu.api.pipenet.longdistance.LongDistanceNetwork;
import com.gregtechceu.gtceu.utils.GTUtil;
import it.unimi.dsi.fastutil.longs.LongOpenHashSet;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkSource;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;

public class NetworkBuilder
extends Thread {
    private final ObjectList<BlockPos> starts = new ObjectArrayList();
    private final LongDistanceNetwork.WorldData worldData;
    private final LongDistanceNetwork originalNetwork;
    private LongDistanceNetwork network;
    private final LevelAccessor world;
    private final ObjectList<BlockPos> currentPoints = new ObjectArrayList();
    private final ObjectOpenHashSet<BlockPos> walked = new ObjectOpenHashSet();
    private final List<BlockPos> pipes = new ArrayList<BlockPos>();
    private final List<ILDEndpoint> endpoints = new ArrayList<ILDEndpoint>();
    private final BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
    private final LongOpenHashSet loadedChunks = new LongOpenHashSet();

    public NetworkBuilder(LongDistanceNetwork.WorldData worldData, LongDistanceNetwork network, Collection<BlockPos> starts) {
        this.worldData = Objects.requireNonNull(worldData);
        this.originalNetwork = Objects.requireNonNull(network);
        this.network = network;
        this.world = worldData.getWorld();
        this.starts.addAll(starts);
    }

    @Override
    public void run() {
        if (this.starts.isEmpty()) {
            return;
        }
        BlockPos start = (BlockPos)this.starts.remove(0);
        this.checkNetwork(start);
        while (!this.starts.isEmpty()) {
            start = (BlockPos)this.starts.remove(0);
            LongDistanceNetwork ldn = this.worldData.getNetwork(start);
            if (ldn == this.originalNetwork) continue;
            this.network = this.network.getPipeType().createNetwork(this.worldData);
            this.currentPoints.clear();
            this.walked.clear();
            this.pipes.clear();
            this.endpoints.clear();
            this.checkNetwork(start);
        }
        LevelAccessor levelAccessor = this.world;
        if (levelAccessor instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)levelAccessor;
            this.loadedChunks.forEach(pos -> {
                int chunkX = ChunkPos.getX((long)pos);
                int chunkZ = ChunkPos.getZ((long)pos);
                serverLevel.setChunkForced(chunkX, chunkZ, false);
            });
        }
    }

    private void checkNetwork(BlockPos start) {
        this.checkPos(this.world.getBlockState(start), start);
        while (!this.currentPoints.isEmpty()) {
            BlockPos current = (BlockPos)this.currentPoints.remove(0);
            for (Direction facing : GTUtil.DIRECTIONS) {
                this.pos.set((Vec3i)current).move(facing);
                if (this.walked.contains((Object)this.pos)) continue;
                BlockState blockState = this.getBlockState((BlockPos)this.pos);
                if (this.world.isEmptyBlock((BlockPos)this.pos)) continue;
                this.checkPos(blockState, (BlockPos)this.pos);
            }
        }
        this.network.setData(this.pipes, this.endpoints);
    }

    private void checkPos(BlockState blockState, BlockPos pos) {
        LongDistanceNetwork network = LongDistanceNetwork.get(this.world, pos);
        if (network != null && network != this.network) {
            network.invalidateNetwork(true);
        }
        BlockPos bp = pos.immutable();
        this.walked.add((Object)bp);
        ILDNetworkPart part = ILDNetworkPart.tryGet(this.world, pos, blockState);
        if (part != null) {
            this.pipes.add(bp);
            if (part instanceof ILDEndpoint) {
                ILDEndpoint endpoint = (ILDEndpoint)part;
                this.endpoints.add(endpoint);
            } else {
                this.currentPoints.add((Object)bp);
            }
        }
    }

    private BlockState getBlockState(BlockPos pos) {
        int z;
        int x;
        if (this.world.isOutsideBuildHeight(pos)) {
            return Blocks.AIR.defaultBlockState();
        }
        ChunkSource chunkProvider = this.world.getChunkSource();
        LevelChunk chunk = chunkProvider.getChunkNow(x = pos.getX() >> 4, z = pos.getZ() >> 4);
        if (chunk == null) {
            if (!chunkProvider.hasChunk(x, z)) {
                return Blocks.AIR.defaultBlockState();
            }
            LevelAccessor levelAccessor = this.world;
            if (levelAccessor instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)levelAccessor;
                serverLevel.setChunkForced(x, z, true);
                this.loadedChunks.add(ChunkPos.asLong((int)x, (int)z));
            }
            chunk = chunkProvider.getChunk(x, z, ChunkStatus.FULL, true);
        }
        return chunk.getBlockState(pos);
    }
}

