/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import net.minecraft.core.NonNullList;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.TransientCraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.jetbrains.annotations.NotNull;

public class DummyCraftingContainer
extends TransientCraftingContainer {
    private final IItemHandlerModifiable itemHandler;

    public DummyCraftingContainer(IItemHandlerModifiable itemHandler) {
        super(null, 0, 0);
        this.itemHandler = itemHandler;
    }

    public int getContainerSize() {
        return this.itemHandler.getSlots();
    }

    public boolean isEmpty() {
        for (int slot = 0; slot < this.getContainerSize(); ++slot) {
            if (this.getItem(slot).isEmpty()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ItemStack getItem(int slot) {
        return slot >= this.getContainerSize() ? ItemStack.EMPTY : this.itemHandler.getStackInSlot(slot);
    }

    @NotNull
    public ItemStack removeItemNoUpdate(int slot) {
        return this.itemHandler.extractItem(slot, Integer.MAX_VALUE, false);
    }

    @NotNull
    public ItemStack removeItem(int slot, int count) {
        return this.itemHandler.extractItem(slot, count, false);
    }

    public void setItem(int slot, @NotNull ItemStack stack) {
        this.itemHandler.setStackInSlot(slot, stack);
    }

    public void clearContent() {
        for (int i = 0; i < this.itemHandler.getSlots(); ++i) {
            this.itemHandler.setStackInSlot(i, ItemStack.EMPTY);
        }
    }

    public void fillStackedContents(@NotNull StackedContents helper) {
    }

    private static NonNullList<ItemStack> createInventory(IItemHandlerModifiable itemHandler) {
        NonNullList inv = NonNullList.create();
        for (int slot = 0; slot < itemHandler.getSlots(); ++slot) {
            ItemStack stack = itemHandler.getStackInSlot(slot);
            if (stack.isEmpty()) continue;
            ItemStack stackCopy = stack.copy();
            inv.add((Object)stackCopy);
        }
        return inv;
    }
}

