/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.RecipeCondition;
import com.gregtechceu.gtceu.api.recipe.ResearchData;
import com.gregtechceu.gtceu.api.recipe.category.GTRecipeCategory;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.common.recipe.condition.ResearchCondition;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.latvian.mods.kubejs.recipe.ingredientaction.IngredientAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.ExtraCodecs;
import net.minecraft.util.Tuple;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class GTRecipeSerializer
implements RecipeSerializer<GTRecipe> {
    public static final Codec<GTRecipe> CODEC = GTRecipeSerializer.makeCodec(GTCEu.Mods.isKubeJSLoaded());
    public static final GTRecipeSerializer SERIALIZER = new GTRecipeSerializer();

    public Map<RecipeCapability<?>, List<Content>> capabilitiesFromJson(JsonObject json) {
        IdentityHashMap capabilities = new IdentityHashMap();
        for (String key : json.keySet()) {
            JsonArray contentsJson = json.getAsJsonArray(key);
            RecipeCapability capability = (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(key);
            if (capability == null) continue;
            ArrayList<Content> contents = new ArrayList<Content>();
            for (JsonElement contentJson : contentsJson) {
                contents.add(capability.serializer.fromJsonContent(contentJson));
            }
            capabilities.put(capability, contents);
        }
        return capabilities;
    }

    public Map<RecipeCapability<?>, ChanceLogic> chanceLogicsFromJson(JsonObject json) {
        IdentityHashMap chanceLogics = new IdentityHashMap();
        for (String key : json.keySet()) {
            String value = json.get(key).getAsString();
            chanceLogics.put((RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(key), (ChanceLogic)GTRegistries.CHANCE_LOGICS.get(value));
        }
        return chanceLogics;
    }

    @NotNull
    public GTRecipe fromJson(@NotNull ResourceLocation id, @NotNull JsonObject json) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        GTRecipe recipe = (GTRecipe)CODEC.parse((DynamicOps)ops, (Object)json).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
        recipe.setId(id);
        return recipe;
    }

    public static Tuple<RecipeCapability<?>, List<Content>> entryReader(FriendlyByteBuf buf) {
        RecipeCapability capability = (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(buf.readUtf());
        List contents = buf.readList(capability.serializer::fromNetworkContent);
        return new Tuple((Object)capability, (Object)contents);
    }

    public static void entryWriter(FriendlyByteBuf buf, Map.Entry<RecipeCapability<?>, ? extends List<Content>> entry) {
        RecipeCapability<?> capability = entry.getKey();
        List<Content> contents = entry.getValue();
        buf.writeUtf((String)GTRegistries.RECIPE_CAPABILITIES.getKey(capability));
        buf.writeCollection(contents, capability.serializer::toNetworkContent);
    }

    public static RecipeCondition conditionReader(FriendlyByteBuf buf) {
        buf.readUtf();
        return RecipeCondition.fromNetwork(buf);
    }

    public static void conditionWriter(FriendlyByteBuf buf, RecipeCondition condition) {
        buf.writeUtf((String)GTRegistries.RECIPE_CONDITIONS.getKey(condition.getType()));
        condition.toNetwork(buf);
    }

    public static Map<RecipeCapability<?>, List<Content>> tuplesToMap(List<Tuple<RecipeCapability<?>, List<Content>>> entries) {
        HashMap map = new HashMap();
        entries.forEach(entry -> map.put((RecipeCapability)entry.getA(), (List)entry.getB()));
        return map;
    }

    @NotNull
    public GTRecipe fromNetwork(@NotNull ResourceLocation id, @NotNull FriendlyByteBuf buf) {
        CompoundTag data;
        ResourceLocation recipeType = buf.readResourceLocation();
        int duration = buf.readVarInt();
        Map<RecipeCapability<?>, List<Content>> inputs = GTRecipeSerializer.tuplesToMap((List)buf.readCollection(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> tickInputs = GTRecipeSerializer.tuplesToMap((List)buf.readCollection(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> outputs = GTRecipeSerializer.tuplesToMap((List)buf.readCollection(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map<RecipeCapability<?>, List<Content>> tickOutputs = GTRecipeSerializer.tuplesToMap((List)buf.readCollection(c -> new ArrayList(), GTRecipeSerializer::entryReader));
        Map inputChanceLogics = buf.readMap(buf1 -> (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(buf1.readUtf()), buf1 -> (ChanceLogic)GTRegistries.CHANCE_LOGICS.get(buf1.readUtf()));
        Map outputChanceLogics = buf.readMap(buf1 -> (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(buf1.readUtf()), buf1 -> (ChanceLogic)GTRegistries.CHANCE_LOGICS.get(buf1.readUtf()));
        Map tickInputChanceLogics = buf.readMap(buf1 -> (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(buf1.readUtf()), buf1 -> (ChanceLogic)GTRegistries.CHANCE_LOGICS.get(buf1.readUtf()));
        Map tickOutputChanceLogics = buf.readMap(buf1 -> (RecipeCapability)GTRegistries.RECIPE_CAPABILITIES.get(buf1.readUtf()), buf1 -> (ChanceLogic)GTRegistries.CHANCE_LOGICS.get(buf1.readUtf()));
        List conditions = (List)buf.readCollection(c -> new ArrayList(), GTRecipeSerializer::conditionReader);
        List<Object> ingredientActions = new ArrayList();
        if (GTCEu.Mods.isKubeJSLoaded()) {
            ingredientActions = KJSCallWrapper.getIngredientActions(buf);
        }
        if ((data = buf.readNbt()) == null) {
            data = new CompoundTag();
        }
        ResourceLocation categoryLoc = buf.readResourceLocation();
        GTRecipeType type = (GTRecipeType)BuiltInRegistries.RECIPE_TYPE.get(recipeType);
        GTRecipeCategory category = (GTRecipeCategory)GTRegistries.RECIPE_CATEGORIES.get(categoryLoc);
        GTRecipe recipe = new GTRecipe(type, id, inputs, outputs, tickInputs, tickOutputs, inputChanceLogics, outputChanceLogics, tickInputChanceLogics, tickOutputChanceLogics, conditions, ingredientActions, data, duration, category);
        recipe.recipeCategory.addRecipe(recipe);
        ResearchCondition researchCondition = conditions.stream().filter(ResearchCondition.class::isInstance).findAny().map(ResearchCondition.class::cast).orElse(null);
        if (researchCondition != null) {
            for (ResearchData.ResearchEntry entry : researchCondition.data) {
                type.addDataStickEntry(entry.getResearchId(), recipe);
            }
        }
        return recipe;
    }

    public void toNetwork(FriendlyByteBuf buf, GTRecipe recipe) {
        buf.writeResourceLocation(recipe.recipeType.registryName);
        buf.writeVarInt(recipe.duration);
        buf.writeCollection(recipe.inputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.writeCollection(recipe.tickInputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.writeCollection(recipe.outputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.writeCollection(recipe.tickOutputs.entrySet(), GTRecipeSerializer::entryWriter);
        buf.writeMap(recipe.inputChanceLogics, (buf1, cap) -> buf1.writeUtf((String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap)), (buf1, logic) -> buf1.writeUtf((String)GTRegistries.CHANCE_LOGICS.getKey((ChanceLogic)logic)));
        buf.writeMap(recipe.outputChanceLogics, (buf1, cap) -> buf1.writeUtf((String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap)), (buf1, logic) -> buf1.writeUtf((String)GTRegistries.CHANCE_LOGICS.getKey((ChanceLogic)logic)));
        buf.writeMap(recipe.tickInputChanceLogics, (buf1, cap) -> buf1.writeUtf((String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap)), (buf1, logic) -> buf1.writeUtf((String)GTRegistries.CHANCE_LOGICS.getKey((ChanceLogic)logic)));
        buf.writeMap(recipe.tickOutputChanceLogics, (buf1, cap) -> buf1.writeUtf((String)GTRegistries.RECIPE_CAPABILITIES.getKey((RecipeCapability<?>)cap)), (buf1, logic) -> buf1.writeUtf((String)GTRegistries.CHANCE_LOGICS.getKey((ChanceLogic)logic)));
        buf.writeCollection(recipe.conditions, GTRecipeSerializer::conditionWriter);
        if (GTCEu.Mods.isKubeJSLoaded()) {
            KJSCallWrapper.writeIngredientActions(recipe.ingredientActions, buf);
        }
        buf.writeNbt(recipe.data);
        buf.writeResourceLocation(recipe.recipeCategory.registryKey);
    }

    private static Codec<GTRecipe> makeCodec(boolean isKubeLoaded) {
        if (!isKubeLoaded) {
            return RecordCodecBuilder.create(instance -> instance.group((App)GTRegistries.RECIPE_TYPES.codec().fieldOf("type").forGetter(val -> val.recipeType), (App)RecipeCapability.CODEC.optionalFieldOf("inputs", Map.of()).forGetter(val -> val.inputs), (App)RecipeCapability.CODEC.optionalFieldOf("outputs", Map.of()).forGetter(val -> val.outputs), (App)RecipeCapability.CODEC.optionalFieldOf("tickInputs", Map.of()).forGetter(val -> val.tickInputs), (App)RecipeCapability.CODEC.optionalFieldOf("tickOutputs", Map.of()).forGetter(val -> val.tickOutputs), (App)Codec.unboundedMap(RecipeCapability.DIRECT_CODEC, GTRegistries.CHANCE_LOGICS.codec()).optionalFieldOf("inputChanceLogics", Map.of()).forGetter(val -> val.inputChanceLogics), (App)Codec.unboundedMap(RecipeCapability.DIRECT_CODEC, GTRegistries.CHANCE_LOGICS.codec()).optionalFieldOf("outputChanceLogics", Map.of()).forGetter(val -> val.outputChanceLogics), (App)Codec.unboundedMap(RecipeCapability.DIRECT_CODEC, GTRegistries.CHANCE_LOGICS.codec()).optionalFieldOf("tickInputChanceLogics", Map.of()).forGetter(val -> val.tickInputChanceLogics), (App)Codec.unboundedMap(RecipeCapability.DIRECT_CODEC, GTRegistries.CHANCE_LOGICS.codec()).optionalFieldOf("tickOutputChanceLogics", Map.of()).forGetter(val -> val.tickOutputChanceLogics), (App)RecipeCondition.CODEC.listOf().optionalFieldOf("recipeConditions", List.of()).forGetter(val -> val.conditions), (App)CompoundTag.CODEC.optionalFieldOf("data", (Object)new CompoundTag()).forGetter(val -> val.data), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("duration").forGetter(val -> val.duration), (App)GTRegistries.RECIPE_CATEGORIES.codec().optionalFieldOf("category", (Object)GTRecipeCategory.DEFAULT).forGetter(val -> val.recipeCategory)).apply((Applicative)instance, (type, inputs, outputs, tickInputs, tickOutputs, inputChanceLogics, outputChanceLogics, tickInputChanceLogics, tickOutputChanceLogics, conditions, data, duration, recipeCategory) -> new GTRecipe((GTRecipeType)type, (Map<RecipeCapability<?>, List<Content>>)inputs, (Map<RecipeCapability<?>, List<Content>>)outputs, (Map<RecipeCapability<?>, List<Content>>)tickInputs, (Map<RecipeCapability<?>, List<Content>>)tickOutputs, (Map<RecipeCapability<?>, ChanceLogic>)inputChanceLogics, (Map<RecipeCapability<?>, ChanceLogic>)outputChanceLogics, (Map<RecipeCapability<?>, ChanceLogic>)tickInputChanceLogics, (Map<RecipeCapability<?>, ChanceLogic>)tickOutputChanceLogics, (List<RecipeCondition>)conditions, List.of(), (CompoundTag)data, (int)duration, (GTRecipeCategory)recipeCategory)));
        }
        return RecordCodecBuilder.create(instance -> instance.group((App)GTRegistries.RECIPE_TYPES.codec().fieldOf("type").forGetter(val -> val.recipeType), (App)RecipeCapability.CODEC.optionalFieldOf("inputs", Map.of()).forGetter(val -> val.inputs), (App)RecipeCapability.CODEC.optionalFieldOf("outputs", Map.of()).forGetter(val -> val.outputs), (App)RecipeCapability.CODEC.optionalFieldOf("tickInputs", Map.of()).forGetter(val -> val.tickInputs), (App)RecipeCapability.CODEC.optionalFieldOf("tickOutputs", Map.of()).forGetter(val -> val.tickOutputs), (App)Codec.unboundedMap(RecipeCapability.DIRECT_CODEC, GTRegistries.CHANCE_LOGICS.codec()).optionalFieldOf("inputChanceLogics", Map.of()).forGetter(val -> val.inputChanceLogics), (App)Codec.unboundedMap(RecipeCapability.DIRECT_CODEC, GTRegistries.CHANCE_LOGICS.codec()).optionalFieldOf("outputChanceLogics", Map.of()).forGetter(val -> val.outputChanceLogics), (App)Codec.unboundedMap(RecipeCapability.DIRECT_CODEC, GTRegistries.CHANCE_LOGICS.codec()).optionalFieldOf("tickInputChanceLogics", Map.of()).forGetter(val -> val.tickInputChanceLogics), (App)Codec.unboundedMap(RecipeCapability.DIRECT_CODEC, GTRegistries.CHANCE_LOGICS.codec()).optionalFieldOf("tickOutputChanceLogics", Map.of()).forGetter(val -> val.tickOutputChanceLogics), (App)RecipeCondition.CODEC.listOf().optionalFieldOf("recipeConditions", List.of()).forGetter(val -> val.conditions), (App)KJSCallWrapper.INGREDIENT_ACTION_CODEC.optionalFieldOf("kubejs:actions", List.of()).forGetter(val -> val.ingredientActions), (App)CompoundTag.CODEC.optionalFieldOf("data", (Object)new CompoundTag()).forGetter(val -> val.data), (App)ExtraCodecs.NON_NEGATIVE_INT.fieldOf("duration").forGetter(val -> val.duration), (App)GTRegistries.RECIPE_CATEGORIES.codec().optionalFieldOf("category", (Object)GTRecipeCategory.DEFAULT).forGetter(val -> val.recipeCategory)).apply((Applicative)instance, GTRecipe::new));
    }

    public static class KJSCallWrapper {
        public static final Codec<List<IngredientAction>> INGREDIENT_ACTION_CODEC = ExtraCodecs.JSON.xmap(IngredientAction::parseList, list -> {
            JsonArray value = new JsonArray();
            for (IngredientAction action : list) {
                value.add((JsonElement)action.toJson());
            }
            return value;
        });

        public static List<?> getIngredientActions(JsonObject json) {
            return IngredientAction.parseList((JsonElement)json.get("kubejs:actions"));
        }

        public static List<?> getIngredientActions(FriendlyByteBuf buf) {
            return IngredientAction.readList((FriendlyByteBuf)buf);
        }

        public static void writeIngredientActions(List<?> ingredientActions, FriendlyByteBuf buf) {
            IngredientAction.writeList((FriendlyByteBuf)buf, ingredientActions);
        }
    }
}

