/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.common.math.IntMath;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.content.ContentModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.ModifierFunction;
import com.gregtechceu.gtceu.api.recipe.modifier.ParallelLogic;
import com.gregtechceu.gtceu.utils.GTMath;
import com.gregtechceu.gtceu.utils.GTUtil;
import java.math.RoundingMode;
import javax.annotation.ParametersAreNonnullByDefault;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
@FunctionalInterface
public interface OverclockingLogic {
    public static final double STD_VOLTAGE_FACTOR = 4.0;
    public static final double PERFECT_HALF_VOLTAGE_FACTOR = 2.0;
    public static final double STD_DURATION_FACTOR = 0.5;
    public static final double STD_DURATION_FACTOR_INV = 2.0;
    public static final double PERFECT_DURATION_FACTOR = 0.25;
    public static final double PERFECT_DURATION_FACTOR_INV = 4.0;
    public static final double PERFECT_HALF_DURATION_FACTOR = 0.5;
    public static final double PERFECT_HALF_DURATION_FACTOR_INV = 2.0;
    public static final int COIL_EUT_DISCOUNT_TEMPERATURE = 900;
    public static final OverclockingLogic PERFECT_OVERCLOCK = OverclockingLogic.create(0.25, 4.0, false);
    public static final OverclockingLogic NON_PERFECT_OVERCLOCK = OverclockingLogic.create(0.5, 4.0, false);
    public static final OverclockingLogic PERFECT_OVERCLOCK_SUBTICK = OverclockingLogic.create(0.25, 4.0, true);
    public static final OverclockingLogic NON_PERFECT_OVERCLOCK_SUBTICK = OverclockingLogic.create(0.5, 4.0, true);

    public OCResult runOverclockingLogic(@NotNull OCParams var1, long var2);

    public static OverclockingLogic create(double durationFactor, double voltageFactor, boolean subtick) {
        if (subtick) {
            return (params, maxV) -> OverclockingLogic.subTickParallelOC(params, maxV, durationFactor, voltageFactor);
        }
        return (params, maxV) -> OverclockingLogic.standardOC(params, maxV, durationFactor, voltageFactor);
    }

    @NotNull
    default public ModifierFunction getModifier(MetaMachine machine, GTRecipe recipe, long maxVoltage, boolean shouldParallel) {
        int maxParallels;
        long EUt = RecipeHelper.getRealEUt(recipe).getTotalEU();
        if (EUt == 0L) {
            return ModifierFunction.IDENTITY;
        }
        byte recipeTier = GTUtil.getTierByVoltage(EUt);
        byte maximumTier = GTUtil.getOCTierByVoltage(maxVoltage);
        int OCs = maximumTier - recipeTier;
        if (recipeTier == 0) {
            --OCs;
        }
        if (OCs == 0) {
            return ModifierFunction.IDENTITY;
        }
        if (!shouldParallel || this == PERFECT_OVERCLOCK || this == NON_PERFECT_OVERCLOCK) {
            maxParallels = 1;
        } else {
            int lg = IntMath.log2((int)recipe.duration, (RoundingMode)RoundingMode.FLOOR) / 2;
            if (lg > OCs) {
                maxParallels = 16;
            } else {
                int p = GTMath.saturatedCast((1L << 2 * (OCs - lg)) + 1L);
                maxParallels = ParallelLogic.getParallelAmount(machine, recipe, p);
            }
        }
        OCParams params = new OCParams(EUt, recipe.duration, OCs, maxParallels);
        OCResult result = this.runOverclockingLogic(params, maxVoltage);
        return result.toModifier();
    }

    @NotNull
    default public ModifierFunction getModifier(MetaMachine machine, GTRecipe recipe, long maxVoltage) {
        return this.getModifier(machine, recipe, maxVoltage, true);
    }

    public static OCResult standardOC(OCParams params, long maxVoltage, double durationFactor, double voltageFactor) {
        double potentialDuration;
        double potentialEUt;
        double duration = params.duration;
        double eut = params.eut;
        int ocAmount = params.ocAmount;
        int ocLevel = 0;
        while (ocAmount-- > 0 && !((potentialEUt = eut * voltageFactor) > (double)maxVoltage) && !((potentialDuration = duration * durationFactor) < 1.0)) {
            duration = potentialDuration;
            eut = potentialEUt;
            ++ocLevel;
        }
        return new OCResult(Math.pow(voltageFactor, ocLevel), Math.pow(durationFactor, ocLevel), ocLevel, 1);
    }

    public static OCResult subTickNonParallelOC(OCParams params, long maxVoltage, double durationFactor, double voltageFactor) {
        double potentialEUt;
        double duration = params.duration;
        double eut = params.eut;
        int ocAmount = params.ocAmount;
        int ocLevel = 0;
        double eutMultiplier = 1.0;
        double durationMultiplier = 1.0;
        while (ocAmount-- > 0 && !((potentialEUt = eut * voltageFactor) > (double)maxVoltage) && !(potentialEUt < 1.0)) {
            eutMultiplier *= voltageFactor;
            double potentialDuration = duration * durationFactor;
            if (potentialDuration < 1.0) {
                potentialEUt = eut * durationFactor;
                if (potentialEUt > (double)maxVoltage || potentialEUt < 1.0) break;
                eutMultiplier *= durationFactor;
            } else {
                duration = potentialDuration;
                durationMultiplier *= durationFactor;
            }
            eut = potentialEUt;
            ++ocLevel;
        }
        return new OCResult(eutMultiplier, durationMultiplier, ocLevel, 1);
    }

    public static OCResult subTickParallelOC(OCParams params, long maxVoltage, double durationFactor, double voltageFactor) {
        double potentialEUt;
        double duration = params.duration;
        double eut = params.eut;
        int ocAmount = params.ocAmount;
        int maxParallels = params.maxParallels;
        double parallel = 1.0;
        boolean shouldParallel = false;
        int ocLevel = 0;
        double durationMultiplier = 1.0;
        while (ocAmount-- > 0 && !((potentialEUt = eut * voltageFactor) > (double)maxVoltage)) {
            if (shouldParallel || duration * durationFactor < 1.0) {
                double potentialParallel = parallel / durationFactor;
                if (potentialParallel > (double)maxParallels) break;
                parallel = potentialParallel;
                shouldParallel = true;
            } else {
                duration *= durationFactor;
                durationMultiplier *= durationFactor;
            }
            eut = potentialEUt;
            ++ocLevel;
        }
        return new OCResult(Math.pow(voltageFactor, ocLevel), durationMultiplier, ocLevel, (int)parallel);
    }

    public static OCResult heatingCoilOC(OCParams params, long maxVoltage, int recipeTemp, int machineTemp) {
        int perfectOCAmount = OverclockingLogic.getCoilDiscountAmount(recipeTemp, machineTemp) / 2;
        double duration = params.duration;
        double eut = params.eut;
        int ocAmount = params.ocAmount;
        int maxParallels = params.maxParallels;
        double parallel = 1.0;
        boolean shouldParallel = false;
        int ocLevel = 0;
        double durationMultiplier = 1.0;
        while (ocAmount-- > 0) {
            double dFactor;
            boolean perfect = perfectOCAmount-- > 0;
            double potentialEUt = eut * 4.0;
            if (potentialEUt > (double)maxVoltage) break;
            double d = dFactor = perfect ? 0.25 : 0.5;
            if (shouldParallel || duration * dFactor < 1.0) {
                double pFactor = perfect ? 4.0 : 2.0;
                double potentialParallel = parallel * pFactor;
                if (potentialParallel > (double)maxParallels) break;
                parallel = potentialParallel;
                shouldParallel = true;
            } else {
                duration *= dFactor;
                durationMultiplier *= dFactor;
            }
            eut = potentialEUt;
            ++ocLevel;
        }
        return new OCResult(Math.pow(4.0, ocLevel), durationMultiplier, ocLevel, (int)parallel);
    }

    private static int getCoilDiscountAmount(int recipeTemp, int machineTemp) {
        return Math.max(0, (machineTemp - recipeTemp) / 900);
    }

    public static double getCoilEUtDiscount(int recipeTemp, int machineTemp) {
        if (recipeTemp < 900) {
            return 1.0;
        }
        int amountEUtDiscount = OverclockingLogic.getCoilDiscountAmount(recipeTemp, machineTemp);
        if (amountEUtDiscount < 1) {
            return 1.0;
        }
        return Math.min(1.0, Math.pow(0.95, amountEUtDiscount));
    }

    public record OCParams(long eut, int duration, int ocAmount, int maxParallels) {
    }

    public record OCResult(double eutMultiplier, double durationMultiplier, int ocLevel, int parallels) {
        public ModifierFunction toModifier() {
            return ModifierFunction.builder().modifyAllContents(ContentModifier.multiplier(this.parallels)).eutMultiplier(this.eutMultiplier).durationMultiplier(this.durationMultiplier).addOCs(this.ocLevel).subtickParallels(this.parallels).build();
        }
    }
}

