/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.condition.RecipeConditionType;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import lombok.Generated;
import net.minecraft.Util;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.RegistryOps;
import net.minecraft.util.GsonHelper;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public abstract class RecipeCondition {
    public static final Codec<RecipeCondition> CODEC = GTRegistries.RECIPE_CONDITIONS.codec().dispatch(RecipeCondition::getType, RecipeConditionType::getCodec);
    protected boolean isReverse;

    public static <RC extends RecipeCondition> Products.P1<RecordCodecBuilder.Mu<RC>, Boolean> isReverse(RecordCodecBuilder.Instance<RC> instance) {
        return instance.group((App)Codec.BOOL.optionalFieldOf("reverse", (Object)false).forGetter(val -> val.isReverse));
    }

    public RecipeCondition() {
        this(false);
    }

    public RecipeCondition(boolean isReverse) {
        this.isReverse = isReverse;
    }

    public abstract RecipeConditionType<?> getType();

    public String getTranslationKey() {
        return "gtceu.recipe.condition." + String.valueOf(this.getType());
    }

    public IGuiTexture getInValidTexture() {
        return new ResourceTexture("gtceu:textures/gui/condition/" + String.valueOf(this.getType()) + ".png").getSubTexture(0.0f, 0.0f, 1.0f, 0.5f);
    }

    public IGuiTexture getValidTexture() {
        return new ResourceTexture("gtceu:textures/gui/condition/" + String.valueOf(this.getType()) + ".png").getSubTexture(0.0f, 0.5f, 1.0f, 0.5f);
    }

    public boolean isOr() {
        return false;
    }

    public abstract Component getTooltips();

    public boolean check(@NotNull GTRecipe recipe, @NotNull RecipeLogic recipeLogic) {
        boolean test = this.testCondition(recipe, recipeLogic);
        return test != this.isReverse;
    }

    protected abstract boolean testCondition(@NotNull GTRecipe var1, @NotNull RecipeLogic var2);

    public abstract RecipeCondition createTemplate();

    @NotNull
    public final JsonObject serialize() {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        return ((JsonElement)CODEC.encodeStart((DynamicOps)ops, (Object)this).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0))).getAsJsonObject();
    }

    public static RecipeCondition deserialize(@NotNull JsonObject config) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        return (RecipeCondition)((Pair)CODEC.decode((DynamicOps)ops, (Object)config).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0))).getFirst();
    }

    public final void toNetwork(FriendlyByteBuf buf) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        DataResult dataresult = CODEC.encodeStart((DynamicOps)ops, (Object)this);
        buf.writeUtf(new Gson().toJson((JsonElement)Util.getOrThrow((DataResult)dataresult, p_261421_ -> new EncoderException("Failed to encode: " + p_261421_ + " " + String.valueOf(this)))));
    }

    public static RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        RegistryOps ops = RegistryOps.create((DynamicOps)JsonOps.INSTANCE, (HolderLookup.Provider)GTRegistries.builtinRegistry());
        JsonElement jsonelement = (JsonElement)GsonHelper.fromJson((Gson)new Gson(), (String)buf.readUtf(), JsonElement.class);
        DataResult dataresult = CODEC.parse((DynamicOps)ops, (Object)jsonelement);
        return (RecipeCondition)Util.getOrThrow((DataResult)dataresult, p_272382_ -> new DecoderException("Failed to decode json: " + p_272382_));
    }

    @Generated
    public boolean isReverse() {
        return this.isReverse;
    }

    @NotNull
    @Generated
    public RecipeCondition setReverse(boolean isReverse) {
        this.isReverse = isReverse;
        return this;
    }
}

