/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.capability.recipe.IRecipeCapabilityHolder;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroup;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerGroupDistinctness;
import com.gregtechceu.gtceu.api.machine.trait.RecipeHandlerList;
import com.gregtechceu.gtceu.api.recipe.ActionResult;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.RecipeHelper;
import com.gregtechceu.gtceu.api.recipe.chance.boost.ChanceBoostFunction;
import com.gregtechceu.gtceu.api.recipe.chance.logic.ChanceLogic;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectOpenHashMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class RecipeRunner {
    private final GTRecipe recipe;
    private final IO io;
    private final boolean isTick;
    private final Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches;
    private final Map<IO, List<RecipeHandlerList>> capabilityProxies;
    private final boolean simulated;
    private Map<RecipeCapability<?>, List<Object>> recipeContents;
    private final Map<RecipeCapability<?>, List<Object>> searchRecipeContents;

    public RecipeRunner(GTRecipe recipe, IO io, boolean isTick, IRecipeCapabilityHolder holder, Map<RecipeCapability<?>, Object2IntMap<?>> chanceCaches, boolean simulated) {
        this.recipe = recipe;
        this.io = io;
        this.isTick = isTick;
        this.chanceCaches = chanceCaches;
        this.capabilityProxies = holder.getCapabilitiesProxy();
        this.recipeContents = new Reference2ObjectOpenHashMap();
        this.searchRecipeContents = simulated ? this.recipeContents : new Reference2ObjectOpenHashMap();
        this.simulated = simulated;
    }

    @NotNull
    public ActionResult handle(Map<RecipeCapability<?>, List<Content>> entries) {
        this.fillContentMatchList(entries);
        if (this.searchRecipeContents.isEmpty()) {
            return ActionResult.PASS_NO_CONTENTS;
        }
        return this.handleContents();
    }

    private void fillContentMatchList(Map<RecipeCapability<?>, List<Content>> entries) {
        ChanceBoostFunction function = this.recipe.getType().getChanceFunction();
        int recipeTier = RecipeHelper.getPreOCRecipeEuTier(this.recipe);
        int chanceTier = recipeTier + this.recipe.ocLevel;
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : entries.entrySet()) {
            RecipeCapability<?> cap = entry.getKey();
            if (!cap.doMatchInRecipe()) continue;
            ChanceLogic logic = this.recipe.getChanceLogicForCapability(cap, this.io, this.isTick);
            List<Content> chancedContents = new ArrayList<Content>();
            if (entry.getValue().isEmpty()) continue;
            List contentList = this.recipeContents.computeIfAbsent(cap, c -> new ArrayList());
            List searchContentList = this.searchRecipeContents.computeIfAbsent(cap, c -> new ArrayList());
            for (Content cont : entry.getValue()) {
                searchContentList.add(cont.content);
                if (this.simulated) continue;
                if (cont.chance >= cont.maxChance) {
                    contentList.add(cont.content);
                    continue;
                }
                if (cont.chance <= 0 && cont.tierChanceBoost <= 0) continue;
                chancedContents.add(cont);
            }
            if (!chancedContents.isEmpty()) {
                Object2IntMap<?> cache = this.chanceCaches.get(cap);
                chancedContents = logic.roll(chancedContents, function, recipeTier, chanceTier, cache, this.recipe.getTotalRuns());
                for (Content cont : chancedContents) {
                    contentList.add(cont.content);
                }
            }
            if (!contentList.isEmpty()) continue;
            this.recipeContents.remove(cap);
        }
    }

    private ActionResult handleContents() {
        if (this.recipeContents.isEmpty()) {
            return ActionResult.SUCCESS;
        }
        if (!this.capabilityProxies.containsKey(this.io)) {
            return ActionResult.FAIL_NO_CAPABILITIES;
        }
        List handlers = this.capabilityProxies.getOrDefault(this.io, Collections.emptyList());
        if (!this.isTick && this.io.support(IO.OUT)) {
            handlers.sort(RecipeHandlerList.COMPARATOR.reversed());
        }
        HashMap<RecipeHandlerGroup, List<RecipeHandlerList>> handlerGroups = new HashMap<RecipeHandlerGroup, List<RecipeHandlerList>>();
        for (RecipeHandlerList recipeHandlerList : handlers) {
            RecipeHelper.addToRecipeHandlerMap(recipeHandlerList.getGroup(), recipeHandlerList, handlerGroups);
        }
        for (RecipeHandlerList recipeHandlerList : handlerGroups.getOrDefault(RecipeHandlerGroupDistinctness.BUS_DISTINCT, Collections.emptyList())) {
            Map<RecipeCapability<?>, List<Object>> res = recipeHandlerList.handleRecipe(this.io, this.recipe, this.searchRecipeContents, true);
            if (!res.isEmpty()) {
                RecipeHandlerList bypassHandler;
                Iterator iterator = handlerGroups.getOrDefault(RecipeHandlerGroupDistinctness.BYPASS_DISTINCT, Collections.emptyList()).iterator();
                while (iterator.hasNext() && !(res = (bypassHandler = (RecipeHandlerList)iterator.next()).handleRecipe(this.io, this.recipe, res, true)).isEmpty()) {
                }
            }
            if (!res.isEmpty()) continue;
            if (!this.simulated) {
                this.recipeContents = recipeHandlerList.handleRecipe(this.io, this.recipe, this.recipeContents, false);
                if (!this.recipeContents.isEmpty()) {
                    for (RecipeHandlerList bypassHandler : handlerGroups.getOrDefault(RecipeHandlerGroupDistinctness.BYPASS_DISTINCT, Collections.emptyList())) {
                        this.recipeContents = bypassHandler.handleRecipe(this.io, this.recipe, this.recipeContents, false);
                        if (!this.recipeContents.isEmpty()) continue;
                        break;
                    }
                }
            }
            this.recipeContents.clear();
            return ActionResult.SUCCESS;
        }
        for (Map.Entry entry : handlerGroups.entrySet()) {
            if (((RecipeHandlerGroup)entry.getKey()).equals(RecipeHandlerGroupDistinctness.BUS_DISTINCT)) continue;
            Map<RecipeCapability<?>, List<Object>> copiedRecipeContents = this.searchRecipeContents;
            boolean found = false;
            for (RecipeHandlerList handler : (List)entry.getValue()) {
                copiedRecipeContents = handler.handleRecipe(this.io, this.recipe, copiedRecipeContents, true);
                if (!copiedRecipeContents.isEmpty()) continue;
                found = true;
                break;
            }
            if (!((RecipeHandlerGroup)entry.getKey()).equals(RecipeHandlerGroupDistinctness.BYPASS_DISTINCT)) {
                for (RecipeHandlerList bypassHandler : handlerGroups.getOrDefault(RecipeHandlerGroupDistinctness.BYPASS_DISTINCT, Collections.emptyList())) {
                    copiedRecipeContents = bypassHandler.handleRecipe(this.io, this.recipe, copiedRecipeContents, true);
                    if (!copiedRecipeContents.isEmpty()) continue;
                    found = true;
                    break;
                }
            }
            if (!found) continue;
            if (this.simulated) {
                return ActionResult.SUCCESS;
            }
            for (RecipeHandlerList handler : (List)entry.getValue()) {
                this.recipeContents = handler.handleRecipe(this.io, this.recipe, this.recipeContents, false);
                if (!this.recipeContents.isEmpty()) continue;
                return ActionResult.SUCCESS;
            }
            if (((RecipeHandlerGroup)entry.getKey()).equals(RecipeHandlerGroupDistinctness.BYPASS_DISTINCT)) continue;
            for (RecipeHandlerList bypassHandler : handlerGroups.getOrDefault(RecipeHandlerGroupDistinctness.BYPASS_DISTINCT, Collections.emptyList())) {
                this.recipeContents = bypassHandler.handleRecipe(this.io, this.recipe, this.recipeContents, false);
                if (!this.recipeContents.isEmpty()) continue;
                return ActionResult.SUCCESS;
            }
        }
        for (Map.Entry entry : this.recipeContents.entrySet()) {
            if (entry.getValue() == null || ((List)entry.getValue()).isEmpty()) continue;
            return ActionResult.fail(null, (RecipeCapability)entry.getKey(), this.io);
        }
        return ActionResult.FAIL_NO_REASON;
    }
}

