/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.core.mixins.ShapedRecipeAccessor;
import java.util.Map;
import lombok.Generated;
import net.minecraft.FieldsAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.ShapedRecipe;

@MethodsReturnNonnullByDefault
@FieldsAreNonnullByDefault
public class ShapedEnergyTransferRecipe
extends ShapedRecipe {
    public static final RecipeSerializer<ShapedEnergyTransferRecipe> SERIALIZER = new Serializer();
    private final Ingredient chargeIngredient;
    private final boolean transferMaxCharge;
    private final boolean overrideCharge;

    public ShapedEnergyTransferRecipe(ResourceLocation id, String group, int width, int height, Ingredient chargeIngredient, boolean overrideCharge, boolean transferMaxCharge, NonNullList<Ingredient> recipeItems, ItemStack result) {
        super(id, group, CraftingBookCategory.MISC, width, height, recipeItems, result);
        this.chargeIngredient = chargeIngredient;
        this.transferMaxCharge = transferMaxCharge;
        this.overrideCharge = overrideCharge;
    }

    public ItemStack assemble(CraftingContainer craftingContainer, RegistryAccess registryAccess) {
        long maxCharge = 0L;
        long charge = 0L;
        ItemStack resultStack = super.assemble(craftingContainer, registryAccess);
        for (ItemStack chargeStack : this.chargeIngredient.getItems()) {
            for (int i = 0; i < craftingContainer.getContainerSize(); ++i) {
                ItemStack stack;
                IElectricItem electricItem;
                if (!ItemStack.isSameItem((ItemStack)craftingContainer.getItem(i), (ItemStack)chargeStack) || (electricItem = GTCapabilityHelper.getElectricItem(stack = craftingContainer.getItem(i))) == null) continue;
                resultStack.getOrCreateTag().putLong("MaxCharge", maxCharge += electricItem.getMaxCharge());
                resultStack.getOrCreateTag().putLong("Charge", charge += electricItem.getCharge());
                return resultStack;
            }
        }
        return resultStack;
    }

    public ItemStack getResultItem(RegistryAccess registryAccess) {
        long maxCharge = 0L;
        long charge = 0L;
        ItemStack resultStack = super.getResultItem(registryAccess);
        for (ItemStack chargeStack : this.chargeIngredient.getItems()) {
            IElectricItem electricItem = GTCapabilityHelper.getElectricItem(chargeStack);
            if (electricItem == null) continue;
            resultStack.getOrCreateTag().putLong("MaxCharge", maxCharge += electricItem.getMaxCharge());
            resultStack.getOrCreateTag().putLong("Charge", charge += electricItem.getCharge());
            return resultStack;
        }
        return resultStack;
    }

    @Generated
    public Ingredient getChargeIngredient() {
        return this.chargeIngredient;
    }

    @Generated
    public boolean isTransferMaxCharge() {
        return this.transferMaxCharge;
    }

    @Generated
    public boolean isOverrideCharge() {
        return this.overrideCharge;
    }

    public static class Serializer
    implements RecipeSerializer<ShapedEnergyTransferRecipe> {
        public ShapedEnergyTransferRecipe fromJson(ResourceLocation recipeId, JsonObject json) {
            String group = GsonHelper.getAsString((JsonObject)json, (String)"group", (String)"");
            Map<String, Ingredient> key = ShapedRecipeAccessor.callKeyFromJson(GsonHelper.getAsJsonObject((JsonObject)json, (String)"key"));
            String[] pattern = ShapedRecipeAccessor.callPatternFromJson(GsonHelper.getAsJsonArray((JsonObject)json, (String)"pattern"));
            int xSize = pattern[0].length();
            int ySize = pattern.length;
            NonNullList<Ingredient> dissolved = ShapedRecipeAccessor.callDissolvePattern(pattern, key, xSize, ySize);
            boolean overrideCharge = GsonHelper.getAsBoolean((JsonObject)json, (String)"overrideCharge");
            boolean transferMaxCharge = GsonHelper.getAsBoolean((JsonObject)json, (String)"transferMaxCharge");
            Ingredient chargeIngredient = Ingredient.fromJson((JsonElement)GsonHelper.getAsJsonObject((JsonObject)json, (String)"chargeIngredient"));
            ItemStack result = ShapedEnergyTransferRecipe.itemStackFromJson((JsonObject)GsonHelper.getAsJsonObject((JsonObject)json, (String)"result"));
            return new ShapedEnergyTransferRecipe(recipeId, group, xSize, ySize, chargeIngredient, overrideCharge, transferMaxCharge, dissolved, result);
        }

        public ShapedEnergyTransferRecipe fromNetwork(ResourceLocation recipeId, FriendlyByteBuf buffer) {
            int xSize = buffer.readVarInt();
            int ySize = buffer.readVarInt();
            boolean overrideCharge = buffer.readBoolean();
            boolean transferMaxCharge = buffer.readBoolean();
            Ingredient chargeIngredient = Ingredient.fromNetwork((FriendlyByteBuf)buffer);
            String group = buffer.readUtf();
            NonNullList ingredients = NonNullList.withSize((int)(xSize * ySize), (Object)Ingredient.EMPTY);
            ingredients.replaceAll($ -> Ingredient.fromNetwork((FriendlyByteBuf)buffer));
            ItemStack result = buffer.readItem();
            return new ShapedEnergyTransferRecipe(recipeId, group, xSize, ySize, chargeIngredient, overrideCharge, transferMaxCharge, (NonNullList<Ingredient>)ingredients, result);
        }

        public void toNetwork(FriendlyByteBuf buffer, ShapedEnergyTransferRecipe recipe) {
            buffer.writeVarInt(recipe.getWidth());
            buffer.writeVarInt(recipe.getHeight());
            buffer.writeBoolean(recipe.isOverrideCharge());
            buffer.writeBoolean(recipe.isTransferMaxCharge());
            recipe.getChargeIngredient().toNetwork(buffer);
            buffer.writeUtf(recipe.getGroup());
            for (Ingredient ingredient : recipe.getIngredients()) {
                ingredient.toNetwork(buffer);
            }
            buffer.writeItem(((ShapedRecipeAccessor)((Object)recipe)).getResult());
        }
    }
}

