/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe;

import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.IElectricItem;
import com.gregtechceu.gtceu.api.data.chemical.ChemicalHelper;
import com.gregtechceu.gtceu.api.data.chemical.material.stack.MaterialEntry;
import com.gregtechceu.gtceu.api.data.tag.TagPrefix;
import com.gregtechceu.gtceu.api.item.IGTTool;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.common.data.GTMaterialItems;
import com.tterrag.registrate.util.entry.ItemProviderEntry;
import java.lang.invoke.LambdaMetafactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CraftingBookCategory;
import net.minecraft.world.item.crafting.CustomRecipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.SimpleCraftingRecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.NotNull;

public class ToolHeadReplaceRecipe
extends CustomRecipe {
    public static SimpleCraftingRecipeSerializer<ToolHeadReplaceRecipe> SERIALIZER = new SimpleCraftingRecipeSerializer(ToolHeadReplaceRecipe::new);
    private static final Map<TagPrefix, GTToolType[]> TOOL_HEAD_TO_TOOL_MAP = new HashMap<TagPrefix, GTToolType[]>();

    public static void setToolHeadForTool(TagPrefix toolHead, GTToolType tool) {
        if (tool.electricTier <= -1) {
            return;
        }
        ToolHeadReplaceRecipe.TOOL_HEAD_TO_TOOL_MAP.computeIfAbsent((TagPrefix)toolHead, (Function<TagPrefix, GTToolType[]>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$setToolHeadForTool$0(com.gregtechceu.gtceu.api.data.tag.TagPrefix ), (Lcom/gregtechceu/gtceu/api/data/tag/TagPrefix;)[Lcom/gregtechceu/gtceu/api/item/tool/GTToolType;)())[tool.electricTier] = tool;
    }

    public ToolHeadReplaceRecipe(ResourceLocation id, CraftingBookCategory category) {
        super(id, category);
    }

    public boolean matches(CraftingContainer inv, @NotNull Level level) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack stack = inv.getItem(i);
            if (stack.isEmpty()) continue;
            list.add(stack);
            if (list.size() <= 2) continue;
            return false;
        }
        if (list.size() == 2) {
            MaterialEntry toolHead;
            IGTTool tool;
            ItemStack stack1 = (ItemStack)list.get(0);
            ItemStack stack2 = (ItemStack)list.get(1);
            if (stack1.getItem() instanceof IGTTool) {
                tool = (IGTTool)stack1.getItem();
                toolHead = ChemicalHelper.getMaterialEntry((ItemLike)stack2.getItem());
            } else if (stack2.getItem() instanceof IGTTool) {
                tool = (IGTTool)stack2.getItem();
                toolHead = ChemicalHelper.getMaterialEntry((ItemLike)stack1.getItem());
            } else {
                return false;
            }
            if (!tool.isElectric()) {
                return false;
            }
            if (toolHead.isEmpty()) {
                return false;
            }
            GTToolType[] output = TOOL_HEAD_TO_TOOL_MAP.get(toolHead.tagPrefix());
            return output != null && output[tool.getElectricTier()] != null;
        }
        return false;
    }

    @NotNull
    public ItemStack assemble(CraftingContainer inv, @NotNull RegistryAccess registryAccess) {
        ArrayList<ItemStack> list = new ArrayList<ItemStack>();
        for (int i = 0; i < inv.getContainerSize(); ++i) {
            ItemStack itemstack = inv.getItem(i);
            if (itemstack.isEmpty()) continue;
            list.add(itemstack);
        }
        if (list.size() == 2) {
            ItemStack realTool;
            MaterialEntry toolHead;
            IGTTool tool;
            ItemStack first = (ItemStack)list.get(0);
            ItemStack second = (ItemStack)list.get(1);
            if (first.getItem() instanceof IGTTool) {
                tool = (IGTTool)first.getItem();
                toolHead = ChemicalHelper.getMaterialEntry((ItemLike)second.getItem());
                realTool = first;
            } else if (second.getItem() instanceof IGTTool) {
                tool = (IGTTool)second.getItem();
                toolHead = ChemicalHelper.getMaterialEntry((ItemLike)first.getItem());
                realTool = second;
            } else {
                return ItemStack.EMPTY;
            }
            if (!tool.isElectric()) {
                return ItemStack.EMPTY;
            }
            IElectricItem powerUnit = GTCapabilityHelper.getElectricItem(realTool);
            if (toolHead.isEmpty() || powerUnit == null) {
                return ItemStack.EMPTY;
            }
            GTToolType[] toolArray = TOOL_HEAD_TO_TOOL_MAP.get(toolHead.tagPrefix());
            ItemStack newTool = ((IGTTool)((ItemProviderEntry)GTMaterialItems.TOOL_ITEMS.get((Object)toolHead.material(), (Object)toolArray[tool.getElectricTier()])).get()).get(powerUnit.getCharge(), powerUnit.getMaxCharge());
            if (newTool == null) {
                return ItemStack.EMPTY;
            }
            return newTool;
        }
        return ItemStack.EMPTY;
    }

    @NotNull
    public NonNullList<ItemStack> getRemainingItems(@NotNull CraftingContainer container) {
        NonNullList result = super.getRemainingItems((Container)container);
        for (ItemStack stack : result) {
            if (!(stack.getItem() instanceof IGTTool)) continue;
            stack.setCount(0);
        }
        return result;
    }

    public boolean canCraftInDimensions(int width, int height) {
        return width * height >= 2;
    }

    @NotNull
    public RecipeSerializer<?> getSerializer() {
        return SERIALIZER;
    }

    private static /* synthetic */ GTToolType[] lambda$setToolHeadForTool$0(TagPrefix p) {
        return new GTToolType[14];
    }
}

