/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.recipe.content.Content;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public record ContentModifier(double multiplier, double addition) {
    public static final ContentModifier IDENTITY = new ContentModifier(1.0, 0.0);

    public static ContentModifier multiplier(double multiplier) {
        return multiplier == 1.0 ? IDENTITY : new ContentModifier(multiplier, 0.0);
    }

    public static ContentModifier addition(double addition) {
        return addition == 0.0 ? IDENTITY : new ContentModifier(1.0, addition);
    }

    public int apply(int number) {
        return (int)((double)number * this.multiplier + this.addition);
    }

    public long apply(long number) {
        return (long)((double)number * this.multiplier + this.addition);
    }

    public float apply(float number) {
        return (float)((double)number * this.multiplier + this.addition);
    }

    public double apply(double number) {
        return number * this.multiplier + this.addition;
    }

    public Map<RecipeCapability<?>, List<Content>> applyContents(Map<RecipeCapability<?>, List<Content>> contents) {
        if (this == IDENTITY) {
            return new HashMap(contents);
        }
        HashMap copyContents = new HashMap();
        for (Map.Entry<RecipeCapability<?>, List<Content>> entry : contents.entrySet()) {
            List<Content> contentList = entry.getValue();
            RecipeCapability<?> cap = entry.getKey();
            if (contentList == null || contentList.isEmpty()) continue;
            ArrayList<Content> contentsCopy = new ArrayList<Content>();
            for (Content content : contentList) {
                contentsCopy.add(content.copy(cap, this));
            }
            copyContents.put(entry.getKey(), contentsCopy);
        }
        return copyContents;
    }
}

