/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.content.IContentSerializer;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.function.Function;
import net.minecraft.core.IdMap;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.Logger;

public class SerializerBlockState
implements IContentSerializer<BlockState> {
    public static SerializerBlockState INSTANCE = new SerializerBlockState();

    private SerializerBlockState() {
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf, BlockState content) {
        buf.writeId((IdMap)Block.BLOCK_STATE_REGISTRY, (Object)content);
    }

    @Override
    public BlockState fromNetwork(FriendlyByteBuf buf) {
        return (BlockState)buf.readById((IdMap)Block.BLOCK_STATE_REGISTRY);
    }

    @Override
    public BlockState fromJson(JsonElement json) {
        return (BlockState)BlockState.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json).getOrThrow(false, arg_0 -> ((Logger)GTCEu.LOGGER).error(arg_0));
    }

    @Override
    public JsonElement toJson(BlockState content) {
        return (JsonElement)BlockState.CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)content).get().map(Function.identity(), partial -> JsonNull.INSTANCE);
    }

    @Override
    public BlockState of(Object o) {
        if (o instanceof BlockState) {
            BlockState state = (BlockState)o;
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    public BlockState defaultValue() {
        return Blocks.AIR.defaultBlockState();
    }

    @Override
    public Class<BlockState> contentClass() {
        return BlockState.class;
    }

    @Override
    public Codec<BlockState> codec() {
        return BlockState.CODEC;
    }
}

