/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.capability.recipe.IO;
import com.gregtechceu.gtceu.api.codec.GTCodecUtils;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.function.Supplier;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Range;

public record EnergyStack(@Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long voltage, @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long amperage) {
    private static final Codec<EnergyStack> FULL_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)GTCodecUtils.NON_NEGATIVE_LONG.optionalFieldOf("voltage", (Object)0L).forGetter(EnergyStack::voltage), (App)GTCodecUtils.POSITIVE_LONG.optionalFieldOf("amperage", (Object)1L).forGetter(EnergyStack::amperage)).apply((Applicative)instance, EnergyStack::new));
    private static final Codec<EnergyStack> VOLTAGE_ONLY_CODEC = GTCodecUtils.NON_NEGATIVE_LONG.flatComapMap(EnergyStack::new, s -> {
        if (s.amperage() == 1L) {
            return DataResult.success((Object)s.voltage());
        }
        Supplier<String> error = () -> "primitive EnergyStacks must have 1A, got " + s.amperage();
        return DataResult.error(error, (Object)s.voltage());
    });
    public static final Codec<EnergyStack> CODEC = Codec.either(VOLTAGE_ONLY_CODEC, FULL_CODEC).xmap(GTCodecUtils::unboxEither, stack -> {
        if (stack.amperage() == 1L) {
            return Either.left((Object)stack);
        }
        return Either.right((Object)stack);
    });
    public static final EnergyStack EMPTY = new EnergyStack(0L, 1L);
    public static final EnergyStack MAX = new EnergyStack(Long.MAX_VALUE, 1L);

    public EnergyStack(long voltage) {
        this(voltage, 1L);
    }

    public long getTotalEU() {
        return this.voltage * this.amperage;
    }

    public boolean isEmpty() {
        return this == EMPTY || this.voltage <= 0L;
    }

    public EnergyStack add(long voltage, long amperage) {
        Preconditions.checkArgument((this.voltage + voltage >= 0L ? 1 : 0) != 0, (Object)"Resulting voltage must be >= 0");
        Preconditions.checkArgument((this.amperage + amperage >= 1L ? 1 : 0) != 0, (Object)"Resulting amperage must be >= 1");
        return new EnergyStack(this.voltage + voltage, this.amperage + amperage);
    }

    public EnergyStack addVoltage(long voltage) {
        Preconditions.checkArgument((this.voltage + voltage >= 0L ? 1 : 0) != 0, (Object)"Resulting voltage must be >= 0");
        return this.withVoltage(this.voltage + voltage);
    }

    public EnergyStack multiplyVoltage(long multiplier) {
        Preconditions.checkArgument((multiplier >= 0L ? 1 : 0) != 0, (Object)"Multiplier must be >= 0");
        return this.withVoltage(this.voltage * multiplier);
    }

    public EnergyStack multiplyVoltage(double multiplier) {
        Preconditions.checkArgument((multiplier >= 0.0 ? 1 : 0) != 0, (Object)"Multiplier must be >= 0");
        return this.withVoltage((long)((double)this.voltage * multiplier));
    }

    public EnergyStack addAmperage(long amperage) {
        Preconditions.checkArgument((this.amperage + amperage >= 1L ? 1 : 0) != 0, (Object)"Resulting amperage must be >= 1");
        return this.withAmperage(this.amperage + amperage);
    }

    public EnergyStack multiplyAmperage(long multiplier) {
        Preconditions.checkArgument((multiplier > 0L ? 1 : 0) != 0, (Object)"Multiplier must be > 0");
        return this.withAmperage(this.amperage * multiplier);
    }

    public static EnergyStack sum(EnergyStack a, EnergyStack b) {
        return a.add(b.voltage, b.amperage);
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeVarLong(this.voltage);
        buf.writeVarLong(this.amperage);
    }

    public static EnergyStack fromNetwork(FriendlyByteBuf buf) {
        return new EnergyStack(buf.readVarLong(), buf.readVarLong());
    }

    @NotNull
    @Generated
    public EnergyStack withVoltage(long voltage) {
        return this.voltage == voltage ? this : new EnergyStack(voltage, this.amperage);
    }

    @NotNull
    @Generated
    public EnergyStack withAmperage(long amperage) {
        return this.amperage == amperage ? this : new EnergyStack(this.voltage, amperage);
    }

    public record WithIO(EnergyStack stack, IO io) {
        private static final Codec<WithIO> FLAT_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.LONG.optionalFieldOf("voltage", (Object)0L).forGetter(WithIO::signedVoltage), (App)GTCodecUtils.POSITIVE_LONG.optionalFieldOf("amperage", (Object)1L).forGetter(WithIO::amperage)).apply((Applicative)instance, WithIO::fromVA));
        private static final Codec<WithIO> VOLTAGE_ONLY_CODEC = Codec.LONG.flatComapMap(WithIO::fromVoltage, s -> {
            if (s.amperage() == 1L) {
                return DataResult.success((Object)s.signedVoltage());
            }
            Supplier<String> error = () -> "primitive EnergyStacks must have 1A, got " + s.amperage();
            return DataResult.error(error, (Object)s.signedVoltage());
        });
        public static final Codec<WithIO> CODEC = Codec.either(VOLTAGE_ONLY_CODEC, FLAT_CODEC).xmap(GTCodecUtils::unboxEither, s -> {
            if (s.amperage() == 1L) {
                return Either.left((Object)s);
            }
            return Either.right((Object)s);
        });
        public static final WithIO EMPTY = new WithIO(EMPTY, IO.NONE);

        public WithIO {
            Preconditions.checkArgument((io != IO.BOTH ? 1 : 0) != 0, (Object)"The I/O direction cannot be IO.BOTH!");
            if (stack.isEmpty()) {
                io = IO.NONE;
            }
        }

        public WithIO(long voltage, long amperage, IO io) {
            this(new EnergyStack(voltage, amperage), io);
        }

        public static WithIO fromVA(long voltage, long amperage) {
            if (voltage == 0L) {
                return EMPTY;
            }
            return new WithIO(Math.abs(voltage), amperage, voltage > 0L ? IO.IN : IO.OUT);
        }

        public static WithIO fromVoltage(long voltage) {
            return WithIO.fromVA(voltage, 1L);
        }

        public boolean isEmpty() {
            return this.io == IO.NONE || this.stack.isEmpty();
        }

        public boolean isInput() {
            return this.io == IO.IN;
        }

        public boolean isOutput() {
            return this.io == IO.OUT;
        }

        public @Range(from=0L, to=0x7FFFFFFFFFFFFFFFL) long voltage() {
            return this.stack.voltage();
        }

        public @Range(from=1L, to=0x7FFFFFFFFFFFFFFFL) long amperage() {
            return this.stack.amperage();
        }

        public long getTotalEU() {
            return this.stack.getTotalEU();
        }

        public long signedVoltage() {
            long multiplier = this.isInput() ? 1L : -1L;
            return this.voltage() * multiplier;
        }

        @NotNull
        @Generated
        public WithIO withStack(EnergyStack stack) {
            return this.stack == stack ? this : new WithIO(stack, this.io);
        }

        @NotNull
        @Generated
        public WithIO withIo(IO io) {
            return this.io == io ? this : new WithIO(this.stack, io);
        }
    }
}

