/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.common.data.GTItems;
import com.gregtechceu.gtceu.common.item.IntCircuitBehaviour;
import com.gregtechceu.gtceu.core.mixins.forge.StrictNBTIngredientAccessor;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class IntCircuitIngredient
extends StrictNBTIngredient {
    public static final ResourceLocation TYPE = GTCEu.id("circuit");
    public static final int CIRCUIT_MIN = 0;
    public static final int CIRCUIT_MAX = 32;
    private static final IntCircuitIngredient[] INGREDIENTS = new IntCircuitIngredient[33];
    private final int configuration;
    private ItemStack[] stacks;
    public static final IIngredientSerializer<IntCircuitIngredient> SERIALIZER = new IIngredientSerializer<IntCircuitIngredient>(){

        @NotNull
        public IntCircuitIngredient parse(FriendlyByteBuf buffer) {
            int configuration = buffer.readVarInt();
            return IntCircuitIngredient.of(configuration);
        }

        @NotNull
        public IntCircuitIngredient parse(JsonObject json) {
            int configuration = json.get("configuration").getAsInt();
            return IntCircuitIngredient.of(configuration);
        }

        public void write(FriendlyByteBuf buffer, IntCircuitIngredient ingredient) {
            buffer.writeVarInt(ingredient.configuration);
        }
    };

    public static IntCircuitIngredient of(int configuration) {
        if (configuration < 0 || configuration > 32) {
            throw new IndexOutOfBoundsException("Circuit configuration " + configuration + " is out of range");
        }
        IntCircuitIngredient ingredient = INGREDIENTS[configuration];
        if (ingredient == null) {
            IntCircuitIngredient.INGREDIENTS[configuration] = ingredient = new IntCircuitIngredient(configuration);
        }
        return ingredient;
    }

    private IntCircuitIngredient(int configuration) {
        super(IntCircuitBehaviour.stack(configuration));
        this.configuration = configuration;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        return stack.is((Item)GTItems.PROGRAMMED_CIRCUIT.get()) && IntCircuitBehaviour.getCircuitConfiguration(stack) == this.configuration;
    }

    public ItemStack @NotNull [] getItems() {
        if (this.stacks == null) {
            this.stacks = new ItemStack[]{((StrictNBTIngredientAccessor)((Object)this)).getStack()};
        }
        return this.stacks;
    }

    @NotNull
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE.toString());
        json.addProperty("configuration", (Number)this.configuration);
        return json;
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public static IntCircuitIngredient fromJson(JsonObject json) {
        return (IntCircuitIngredient)SERIALIZER.parse(json);
    }
}

