/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.ingredient;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntCircuitIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderIngredient;
import com.gregtechceu.gtceu.core.mixins.IngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.ItemValueAccessor;
import com.gregtechceu.gtceu.core.mixins.TagValueAccessor;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.Arrays;
import java.util.stream.Stream;
import lombok.Generated;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.common.crafting.StrictNBTIngredient;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SizedIngredient
extends Ingredient {
    public static final ResourceLocation TYPE = GTCEu.id("sized");
    protected int amount;
    protected final Ingredient inner;
    protected ItemStack[] itemStacks = null;
    private boolean changed = true;
    private final boolean isEmpty;
    private final Ingredient.Value value;
    public static final IIngredientSerializer<SizedIngredient> SERIALIZER = new IIngredientSerializer<SizedIngredient>(){

        @NotNull
        public SizedIngredient parse(FriendlyByteBuf buffer) {
            int amount = buffer.readVarInt();
            return new SizedIngredient(Ingredient.fromNetwork((FriendlyByteBuf)buffer), amount);
        }

        @NotNull
        public SizedIngredient parse(JsonObject json) {
            int amount = json.get("count").getAsInt();
            Ingredient inner = Ingredient.fromJson((JsonElement)json.get("ingredient"));
            return new SizedIngredient(inner, amount);
        }

        public void write(FriendlyByteBuf buffer, SizedIngredient ingredient) {
            buffer.writeVarInt(ingredient.getAmount());
            ingredient.inner.toNetwork(buffer);
        }
    };

    protected SizedIngredient(Ingredient inner, int amount) {
        super(Stream.empty());
        Ingredient.Value[] values;
        this.amount = amount;
        this.inner = inner;
        this.isEmpty = inner.isEmpty();
        this.value = this.isEmpty || inner.getClass() != Ingredient.class ? null : ((values = ((IngredientAccessor)inner).getValues()).length == 1 ? values[0] : null);
    }

    protected SizedIngredient(@NotNull TagKey<Item> tag, int amount) {
        this(Ingredient.of(tag), amount);
    }

    protected SizedIngredient(ItemStack itemStack) {
        this((Ingredient)(itemStack.hasTag() ? StrictNBTIngredient.of((ItemStack)itemStack) : Ingredient.of((ItemStack[])new ItemStack[]{itemStack})), itemStack.getCount());
    }

    public static SizedIngredient create(ItemStack inner) {
        return new SizedIngredient(inner);
    }

    public static SizedIngredient create(Ingredient inner, int amount) {
        return new SizedIngredient(inner, amount);
    }

    public static SizedIngredient create(Ingredient inner) {
        return new SizedIngredient(inner, 1);
    }

    public static SizedIngredient create(TagKey<Item> tag, int amount) {
        return new SizedIngredient(tag, amount);
    }

    public static Ingredient copy(Ingredient ingredient) {
        if (ingredient instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)ingredient;
            Ingredient ingredient2 = sizedIngredient.inner;
            if (ingredient2 instanceof IntProviderIngredient) {
                IntProviderIngredient intProviderIngredient = (IntProviderIngredient)ingredient2;
                return SizedIngredient.copy(intProviderIngredient);
            }
            return SizedIngredient.create(sizedIngredient.inner, sizedIngredient.amount);
        }
        if (ingredient instanceof IntCircuitIngredient) {
            IntCircuitIngredient circuit = (IntCircuitIngredient)ingredient;
            return circuit;
        }
        if (ingredient instanceof IntProviderIngredient) {
            IntProviderIngredient intProviderIngredient = (IntProviderIngredient)ingredient;
            IntProviderIngredient copied = IntProviderIngredient.of(intProviderIngredient.inner, intProviderIngredient.countProvider);
            if (intProviderIngredient.itemStacks != null) {
                copied.itemStacks = (ItemStack[])Arrays.stream(intProviderIngredient.itemStacks).map(ItemStack::copy).toArray(ItemStack[]::new);
            }
            if (intProviderIngredient.sampledCount != -1) {
                copied.sampledCount = intProviderIngredient.sampledCount;
            }
            return copied;
        }
        return SizedIngredient.create(ingredient);
    }

    @NotNull
    public IIngredientSerializer<? extends Ingredient> getSerializer() {
        return SERIALIZER;
    }

    public static SizedIngredient fromJson(JsonObject json) {
        return (SizedIngredient)SERIALIZER.parse(json);
    }

    @NotNull
    public JsonElement toJson() {
        JsonObject json = new JsonObject();
        json.addProperty("type", TYPE.toString());
        json.addProperty("count", (Number)this.amount);
        json.add("ingredient", this.inner.toJson());
        return json;
    }

    public boolean test(@Nullable ItemStack stack) {
        if (stack == null) {
            return false;
        }
        if (this.isEmpty) {
            return stack.isEmpty();
        }
        Ingredient.Value value = this.value;
        if (value instanceof TagValueAccessor) {
            TagValueAccessor tagValue = (TagValueAccessor)value;
            return stack.is(tagValue.getTag());
        }
        value = this.value;
        if (value instanceof ItemValueAccessor) {
            ItemValueAccessor itemValue = (ItemValueAccessor)value;
            return ItemStack.isSameItem((ItemStack)stack, (ItemStack)itemValue.getItem());
        }
        return this.inner.test(stack);
    }

    public ItemStack @NotNull [] getItems() {
        Ingredient ingredient = this.getInner();
        if (ingredient instanceof IntProviderIngredient) {
            IntProviderIngredient intProviderIngredient = (IntProviderIngredient)ingredient;
            return intProviderIngredient.getItems();
        }
        if (this.changed || this.itemStacks == null) {
            ItemStack[] innerStacks = this.inner.getItems();
            this.itemStacks = new ItemStack[innerStacks.length];
            for (int i = 0; i < this.itemStacks.length; ++i) {
                this.itemStacks[i] = innerStacks[i].copyWithCount(this.amount);
            }
            this.changed = false;
        }
        return this.itemStacks;
    }

    public void setAmount(int amount) {
        this.amount = amount;
        this.changed = true;
    }

    @NotNull
    public IntList getStackingIds() {
        return this.inner.getStackingIds();
    }

    public int hashCode() {
        int result = this.amount;
        result = 31 * result + Arrays.hashCode(this.itemStacks);
        return result;
    }

    public static Ingredient getInner(Ingredient ingredient) {
        if (ingredient instanceof SizedIngredient) {
            SizedIngredient sizedIngredient = (SizedIngredient)ingredient;
            return SizedIngredient.getInner(sizedIngredient.getInner());
        }
        if (ingredient instanceof IntProviderIngredient) {
            IntProviderIngredient intProviderIngredient = (IntProviderIngredient)ingredient;
            return SizedIngredient.getInner(intProviderIngredient.getInner());
        }
        return ingredient;
    }

    @Generated
    public int getAmount() {
        return this.amount;
    }

    @Generated
    public Ingredient getInner() {
        return this.inner;
    }

    @Generated
    public boolean isEmpty() {
        return this.isEmpty;
    }
}

