/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.lookup;

import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.lookup.GTRecipeLookup;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class RecipeManagerHandler {
    public static void addProxyRecipesToLookup(@NotNull Map<ResourceLocation, Recipe<?>> recipesByID, @NotNull GTRecipeType gtRecipeType, @NotNull RecipeType<?> proxyType, @NotNull List<GTRecipe> proxyRecipes) {
        GTRecipeLookup lookup = gtRecipeType.getLookup();
        proxyRecipes.clear();
        recipesByID.forEach((id, recipe) -> {
            if (recipe.getType() != proxyType) {
                return;
            }
            GTRecipe gtRecipe = gtRecipeType.toGTrecipe((ResourceLocation)id, (Recipe<?>)recipe);
            proxyRecipes.add(gtRecipe);
            lookup.addRecipe(gtRecipe);
        });
    }

    public static void addRecipesToLookup(@NotNull Map<ResourceLocation, Recipe<?>> recipesByID, @NotNull GTRecipeType gtRecipeType) {
        GTRecipeLookup lookup = gtRecipeType.getLookup();
        for (Recipe<?> r : recipesByID.values()) {
            if (r.getType() != gtRecipeType || !(r instanceof GTRecipe)) continue;
            GTRecipe recipe = (GTRecipe)r;
            lookup.addRecipe(recipe);
        }
    }
}

