/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.lookup.ingredient.fluid;

import com.gregtechceu.gtceu.api.recipe.ingredient.FluidIngredient;
import com.gregtechceu.gtceu.api.recipe.ingredient.IntProviderFluidIngredient;
import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.AbstractMapIngredient;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.jetbrains.annotations.NotNull;

public class FluidStackMapIngredient
extends AbstractMapIngredient {
    protected FluidStack stack;
    protected FluidIngredient ingredient = null;

    public FluidStackMapIngredient(FluidStack stack) {
        this.stack = stack;
    }

    public FluidStackMapIngredient(FluidStack stack, FluidIngredient ingredient) {
        this.stack = stack;
        this.ingredient = ingredient;
    }

    @NotNull
    public static List<AbstractMapIngredient> from(@NotNull FluidIngredient ingredient) {
        ObjectArrayList ingredients = new ObjectArrayList();
        for (FluidIngredient.Value value : ingredient.values) {
            int n;
            if (!(value instanceof FluidIngredient.FluidValue)) continue;
            FluidIngredient.FluidValue fluidValue = (FluidIngredient.FluidValue)value;
            Fluid fluid = fluidValue.fluid();
            if (ingredient instanceof IntProviderFluidIngredient) {
                IntProviderFluidIngredient provider = (IntProviderFluidIngredient)ingredient;
                n = provider.getCountProvider().getMaxValue();
            } else {
                n = ingredient.getAmount();
            }
            FluidStack stack = new FluidStack(fluid, n, ingredient.getNbt());
            ingredients.add(new FluidStackMapIngredient(stack, ingredient));
        }
        return ingredients;
    }

    @NotNull
    public static List<AbstractMapIngredient> from(@NotNull FluidStack stack) {
        return Collections.singletonList(new FluidStackMapIngredient(stack));
    }

    @Override
    protected int hash() {
        return this.stack.hashCode();
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            FluidStackMapIngredient other = (FluidStackMapIngredient)o;
            if (this.stack.getFluid() != other.stack.getFluid()) {
                return false;
            }
            if (this.ingredient != null) {
                if (other.ingredient != null) {
                    return this.ingredient.equals(other.ingredient);
                }
                return this.ingredient.test(other.stack);
            }
            if (other.ingredient != null) {
                return other.ingredient.test(this.stack);
            }
        }
        return false;
    }

    public String toString() {
        return "FluidStackMapIngredient{fluid=" + String.valueOf(this.stack) + "}";
    }
}

