/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.recipe.lookup.ingredient.item;

import com.gregtechceu.gtceu.api.recipe.lookup.ingredient.AbstractMapIngredient;
import com.gregtechceu.gtceu.core.mixins.IngredientAccessor;
import com.gregtechceu.gtceu.core.mixins.ItemValueAccessor;
import com.gregtechceu.gtceu.utils.IngredientEquality;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.jetbrains.annotations.NotNull;

public class ItemStackMapIngredient
extends AbstractMapIngredient {
    protected ItemStack stack;
    protected Ingredient ingredient = null;

    public ItemStackMapIngredient(ItemStack stack) {
        this.stack = stack;
    }

    public ItemStackMapIngredient(ItemStack stack, Ingredient ingredient) {
        this.stack = stack;
        this.ingredient = ingredient;
    }

    @NotNull
    public static List<AbstractMapIngredient> from(Ingredient ingredient) {
        ObjectArrayList ingredients = new ObjectArrayList();
        for (Ingredient.Value value : ((IngredientAccessor)ingredient).getValues()) {
            if (!(value instanceof ItemValueAccessor)) continue;
            ItemValueAccessor itemValue = (ItemValueAccessor)value;
            ingredients.add(new ItemStackMapIngredient(itemValue.getItem(), ingredient));
        }
        return ingredients;
    }

    @NotNull
    public static List<AbstractMapIngredient> from(ItemStack stack) {
        return Collections.singletonList(new ItemStackMapIngredient(stack));
    }

    @Override
    public boolean equals(Object o) {
        if (super.equals(o)) {
            ItemStackMapIngredient other = (ItemStackMapIngredient)o;
            if (!ItemStack.isSameItem((ItemStack)this.stack, (ItemStack)other.stack)) {
                return false;
            }
            if (this.ingredient != null) {
                if (other.ingredient != null) {
                    return IngredientEquality.ingredientEquals(this.ingredient, other.ingredient);
                }
                return this.ingredient.test(other.stack);
            }
            if (other.ingredient != null) {
                return other.ingredient.test(this.stack);
            }
        }
        return false;
    }

    @Override
    protected int hash() {
        return this.stack.getItem().hashCode() * 31;
    }

    public String toString() {
        return "ItemStackMapIngredient{item=" + String.valueOf(this.stack) + "}";
    }
}

