/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry;

import com.gregtechceu.gtceu.GTCEu;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.fml.ModContainer;
import net.minecraftforge.fml.ModLoadingContext;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.UnmodifiableView;

public abstract class GTRegistry<K, V>
implements Iterable<V> {
    public static final Map<ResourceLocation, GTRegistry<?, ?>> REGISTERED = new HashMap();
    protected final Map<K, V> keyToValue = new HashMap();
    protected final Map<V, K> valueToKey = new HashMap<V, K>();
    protected final ResourceLocation registryName;
    protected boolean frozen = true;

    public GTRegistry(ResourceLocation registryName) {
        this.registryName = registryName;
        REGISTERED.put(registryName, this);
    }

    public boolean containKey(K key) {
        return this.keyToValue.containsKey(key);
    }

    public boolean containValue(V value) {
        return this.keyToValue.containsValue(value);
    }

    public void freeze() {
        if (this.frozen) {
            throw new IllegalStateException("Registry is already frozen!");
        }
        if (!this.checkActiveModContainerIsGregtech()) {
            return;
        }
        this.frozen = true;
    }

    public void unfreeze() {
        if (!this.frozen) {
            throw new IllegalStateException("Registry is already unfrozen!");
        }
        if (!this.checkActiveModContainerIsGregtech()) {
            return;
        }
        this.frozen = false;
    }

    private boolean checkActiveModContainerIsGregtech() {
        ModContainer container = ModLoadingContext.get().getActiveContainer();
        return container != null && (container.getModId().equals(this.registryName.getNamespace()) || container.getModId().equals("gtceu") || container.getModId().equals("minecraft"));
    }

    public <T extends V> T register(K key, T value) {
        if (this.keyToValue.containsKey(key)) {
            throw new IllegalStateException("[register] registry %s contains key %s already".formatted(this.registryName, key));
        }
        return this.registerOrOverride(key, value);
    }

    public void remap(K oldKey, K newKey) {
        if (this.frozen) {
            throw new IllegalStateException("[register] registry %s has been frozen".formatted(this.registryName));
        }
        if (this.keyToValue.containsKey(oldKey)) {
            GTCEu.LOGGER.warn("[remap] cannot remap existing key {} in registry {}", oldKey, (Object)this.registryName);
            return;
        }
        if (!this.keyToValue.containsKey(newKey)) {
            GTCEu.LOGGER.warn("[remap] couldn't find value for key {} in registry {}", newKey, (Object)this.registryName);
            return;
        }
        V newValue = this.keyToValue.get(newKey);
        this.keyToValue.put(oldKey, newValue);
    }

    @Nullable
    public <T extends V> T replace(K key, T value) {
        if (!this.containKey(key)) {
            GTCEu.LOGGER.warn("[replace] couldn't find key {} in registry {}", (Object)this.registryName, key);
        }
        return this.registerOrOverride(key, value);
    }

    public <T extends V> T registerOrOverride(K key, T value) {
        if (this.frozen) {
            throw new IllegalStateException("[register] registry %s has been frozen".formatted(this.registryName));
        }
        this.keyToValue.put(key, value);
        this.valueToKey.put(value, key);
        return value;
    }

    @Override
    @NotNull
    public @UnmodifiableView Iterator<V> iterator() {
        return this.registry().values().iterator();
    }

    public @UnmodifiableView Set<V> values() {
        return Collections.unmodifiableMap(this.valueToKey).keySet();
    }

    public @UnmodifiableView Set<K> keys() {
        return this.registry().keySet();
    }

    public @UnmodifiableView Set<Map.Entry<K, V>> entries() {
        return this.registry().entrySet();
    }

    public @UnmodifiableView Map<K, V> registry() {
        return Collections.unmodifiableMap(this.keyToValue);
    }

    public void clear() {
        if (this.frozen) {
            throw new IllegalArgumentException("Registry is frozen!");
        }
        this.keyToValue.clear();
        this.valueToKey.clear();
    }

    @Nullable
    public V get(K key) {
        return this.keyToValue.get(key);
    }

    public V getOrDefault(K key, V defaultValue) {
        return this.keyToValue.getOrDefault(key, defaultValue);
    }

    public K getKey(V value) {
        return this.valueToKey.get(value);
    }

    public K getOrDefaultKey(V value, K defaultKey) {
        return this.valueToKey.getOrDefault(value, defaultKey);
    }

    public abstract void writeBuf(V var1, FriendlyByteBuf var2);

    @Nullable
    public abstract V readBuf(FriendlyByteBuf var1);

    public abstract Tag saveToNBT(V var1);

    @Nullable
    public abstract V loadFromNBT(Tag var1);

    public boolean remove(K name) {
        V value = this.keyToValue.remove(name);
        if (value != null) {
            this.valueToKey.remove(value);
            return true;
        }
        return false;
    }

    public abstract Codec<V> codec();

    @Generated
    public ResourceLocation getRegistryName() {
        return this.registryName;
    }

    @Generated
    public boolean isFrozen() {
        return this.frozen;
    }

    public static class RL<V>
    extends GTRegistry<ResourceLocation, V> {
        public RL(ResourceLocation registryName) {
            super(registryName);
        }

        @Override
        public void writeBuf(V value, FriendlyByteBuf buf) {
            buf.writeBoolean(this.containValue(value));
            if (this.containValue(value)) {
                buf.writeUtf(((ResourceLocation)this.getKey(value)).toString());
            }
        }

        @Override
        public V readBuf(FriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                return this.get(new ResourceLocation(buf.readUtf()));
            }
            return null;
        }

        @Override
        public Tag saveToNBT(V value) {
            if (this.containValue(value)) {
                return StringTag.valueOf((java.lang.String)((ResourceLocation)this.getKey(value)).toString());
            }
            return new CompoundTag();
        }

        @Override
        public V loadFromNBT(Tag tag) {
            return this.get(new ResourceLocation(tag.getAsString()));
        }

        @Override
        public Codec<V> codec() {
            return ResourceLocation.CODEC.flatXmap(key -> Optional.ofNullable(this.get(key)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in %s: %s".formatted(this.registryName, key))), val -> Optional.ofNullable((ResourceLocation)this.getKey(val)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry value in %s: %s".formatted(this.registryName, val))));
        }
    }

    public static class String<V>
    extends GTRegistry<java.lang.String, V> {
        public String(ResourceLocation registryName) {
            super(registryName);
        }

        @Override
        public void writeBuf(V value, FriendlyByteBuf buf) {
            buf.writeBoolean(this.containValue(value));
            if (this.containValue(value)) {
                buf.writeUtf((java.lang.String)this.getKey(value));
            }
        }

        @Override
        public V readBuf(FriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                return this.get(buf.readUtf());
            }
            return null;
        }

        @Override
        public Tag saveToNBT(V value) {
            if (this.containValue(value)) {
                return StringTag.valueOf((java.lang.String)((java.lang.String)this.getKey(value)));
            }
            return new CompoundTag();
        }

        @Override
        public V loadFromNBT(Tag tag) {
            return this.get(tag.getAsString());
        }

        @Override
        public Codec<V> codec() {
            return Codec.STRING.flatXmap(key -> Optional.ofNullable(this.get(key)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry key in %s: %s".formatted(this.registryName, key))), val -> Optional.ofNullable((java.lang.String)this.getKey(val)).map(DataResult::success).orElseGet(() -> DataResult.error(() -> "Unknown registry value in %s: %s".formatted(this.registryName, val))));
        }
    }
}

