/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.gregtechceu.gtceu.GTCEu;
import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifierList;
import com.gregtechceu.gtceu.api.registry.GTRegistries;
import com.gregtechceu.gtceu.api.registry.registrate.BuilderBase;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.api.registry.registrate.provider.GTBlockstateProvider;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.client.renderer.BlockEntityWithBERModelRenderer;
import com.gregtechceu.gtceu.common.data.GTRecipeModifiers;
import com.gregtechceu.gtceu.common.data.GTRecipeTypes;
import com.gregtechceu.gtceu.common.data.models.GTMachineModels;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.data.model.builder.MachineModelBuilder;
import com.gregtechceu.gtceu.integration.kjs.GregTechKubeJSPlugin;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.BlockEntityBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.util.entry.BlockEntityEntry;
import com.tterrag.registrate.util.entry.BlockEntry;
import com.tterrag.registrate.util.entry.ItemEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import dev.latvian.mods.kubejs.client.LangEventJS;
import dev.latvian.mods.kubejs.generator.AssetJsonGenerator;
import dev.latvian.mods.rhino.util.HideFromJS;
import dev.latvian.mods.rhino.util.RemapPrefixForJS;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@RemapPrefixForJS(value="kjs$")
public class MachineBuilder<DEFINITION extends MachineDefinition>
extends BuilderBase<DEFINITION> {
    protected final GTRegistrate registrate;
    protected final String name;
    protected final BiFunction<BlockBehaviour.Properties, DEFINITION, IMachineBlock> blockFactory;
    protected final BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory;
    protected final TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory;
    protected final Function<ResourceLocation, DEFINITION> definition;
    protected Function<IMachineBlockEntity, MetaMachine> machine;
    @Nullable
    private ModelInitializer model = null;
    @Nullable
    private NonNullBiConsumer<DataGenContext<Block, ? extends Block>, GTBlockstateProvider> blockModel = null;
    protected final Map<Property<?>, @Nullable Comparable<?>> modelProperties = new IdentityHashMap();
    private VoxelShape shape = Shapes.block();
    private RotationState rotationState = RotationState.NON_Y_AXIS;
    private boolean allowExtendedFacing = false;
    private boolean hasBER;
    private boolean renderMultiblockWorldPreview;
    private boolean renderMultiblockXEIPreview;
    private NonNullUnaryOperator<BlockBehaviour.Properties> blockProp;
    private NonNullUnaryOperator<Item.Properties> itemProp;
    @Nullable
    private Consumer<BlockBuilder<? extends Block, ?>> blockBuilder;
    @Nullable
    private Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder;
    private NonNullConsumer<BlockEntityType<BlockEntity>> onBlockEntityRegister;
    @NotNull
    private @NotNull GTRecipeType @NotNull [] recipeTypes;
    private int tier;
    private Object2IntMap<RecipeCapability<?>> recipeOutputLimits;
    private int paintingColor;
    private BiFunction<ItemStack, Integer, Integer> itemColor;
    private PartAbility[] abilities;
    private final List<Component> tooltips;
    @Nullable
    private BiConsumer<ItemStack, List<Component>> tooltipBuilder;
    private RecipeModifier recipeModifier;
    private boolean alwaysTryModifyRecipe;
    @NotNull
    private BiPredicate<IRecipeLogicMachine, GTRecipe> beforeWorking;
    @NotNull
    private Predicate<IRecipeLogicMachine> onWorking;
    @NotNull
    private Consumer<IRecipeLogicMachine> onWaiting;
    @NotNull
    private Consumer<IRecipeLogicMachine> afterWorking;
    private boolean regressWhenWaiting;
    private boolean allowCoverOnFront;
    private Supplier<BlockState> appearance;
    @Nullable
    private EditableMachineUI editableUI;
    @Nullable
    private String langValue;

    public MachineBuilder(GTRegistrate registrate, String name, Function<ResourceLocation, DEFINITION> definition, Function<IMachineBlockEntity, MetaMachine> machine2, BiFunction<BlockBehaviour.Properties, DEFINITION, IMachineBlock> blockFactory, BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory, TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory) {
        super(new ResourceLocation(registrate.getModid(), name));
        this.hasBER = ConfigHolder.INSTANCE.client.machinesHaveBERsByDefault;
        this.renderMultiblockWorldPreview = true;
        this.renderMultiblockXEIPreview = true;
        this.blockProp = p -> p;
        this.itemProp = p -> p;
        this.onBlockEntityRegister = NonNullConsumer.noop();
        this.recipeTypes = new GTRecipeType[0];
        this.recipeOutputLimits = new Object2IntOpenHashMap();
        this.paintingColor = ConfigHolder.INSTANCE.client.getDefaultPaintingColor();
        this.itemColor = (itemStack, tintIndex) -> tintIndex == 2 ? GTValues.VC[this.tier] : (tintIndex == 1 ? this.paintingColor : -1);
        this.abilities = new PartAbility[0];
        this.tooltips = new ArrayList<Component>();
        this.recipeModifier = new RecipeModifierList(GTRecipeModifiers.OC_NON_PERFECT);
        this.beforeWorking = (machine, recipe) -> true;
        this.onWorking = machine -> true;
        this.onWaiting = machine -> {};
        this.afterWorking = machine -> {};
        this.regressWhenWaiting = true;
        this.allowCoverOnFront = false;
        this.langValue = null;
        this.registrate = registrate;
        this.name = name;
        this.machine = machine2;
        this.blockFactory = blockFactory;
        this.itemFactory = itemFactory;
        this.blockEntityFactory = blockEntityFactory;
        this.definition = definition;
    }

    public MachineBuilder<DEFINITION> recipeType(GTRecipeType type) {
        if (type == null) {
            GTCEu.LOGGER.error("Tried to set null recipe type on machine {}. Did you create the recipe type before this machine?", (Object)this.id);
            return this;
        }
        this.recipeTypes = (GTRecipeType[])ArrayUtils.add((Object[])this.recipeTypes, (Object)type);
        this.initRecipeMachineModelProperties(type);
        return this;
    }

    public MachineBuilder<DEFINITION> recipeTypes(GTRecipeType ... types) {
        ArrayList<GTRecipeType> typeList = new ArrayList<GTRecipeType>();
        Collections.addAll(typeList, this.recipeTypes);
        for (int i = 0; i < types.length; ++i) {
            GTRecipeType type = types[i];
            if (type != null) {
                this.initRecipeMachineModelProperties(type);
                typeList.add(type);
                continue;
            }
            GTCEu.LOGGER.error("Tried to set null recipe type on machine {} (index {}). Did you create the recipe type before this machine?", (Object)this.id, (Object)i);
        }
        this.recipeTypes = (GTRecipeType[])typeList.toArray(GTRecipeType[]::new);
        return this;
    }

    protected void initRecipeMachineModelProperties(GTRecipeType type) {
        if (type == GTRecipeTypes.DUMMY_RECIPES) {
            return;
        }
        if (!this.modelProperties.containsKey(GTMachineModelProperties.RECIPE_LOGIC_STATUS)) {
            this.modelProperty((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS, (Comparable)((Object)RecipeLogic.Status.IDLE));
        }
    }

    public MachineBuilder<DEFINITION> simpleModel(ResourceLocation modelName) {
        return this.model(GTMachineModels.createBasicMachineModel(modelName));
    }

    public MachineBuilder<DEFINITION> defaultModel() {
        return this.simpleModel(new ResourceLocation(this.registrate.getModid(), "block/machine/template/" + this.name));
    }

    public MachineBuilder<DEFINITION> tieredHullModel(ResourceLocation model) {
        return this.model(GTMachineModels.createTieredHullMachineModel(model));
    }

    public MachineBuilder<DEFINITION> overlayTieredHullModel(String name) {
        this.modelProperty((Property)GTMachineModelProperties.IS_FORMED, false);
        return this.overlayTieredHullModel(new ResourceLocation(this.registrate.getModid(), "block/machine/part/" + name));
    }

    public MachineBuilder<DEFINITION> overlayTieredHullModel(ResourceLocation overlayModel) {
        return this.model(GTMachineModels.createOverlayTieredHullMachineModel(overlayModel));
    }

    public MachineBuilder<DEFINITION> colorOverlayTieredHullModel(String overlay) {
        return this.colorOverlayTieredHullModel(overlay, null, null);
    }

    public MachineBuilder<DEFINITION> colorOverlayTieredHullModel(String overlay, @Nullable String pipeOverlay, @Nullable String emissiveOverlay) {
        this.modelProperty((Property)GTMachineModelProperties.IS_FORMED, false);
        ResourceLocation overlayTex = new ResourceLocation(this.registrate.getModid(), "block/overlay/machine/" + overlay);
        ResourceLocation pipeOverlayTex = pipeOverlay == null ? null : new ResourceLocation(this.registrate.getModid(), "block/overlay/machine/" + pipeOverlay);
        ResourceLocation emissiveOverlayTex = emissiveOverlay == null ? null : new ResourceLocation(this.registrate.getModid(), "block/overlay/machine/" + emissiveOverlay);
        return this.colorOverlayTieredHullModel(overlayTex, pipeOverlayTex, emissiveOverlayTex);
    }

    public MachineBuilder<DEFINITION> colorOverlayTieredHullModel(ResourceLocation overlay) {
        this.modelProperty((Property)GTMachineModelProperties.IS_FORMED, false);
        return this.colorOverlayTieredHullModel(overlay, null, null);
    }

    public MachineBuilder<DEFINITION> colorOverlayTieredHullModel(ResourceLocation overlay, @Nullable ResourceLocation pipeOverlay, @Nullable ResourceLocation emissiveOverlay) {
        this.modelProperty((Property)GTMachineModelProperties.IS_PAINTED, false);
        return this.model(GTMachineModels.createColorOverlayTieredHullMachineModel(overlay, pipeOverlay, emissiveOverlay));
    }

    public MachineBuilder<DEFINITION> overlaySteamHullModel(String name) {
        this.modelProperty((Property)GTMachineModelProperties.IS_FORMED, false);
        return this.overlaySteamHullModel(new ResourceLocation(this.registrate.getModid(), "block/machine/part/" + name));
    }

    public MachineBuilder<DEFINITION> overlaySteamHullModel(ResourceLocation overlayModel) {
        this.modelProperty((Property)GTMachineModelProperties.IS_STEEL_MACHINE, ConfigHolder.INSTANCE.machines.steelSteamMultiblocks);
        return this.model(GTMachineModels.createOverlaySteamHullMachineModel(overlayModel));
    }

    public MachineBuilder<DEFINITION> colorOverlaySteamHullModel(String overlay) {
        return this.colorOverlaySteamHullModel(overlay, (String)null, null);
    }

    public MachineBuilder<DEFINITION> colorOverlaySteamHullModel(String overlay, @Nullable String pipeOverlay, @Nullable String emissiveOverlay) {
        this.modelProperty((Property)GTMachineModelProperties.IS_FORMED, false);
        ResourceLocation overlayTex = new ResourceLocation(this.registrate.getModid(), "block/overlay/machine/" + overlay);
        ResourceLocation pipeOverlayTex = pipeOverlay == null ? null : new ResourceLocation(this.registrate.getModid(), "block/overlay/machine/" + pipeOverlay);
        ResourceLocation emissiveOverlayTex = emissiveOverlay == null ? null : new ResourceLocation(this.registrate.getModid(), "block/overlay/machine/" + emissiveOverlay);
        return this.colorOverlaySteamHullModel(overlayTex, pipeOverlayTex, emissiveOverlayTex);
    }

    public MachineBuilder<DEFINITION> colorOverlaySteamHullModel(String overlay, @Nullable ResourceLocation pipeOverlay, @Nullable String emissiveOverlay) {
        this.modelProperty((Property)GTMachineModelProperties.IS_FORMED, false);
        ResourceLocation overlayTex = new ResourceLocation(this.registrate.getModid(), "block/overlay/machine/" + overlay);
        ResourceLocation pipeOverlayTex = pipeOverlay == null ? null : new ResourceLocation(this.registrate.getModid(), "block/overlay/machine/" + String.valueOf(pipeOverlay));
        ResourceLocation emissiveOverlayTex = emissiveOverlay == null ? null : new ResourceLocation(this.registrate.getModid(), "block/overlay/machine/" + emissiveOverlay);
        return this.colorOverlaySteamHullModel(overlayTex, pipeOverlayTex, emissiveOverlayTex);
    }

    public MachineBuilder<DEFINITION> colorOverlaySteamHullModel(ResourceLocation overlay) {
        return this.colorOverlaySteamHullModel(overlay, null, null);
    }

    public MachineBuilder<DEFINITION> colorOverlaySteamHullModel(ResourceLocation overlay, @Nullable ResourceLocation pipeOverlay, @Nullable ResourceLocation emissiveOverlay) {
        this.modelProperty((Property)GTMachineModelProperties.IS_PAINTED, false);
        return this.model(GTMachineModels.createColorOverlaySteamHullMachineModel(overlay, pipeOverlay, emissiveOverlay));
    }

    public MachineBuilder<DEFINITION> workableTieredHullModel(ResourceLocation workableModel) {
        this.modelProperty((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS, (Comparable)((Object)RecipeLogic.Status.IDLE));
        return this.model(GTMachineModels.createWorkableTieredHullMachineModel(workableModel));
    }

    public MachineBuilder<DEFINITION> simpleGeneratorModel(ResourceLocation workableModel) {
        this.modelProperty((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS, (Comparable)((Object)RecipeLogic.Status.IDLE));
        return this.model(GTMachineModels.createSimpleGeneratorModel(workableModel));
    }

    public MachineBuilder<DEFINITION> workableSteamHullModel(boolean isHighPressure, ResourceLocation workableModel) {
        this.modelProperty((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS, (Comparable)((Object)RecipeLogic.Status.IDLE));
        return this.model(GTMachineModels.createWorkableSteamHullMachineModel(isHighPressure, workableModel));
    }

    public MachineBuilder<DEFINITION> workableCasingModel(ResourceLocation baseCasing, ResourceLocation workableModel) {
        this.modelProperty((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS, (Comparable)((Object)RecipeLogic.Status.IDLE));
        return this.model(GTMachineModels.createWorkableCasingMachineModel(baseCasing, workableModel));
    }

    public MachineBuilder<DEFINITION> sidedOverlayCasingModel(ResourceLocation baseCasing, ResourceLocation workableModel) {
        return this.model(GTMachineModels.createSidedOverlayCasingMachineModel(baseCasing, workableModel));
    }

    public MachineBuilder<DEFINITION> sidedWorkableCasingModel(ResourceLocation baseCasing, ResourceLocation workableModel) {
        this.modelProperty((Property)GTMachineModelProperties.RECIPE_LOGIC_STATUS, (Comparable)((Object)RecipeLogic.Status.IDLE));
        return this.model(GTMachineModels.createSidedWorkableCasingMachineModel(baseCasing, workableModel));
    }

    public MachineBuilder<DEFINITION> appearanceBlock(Supplier<? extends Block> block) {
        this.appearance = () -> ((Block)block.get()).defaultBlockState();
        return this;
    }

    public MachineBuilder<DEFINITION> tooltips(Component ... components) {
        return this.tooltips(Arrays.asList(components));
    }

    public MachineBuilder<DEFINITION> tooltips(List<? extends @Nullable Component> components) {
        this.tooltips.addAll(components.stream().filter(Objects::nonNull).toList());
        return this;
    }

    public MachineBuilder<DEFINITION> conditionalTooltip(Component component, BooleanSupplier condition) {
        return this.conditionalTooltip(component, condition.getAsBoolean());
    }

    public MachineBuilder<DEFINITION> conditionalTooltip(Component component, boolean condition) {
        if (condition) {
            this.tooltips.add(component);
        }
        return this;
    }

    public MachineBuilder<DEFINITION> abilities(PartAbility ... abilities) {
        this.abilities = abilities;
        return this;
    }

    public MachineBuilder<DEFINITION> modelProperty(Property<?> property) {
        return this.modelProperty(property, null);
    }

    public <T extends Comparable<T>> MachineBuilder<DEFINITION> modelProperty(Property<T> property, @Nullable T defaultValue) {
        this.modelProperties.put(property, defaultValue);
        return this;
    }

    public MachineBuilder<DEFINITION> kjs$modelPropertyBool(Property<Boolean> property, boolean defaultValue) {
        return this.modelProperty(property, defaultValue);
    }

    public MachineBuilder<DEFINITION> kjs$modelPropertyInt(Property<Integer> property, int defaultValue) {
        return this.modelProperty(property, defaultValue);
    }

    public <T extends Enum<T>> MachineBuilder<DEFINITION> kjs$modelPropertyEnum(Property<T> property, T defaultValue) {
        return this.modelProperty(property, defaultValue);
    }

    public MachineBuilder<DEFINITION> modelProperties(Property<?> ... properties) {
        return this.modelProperties(List.of(properties));
    }

    public MachineBuilder<DEFINITION> modelProperties(Collection<Property<?>> properties) {
        for (Property<?> prop : properties) {
            this.modelProperties.put(prop, null);
        }
        return this;
    }

    public MachineBuilder<DEFINITION> modelProperties(Map<Property<?>, ? extends Comparable<?>> properties) {
        this.modelProperties.putAll(properties);
        return this;
    }

    public MachineBuilder<DEFINITION> removeModelProperty(Property<?> property) {
        this.modelProperties.remove(property);
        return this;
    }

    public MachineBuilder<DEFINITION> clearModelProperties() {
        this.modelProperties.clear();
        return this;
    }

    public MachineBuilder<DEFINITION> recipeModifier(RecipeModifier recipeModifier) {
        RecipeModifierList list;
        this.recipeModifier = recipeModifier instanceof RecipeModifierList ? (list = (RecipeModifierList)recipeModifier) : new RecipeModifierList(recipeModifier);
        return this;
    }

    public MachineBuilder<DEFINITION> recipeModifier(RecipeModifier recipeModifier, boolean alwaysTryModifyRecipe) {
        this.alwaysTryModifyRecipe = alwaysTryModifyRecipe;
        return this.recipeModifier(recipeModifier);
    }

    public MachineBuilder<DEFINITION> recipeModifiers(RecipeModifier ... recipeModifiers) {
        this.recipeModifier = new RecipeModifierList(recipeModifiers);
        return this;
    }

    public MachineBuilder<DEFINITION> recipeModifiers(boolean alwaysTryModifyRecipe, RecipeModifier ... recipeModifiers) {
        return this.recipeModifier(new RecipeModifierList(recipeModifiers), alwaysTryModifyRecipe);
    }

    public MachineBuilder<DEFINITION> noRecipeModifier() {
        this.recipeModifier = new RecipeModifierList(RecipeModifier.NO_MODIFIER);
        this.alwaysTryModifyRecipe = false;
        return this;
    }

    public MachineBuilder<DEFINITION> addOutputLimit(RecipeCapability<?> capability, int limit) {
        this.recipeOutputLimits.put(capability, limit);
        return this;
    }

    public MachineBuilder<DEFINITION> multiblockPreviewRenderer(boolean multiBlockWorldPreview, boolean multiBlockXEIPreview) {
        this.renderMultiblockWorldPreview = multiBlockWorldPreview;
        this.renderMultiblockXEIPreview = multiBlockXEIPreview;
        return this;
    }

    protected DEFINITION createDefinition() {
        return (DEFINITION)((MachineDefinition)this.definition.apply(new ResourceLocation(this.registrate.getModid(), this.name)));
    }

    @Override
    public void generateAssetJsons(@Nullable AssetJsonGenerator generator) {
        super.generateAssetJsons(generator);
        KJSCallWrapper.generateAssetJsons(generator, this, (MachineDefinition)this.value);
    }

    @Override
    public void generateLang(LangEventJS lang) {
        super.generateLang(lang);
        if (this.langValue() != null) {
            lang.add("gtceu", ((MachineDefinition)this.value).getDescriptionId(), ((MachineDefinition)this.value).getLangValue());
        }
    }

    protected void setupStateDefinition(MachineDefinition definition) {
        StateDefinition.Builder builder = new StateDefinition.Builder((Object)definition);
        this.modelProperties.keySet().forEach(xva$0 -> builder.add(new Property[]{xva$0}));
        definition.setStateDefinition((StateDefinition<MachineDefinition, MachineRenderState>)builder.create(MachineDefinition::defaultRenderState, MachineRenderState::new));
        MachineRenderState defaultState = (MachineRenderState)definition.getStateDefinition().any();
        for (Map.Entry<Property<?>, Comparable<?>> entry : this.modelProperties.entrySet()) {
            if (entry.getValue() == null) continue;
            defaultState = (MachineRenderState)((Object)defaultState.setValue(entry.getKey(), entry.getValue()));
        }
        definition.registerDefaultState(defaultState);
    }

    @Override
    @HideFromJS
    public DEFINITION register() {
        this.registrate.object(this.name);
        DEFINITION definition = this.createDefinition();
        ((MachineDefinition)definition).setRotationState(this.rotationState);
        this.setupStateDefinition((MachineDefinition)definition);
        if (this.model == null && this.blockModel == null) {
            this.simpleModel(new ResourceLocation(this.registrate.getModid(), "block/machine/template/" + this.name));
        }
        BlockBuilder<Block, AbstractRegistrate<?>> blockBuilder = BlockBuilderWrapper.makeBlockBuilder(this, definition);
        if (this.langValue != null) {
            blockBuilder.lang(this.langValue);
            ((MachineDefinition)definition).setLangValue(this.langValue);
        }
        if (this.blockBuilder != null) {
            this.blockBuilder.accept(blockBuilder);
        }
        BlockEntry block = blockBuilder.register();
        ItemBuilder<MetaMachineItem, AbstractRegistrate<?>> itemBuilder = ItemBuilderWrapper.makeItemBuilder(this, (BlockEntry<Block>)block);
        if (this.itemBuilder != null) {
            this.itemBuilder.accept(itemBuilder);
        }
        ItemEntry item = itemBuilder.register();
        BlockEntityBuilder blockEntityBuilder = ((BlockEntityBuilder)this.registrate.blockEntity((type, pos, state) -> ((IMachineBlockEntity)this.blockEntityFactory.apply((Object)type, (Object)pos, (Object)state)).self()).onRegister(this.onBlockEntityRegister)).validBlock((NonNullSupplier)block);
        if (this.hasBER) {
            blockEntityBuilder = blockEntityBuilder.renderer(() -> BlockEntityWithBERModelRenderer::new);
        }
        BlockEntityEntry blockEntity = blockEntityBuilder.register();
        ((MachineDefinition)definition).setRecipeTypes(this.recipeTypes);
        ((MachineDefinition)definition).setBlockSupplier((Supplier<Block>)block);
        ((MachineDefinition)definition).setItemSupplier((Supplier<MetaMachineItem>)item);
        ((MachineDefinition)definition).setTier(this.tier);
        ((MachineDefinition)definition).setRecipeOutputLimits(this.recipeOutputLimits);
        ((MachineDefinition)definition).setBlockEntityTypeSupplier(() -> ((BlockEntityEntry)blockEntity).get());
        ((MachineDefinition)definition).setMachineSupplier(this.machine);
        ((MachineDefinition)definition).setTooltipBuilder((itemStack, components) -> {
            components.addAll(this.tooltips);
            if (this.tooltipBuilder != null) {
                this.tooltipBuilder.accept((ItemStack)itemStack, (List<Component>)components);
            }
        });
        ((MachineDefinition)definition).setRecipeModifier(this.recipeModifier);
        ((MachineDefinition)definition).setAlwaysTryModifyRecipe(this.alwaysTryModifyRecipe);
        ((MachineDefinition)definition).setBeforeWorking(this.beforeWorking);
        ((MachineDefinition)definition).setOnWorking(this.onWorking);
        ((MachineDefinition)definition).setOnWaiting(this.onWaiting);
        ((MachineDefinition)definition).setAfterWorking(this.afterWorking);
        ((MachineDefinition)definition).setRegressWhenWaiting(this.regressWhenWaiting);
        ((MachineDefinition)definition).setAllowCoverOnFront(this.allowCoverOnFront);
        for (GTRecipeType type2 : this.recipeTypes) {
            if (type2.getIconSupplier() != null) continue;
            type2.setIconSupplier(() -> definition.asStack());
        }
        if (this.appearance == null) {
            this.appearance = () -> ((BlockEntry)block).getDefaultState();
        }
        if (this.editableUI != null) {
            ((MachineDefinition)definition).setEditableUI(this.editableUI);
        }
        ((MachineDefinition)definition).setAppearance(this.appearance);
        ((MachineDefinition)definition).setAllowExtendedFacing(this.allowExtendedFacing);
        ((MachineDefinition)definition).setShape(this.shape);
        ((MachineDefinition)definition).setDefaultPaintingColor(this.paintingColor);
        ((MachineDefinition)definition).setRenderXEIPreview(this.renderMultiblockXEIPreview);
        ((MachineDefinition)definition).setRenderWorldPreview(this.renderMultiblockWorldPreview);
        GTRegistries.MACHINES.register(((MachineDefinition)definition).getId(), definition);
        this.value = definition;
        return (DEFINITION)((MachineDefinition)this.value);
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> machine(Function<IMachineBlockEntity, MetaMachine> machine) {
        this.machine = machine;
        return this;
    }

    @Nullable
    @Generated
    public ModelInitializer model() {
        return this.model;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> model(@Nullable ModelInitializer model) {
        this.model = model;
        return this;
    }

    @Nullable
    @Generated
    public NonNullBiConsumer<DataGenContext<Block, ? extends Block>, GTBlockstateProvider> blockModel() {
        return this.blockModel;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> blockModel(@Nullable NonNullBiConsumer<DataGenContext<Block, ? extends Block>, GTBlockstateProvider> blockModel) {
        this.blockModel = blockModel;
        return this;
    }

    @Generated
    public Map<Property<?>, @Nullable Comparable<?>> modelProperties() {
        return this.modelProperties;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> shape(VoxelShape shape) {
        this.shape = shape;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> rotationState(RotationState rotationState) {
        this.rotationState = rotationState;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> allowExtendedFacing(boolean allowExtendedFacing) {
        this.allowExtendedFacing = allowExtendedFacing;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> hasBER(boolean hasBER) {
        this.hasBER = hasBER;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> renderMultiblockWorldPreview(boolean renderMultiblockWorldPreview) {
        this.renderMultiblockWorldPreview = renderMultiblockWorldPreview;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> renderMultiblockXEIPreview(boolean renderMultiblockXEIPreview) {
        this.renderMultiblockXEIPreview = renderMultiblockXEIPreview;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> blockProp(NonNullUnaryOperator<BlockBehaviour.Properties> blockProp) {
        this.blockProp = blockProp;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> itemProp(NonNullUnaryOperator<Item.Properties> itemProp) {
        this.itemProp = itemProp;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> blockBuilder(@Nullable Consumer<BlockBuilder<? extends Block, ?>> blockBuilder) {
        this.blockBuilder = blockBuilder;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> itemBuilder(@Nullable Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder) {
        this.itemBuilder = itemBuilder;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> onBlockEntityRegister(NonNullConsumer<BlockEntityType<BlockEntity>> onBlockEntityRegister) {
        this.onBlockEntityRegister = onBlockEntityRegister;
        return this;
    }

    @NotNull
    @Generated
    public @NotNull GTRecipeType @NotNull [] recipeTypes() {
        return this.recipeTypes;
    }

    @Generated
    public int tier() {
        return this.tier;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> tier(int tier) {
        this.tier = tier;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> recipeOutputLimits(Object2IntMap<RecipeCapability<?>> recipeOutputLimits) {
        this.recipeOutputLimits = recipeOutputLimits;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> paintingColor(int paintingColor) {
        this.paintingColor = paintingColor;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> itemColor(BiFunction<ItemStack, Integer, Integer> itemColor) {
        this.itemColor = itemColor;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> tooltipBuilder(@Nullable BiConsumer<ItemStack, List<Component>> tooltipBuilder) {
        this.tooltipBuilder = tooltipBuilder;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> alwaysTryModifyRecipe(boolean alwaysTryModifyRecipe) {
        this.alwaysTryModifyRecipe = alwaysTryModifyRecipe;
        return this;
    }

    @NotNull
    @Generated
    public BiPredicate<IRecipeLogicMachine, GTRecipe> beforeWorking() {
        return this.beforeWorking;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> beforeWorking(@NotNull BiPredicate<IRecipeLogicMachine, GTRecipe> beforeWorking) {
        if (beforeWorking == null) {
            throw new NullPointerException("beforeWorking is marked non-null but is null");
        }
        this.beforeWorking = beforeWorking;
        return this;
    }

    @NotNull
    @Generated
    public Predicate<IRecipeLogicMachine> onWorking() {
        return this.onWorking;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> onWorking(@NotNull Predicate<IRecipeLogicMachine> onWorking) {
        if (onWorking == null) {
            throw new NullPointerException("onWorking is marked non-null but is null");
        }
        this.onWorking = onWorking;
        return this;
    }

    @NotNull
    @Generated
    public Consumer<IRecipeLogicMachine> onWaiting() {
        return this.onWaiting;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> onWaiting(@NotNull Consumer<IRecipeLogicMachine> onWaiting) {
        if (onWaiting == null) {
            throw new NullPointerException("onWaiting is marked non-null but is null");
        }
        this.onWaiting = onWaiting;
        return this;
    }

    @NotNull
    @Generated
    public Consumer<IRecipeLogicMachine> afterWorking() {
        return this.afterWorking;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> afterWorking(@NotNull Consumer<IRecipeLogicMachine> afterWorking) {
        if (afterWorking == null) {
            throw new NullPointerException("afterWorking is marked non-null but is null");
        }
        this.afterWorking = afterWorking;
        return this;
    }

    @Generated
    public boolean regressWhenWaiting() {
        return this.regressWhenWaiting;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> regressWhenWaiting(boolean regressWhenWaiting) {
        this.regressWhenWaiting = regressWhenWaiting;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> allowCoverOnFront(boolean allowCoverOnFront) {
        this.allowCoverOnFront = allowCoverOnFront;
        return this;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> appearance(Supplier<BlockState> appearance) {
        this.appearance = appearance;
        return this;
    }

    @Nullable
    @Generated
    public EditableMachineUI editableUI() {
        return this.editableUI;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> editableUI(@Nullable EditableMachineUI editableUI) {
        this.editableUI = editableUI;
        return this;
    }

    @Nullable
    @Generated
    public String langValue() {
        return this.langValue;
    }

    @NotNull
    @Generated
    public MachineBuilder<DEFINITION> langValue(@Nullable String langValue) {
        this.langValue = langValue;
        return this;
    }

    @FunctionalInterface
    public static interface ModelInitializer {
        public void configureModel(@NotNull DataGenContext<Block, ? extends Block> var1, @NotNull GTBlockstateProvider var2, @NotNull MachineModelBuilder<BlockModelBuilder> var3);

        default public ModelInitializer andThen(ModelInitializer after) {
            Objects.requireNonNull(after);
            return (ctx, prov, builder) -> {
                this.configureModel((DataGenContext<Block, ? extends Block>)ctx, prov, builder);
                after.configureModel((DataGenContext<Block, ? extends Block>)ctx, prov, builder);
            };
        }

        default public ModelInitializer andThen(Consumer<MachineModelBuilder<BlockModelBuilder>> after) {
            Objects.requireNonNull(after);
            return (ctx, prov, builder) -> {
                this.configureModel((DataGenContext<Block, ? extends Block>)ctx, prov, builder);
                after.accept(builder);
            };
        }

        default public ModelInitializer compose(ModelInitializer before) {
            Objects.requireNonNull(before);
            return (ctx, prov, builder) -> {
                before.configureModel((DataGenContext<Block, ? extends Block>)ctx, prov, builder);
                this.configureModel((DataGenContext<Block, ? extends Block>)ctx, prov, builder);
            };
        }

        default public ModelInitializer compose(UnaryOperator<MachineModelBuilder<BlockModelBuilder>> before) {
            Objects.requireNonNull(before);
            return (ctx, prov, builder) -> this.configureModel((DataGenContext<Block, ? extends Block>)ctx, prov, (MachineModelBuilder)((Object)((Object)before.apply(builder))));
        }
    }

    protected static final class KJSCallWrapper {
        protected KJSCallWrapper() {
        }

        public static <D extends MachineDefinition> void generateAssetJsons(@Nullable AssetJsonGenerator generator, MachineBuilder<D> builder, D definition) {
            if (builder.model() == null && builder.blockModel() == null) {
                return;
            }
            ResourceLocation id = definition.getId();
            if (generator == null) {
                DataGenContext context = new DataGenContext(definition::getBlock, definition.getName(), id);
                if (builder.blockModel() != null) {
                    builder.blockModel().accept((Object)context, (Object)GregTechKubeJSPlugin.RUNTIME_BLOCKSTATE_PROVIDER);
                } else {
                    GTMachineModels.createMachineModel(builder.model()).accept((Object)context, (Object)GregTechKubeJSPlugin.RUNTIME_BLOCKSTATE_PROVIDER);
                }
            } else {
                generator.itemModel(id, gen -> gen.parent(id.withPrefix("block/machine/").toString()));
            }
        }
    }

    protected static class BlockBuilderWrapper {
        protected BlockBuilderWrapper() {
        }

        public static <DEFINITION extends MachineDefinition> BlockBuilder<Block, ? extends AbstractRegistrate<?>> makeBlockBuilder(MachineBuilder<DEFINITION> builder, DEFINITION definition) {
            return (BlockBuilder)builder.registrate.block(properties -> BlockBuilderWrapper.makeBlock(builder, definition, properties)).color(() -> () -> IMachineBlock::colorTinted).initialProperties(() -> Blocks.DISPENSER).properties(BlockBehaviour.Properties::noLootTable).addLayer(() -> RenderType::cutout).exBlockstate(builder.blockModel != null ? builder.blockModel : GTMachineModels.createMachineModel(builder.model)).properties((NonNullUnaryOperator)builder.blockProp).onRegister(b -> Arrays.stream(builder.abilities).forEach(a -> a.register(builder.tier, (Block)b)));
        }

        private static <DEFINITION extends MachineDefinition> Block makeBlock(MachineBuilder<DEFINITION> builder, DEFINITION definition, BlockBehaviour.Properties properties) {
            MachineDefinition.setBuilt(definition);
            IMachineBlock b = builder.blockFactory.apply(properties, definition);
            MachineDefinition.clearBuilt();
            return b.self();
        }
    }

    protected static class ItemBuilderWrapper {
        protected ItemBuilderWrapper() {
        }

        public static <DEFINITION extends MachineDefinition> ItemBuilder<MetaMachineItem, ? extends AbstractRegistrate<?>> makeItemBuilder(MachineBuilder<DEFINITION> builder, BlockEntry<Block> block) {
            return ((ItemBuilder)builder.registrate.item(properties -> builder.itemFactory.apply((IMachineBlock)block.get(), (Item.Properties)properties)).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model((ctx, prov) -> prov.withExistingParent(ctx.getName(), new ResourceLocation(builder.registrate.getModid(), "block/machine/" + ctx.getName()))).color(() -> () -> builder.itemColor::apply).properties(builder.itemProp);
        }
    }
}

