/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate;

import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.capability.recipe.RecipeCapability;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.gui.editor.EditableMachineUI;
import com.gregtechceu.gtceu.api.item.MetaMachineItem;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MetaMachine;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.IRecipeLogicMachine;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiPart;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.machine.multiblock.PartAbility;
import com.gregtechceu.gtceu.api.machine.property.GTMachineModelProperties;
import com.gregtechceu.gtceu.api.pattern.BlockPattern;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.gregtechceu.gtceu.api.recipe.GTRecipe;
import com.gregtechceu.gtceu.api.recipe.GTRecipeType;
import com.gregtechceu.gtceu.api.recipe.modifier.RecipeModifier;
import com.gregtechceu.gtceu.api.registry.registrate.GTRegistrate;
import com.gregtechceu.gtceu.api.registry.registrate.MachineBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.provider.GTBlockstateProvider;
import com.gregtechceu.gtceu.utils.memoization.GTMemoizer;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.DataGenContext;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullUnaryOperator;
import dev.latvian.mods.rhino.util.HideFromJS;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.apache.commons.lang3.function.TriFunction;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class MultiblockMachineBuilder
extends MachineBuilder<MultiblockMachineDefinition> {
    private boolean generator;
    private Function<MultiblockMachineDefinition, BlockPattern> pattern;
    private final List<Function<MultiblockMachineDefinition, List<MultiblockShapeInfo>>> shapeInfos = new ArrayList<Function<MultiblockMachineDefinition, List<MultiblockShapeInfo>>>();
    private boolean allowFlip = true;
    private final List<Supplier<ItemStack[]>> recoveryItems = new ArrayList<Supplier<ItemStack[]>>();
    private Function<MultiblockControllerMachine, Comparator<IMultiPart>> partSorter = c -> (a, b) -> 0;
    private TriFunction<IMultiController, IMultiPart, Direction, BlockState> partAppearance;
    private BiConsumer<IMultiController, List<Component>> additionalDisplay = (m, l) -> {};

    public MultiblockMachineBuilder(GTRegistrate registrate, String name, Function<IMachineBlockEntity, ? extends MultiblockControllerMachine> metaMachine, BiFunction<BlockBehaviour.Properties, MultiblockMachineDefinition, IMachineBlock> blockFactory, BiFunction<IMachineBlock, Item.Properties, MetaMachineItem> itemFactory, TriFunction<BlockEntityType<?>, BlockPos, BlockState, IMachineBlockEntity> blockEntityFactory) {
        super(registrate, name, MultiblockMachineDefinition::new, metaMachine::apply, blockFactory, itemFactory, blockEntityFactory);
        this.allowExtendedFacing(true);
        this.allowCoverOnFront(true);
        this.modelProperty((Property)GTMachineModelProperties.IS_FORMED, Boolean.valueOf(false));
    }

    public MultiblockMachineBuilder shapeInfo(Function<MultiblockMachineDefinition, MultiblockShapeInfo> shape) {
        this.shapeInfos.add(d -> List.of((MultiblockShapeInfo)shape.apply((MultiblockMachineDefinition)d)));
        return this;
    }

    public MultiblockMachineBuilder shapeInfos(Function<MultiblockMachineDefinition, List<MultiblockShapeInfo>> shapes) {
        this.shapeInfos.add(shapes);
        return this;
    }

    public MultiblockMachineBuilder recoveryItems(Supplier<ItemLike[]> items) {
        this.recoveryItems.add(() -> (ItemStack[])Arrays.stream((ItemLike[])items.get()).map(ItemLike::asItem).map(Item::getDefaultInstance).toArray(ItemStack[]::new));
        return this;
    }

    public MultiblockMachineBuilder recoveryStacks(Supplier<ItemStack[]> stacks) {
        this.recoveryItems.add(stacks);
        return this;
    }

    public MultiblockMachineBuilder machine(Function<IMachineBlockEntity, MetaMachine> metaMachine) {
        return (MultiblockMachineBuilder)super.machine(metaMachine);
    }

    public MultiblockMachineBuilder model(@Nullable MachineBuilder.ModelInitializer model) {
        return (MultiblockMachineBuilder)super.model(model);
    }

    public MultiblockMachineBuilder blockModel(@Nullable NonNullBiConsumer<DataGenContext<Block, ? extends Block>, GTBlockstateProvider> blockModel) {
        return (MultiblockMachineBuilder)super.blockModel(blockModel);
    }

    public MultiblockMachineBuilder shape(VoxelShape shape) {
        return (MultiblockMachineBuilder)super.shape(shape);
    }

    public MultiblockMachineBuilder multiblockPreviewRenderer(boolean multiBlockWorldPreview, boolean multiBlockXEIPreview) {
        return (MultiblockMachineBuilder)super.multiblockPreviewRenderer(multiBlockWorldPreview, multiBlockXEIPreview);
    }

    public MultiblockMachineBuilder rotationState(RotationState rotationState) {
        return (MultiblockMachineBuilder)super.rotationState(rotationState);
    }

    public MultiblockMachineBuilder hasBER(boolean hasBER) {
        return (MultiblockMachineBuilder)super.hasBER(hasBER);
    }

    public MultiblockMachineBuilder blockProp(NonNullUnaryOperator<BlockBehaviour.Properties> blockProp) {
        return (MultiblockMachineBuilder)super.blockProp(blockProp);
    }

    public MultiblockMachineBuilder itemProp(NonNullUnaryOperator<Item.Properties> itemProp) {
        return (MultiblockMachineBuilder)super.itemProp(itemProp);
    }

    public MultiblockMachineBuilder blockBuilder(Consumer<BlockBuilder<? extends Block, ?>> blockBuilder) {
        return (MultiblockMachineBuilder)super.blockBuilder(blockBuilder);
    }

    public MultiblockMachineBuilder itemBuilder(Consumer<ItemBuilder<? extends MetaMachineItem, ?>> itemBuilder) {
        return (MultiblockMachineBuilder)super.itemBuilder(itemBuilder);
    }

    public MultiblockMachineBuilder recipeTypes(GTRecipeType ... recipeTypes) {
        return (MultiblockMachineBuilder)super.recipeTypes(recipeTypes);
    }

    public MultiblockMachineBuilder recipeType(GTRecipeType recipeTypes) {
        return (MultiblockMachineBuilder)super.recipeType(recipeTypes);
    }

    public MultiblockMachineBuilder tier(int tier) {
        return (MultiblockMachineBuilder)super.tier(tier);
    }

    public MultiblockMachineBuilder recipeOutputLimits(Object2IntMap<RecipeCapability<?>> map) {
        return (MultiblockMachineBuilder)super.recipeOutputLimits(map);
    }

    public MultiblockMachineBuilder addOutputLimit(RecipeCapability<?> capability, int limit) {
        return (MultiblockMachineBuilder)super.addOutputLimit(capability, limit);
    }

    public MultiblockMachineBuilder itemColor(BiFunction<ItemStack, Integer, Integer> itemColor) {
        return (MultiblockMachineBuilder)super.itemColor(itemColor);
    }

    public MultiblockMachineBuilder simpleModel(ResourceLocation model) {
        return (MultiblockMachineBuilder)super.simpleModel(model);
    }

    public MultiblockMachineBuilder defaultModel() {
        return (MultiblockMachineBuilder)super.defaultModel();
    }

    public MultiblockMachineBuilder tieredHullModel(ResourceLocation model) {
        return (MultiblockMachineBuilder)super.tieredHullModel(model);
    }

    public MultiblockMachineBuilder overlayTieredHullModel(String name) {
        return (MultiblockMachineBuilder)super.overlayTieredHullModel(name);
    }

    public MultiblockMachineBuilder overlayTieredHullModel(ResourceLocation overlayModel) {
        return (MultiblockMachineBuilder)super.overlayTieredHullModel(overlayModel);
    }

    public MultiblockMachineBuilder colorOverlayTieredHullModel(String overlay) {
        return (MultiblockMachineBuilder)super.colorOverlayTieredHullModel(overlay);
    }

    public MultiblockMachineBuilder colorOverlayTieredHullModel(String overlay, @Nullable String pipeOverlay, @Nullable String emissiveOverlay) {
        return (MultiblockMachineBuilder)super.colorOverlayTieredHullModel(overlay, pipeOverlay, emissiveOverlay);
    }

    public MultiblockMachineBuilder colorOverlayTieredHullModel(ResourceLocation overlay) {
        return (MultiblockMachineBuilder)super.colorOverlayTieredHullModel(overlay);
    }

    public MultiblockMachineBuilder colorOverlayTieredHullModel(ResourceLocation overlay, @Nullable ResourceLocation pipeOverlay, @Nullable ResourceLocation emissiveOverlay) {
        return (MultiblockMachineBuilder)super.colorOverlayTieredHullModel(overlay, pipeOverlay, emissiveOverlay);
    }

    public MultiblockMachineBuilder workableTieredHullModel(ResourceLocation workableModel) {
        return (MultiblockMachineBuilder)super.workableTieredHullModel(workableModel);
    }

    public MultiblockMachineBuilder simpleGeneratorModel(ResourceLocation workableModel) {
        return (MultiblockMachineBuilder)super.simpleGeneratorModel(workableModel);
    }

    public MultiblockMachineBuilder workableCasingModel(ResourceLocation baseCasing, ResourceLocation overlayModel) {
        return (MultiblockMachineBuilder)super.workableCasingModel(baseCasing, overlayModel);
    }

    public MultiblockMachineBuilder sidedOverlayCasingModel(ResourceLocation baseCasing, ResourceLocation workableModel) {
        return (MultiblockMachineBuilder)super.sidedOverlayCasingModel(baseCasing, workableModel);
    }

    public MultiblockMachineBuilder sidedWorkableCasingModel(ResourceLocation baseCasing, ResourceLocation workableModel) {
        return (MultiblockMachineBuilder)super.sidedWorkableCasingModel(baseCasing, workableModel);
    }

    public MultiblockMachineBuilder tooltipBuilder(@Nullable BiConsumer<ItemStack, List<Component>> tooltipBuilder) {
        return (MultiblockMachineBuilder)super.tooltipBuilder(tooltipBuilder);
    }

    public MultiblockMachineBuilder appearance(Supplier<BlockState> state) {
        return (MultiblockMachineBuilder)super.appearance(state);
    }

    public MultiblockMachineBuilder appearanceBlock(Supplier<? extends Block> block) {
        return (MultiblockMachineBuilder)super.appearanceBlock(block);
    }

    public MultiblockMachineBuilder langValue(@Nullable String langValue) {
        return (MultiblockMachineBuilder)super.langValue(langValue);
    }

    public MultiblockMachineBuilder overlaySteamHullModel(String name) {
        return (MultiblockMachineBuilder)super.overlaySteamHullModel(name);
    }

    public MultiblockMachineBuilder overlaySteamHullModel(ResourceLocation overlayModel) {
        return (MultiblockMachineBuilder)super.overlaySteamHullModel(overlayModel);
    }

    public MultiblockMachineBuilder colorOverlaySteamHullModel(String overlay) {
        return (MultiblockMachineBuilder)super.colorOverlaySteamHullModel(overlay);
    }

    public MultiblockMachineBuilder colorOverlaySteamHullModel(String overlay, @Nullable ResourceLocation pipeOverlay, @Nullable String emissiveOverlay) {
        return (MultiblockMachineBuilder)super.colorOverlaySteamHullModel(overlay, pipeOverlay, emissiveOverlay);
    }

    public MultiblockMachineBuilder colorOverlaySteamHullModel(ResourceLocation overlay, @Nullable ResourceLocation pipeOverlay, @Nullable ResourceLocation emissiveOverlay) {
        return (MultiblockMachineBuilder)super.colorOverlaySteamHullModel(overlay, pipeOverlay, emissiveOverlay);
    }

    public MultiblockMachineBuilder colorOverlaySteamHullModel(ResourceLocation overlay) {
        return (MultiblockMachineBuilder)super.colorOverlaySteamHullModel(overlay);
    }

    public MultiblockMachineBuilder workableSteamHullModel(boolean isHighPressure, ResourceLocation workableModel) {
        return (MultiblockMachineBuilder)super.workableSteamHullModel(isHighPressure, workableModel);
    }

    public MultiblockMachineBuilder tooltips(Component ... components) {
        return (MultiblockMachineBuilder)super.tooltips(components);
    }

    public MultiblockMachineBuilder tooltips(List<? extends @Nullable Component> components) {
        return (MultiblockMachineBuilder)super.tooltips(components);
    }

    public MultiblockMachineBuilder conditionalTooltip(Component component, BooleanSupplier condition) {
        return (MultiblockMachineBuilder)super.conditionalTooltip(component, condition);
    }

    public MultiblockMachineBuilder conditionalTooltip(Component component, boolean condition) {
        return (MultiblockMachineBuilder)super.conditionalTooltip(component, condition);
    }

    public MultiblockMachineBuilder partSorter(Comparator<IMultiPart> sorter) {
        this.partSorter = $ -> sorter;
        return this;
    }

    public MultiblockMachineBuilder abilities(PartAbility ... abilities) {
        return (MultiblockMachineBuilder)super.abilities(abilities);
    }

    public MultiblockMachineBuilder modelProperty(Property<?> property) {
        return (MultiblockMachineBuilder)super.modelProperty(property);
    }

    public <T extends Comparable<T>> MultiblockMachineBuilder modelProperty(Property<T> property, @Nullable T defaultValue) {
        return (MultiblockMachineBuilder)super.modelProperty(property, defaultValue);
    }

    public MultiblockMachineBuilder modelProperties(Property<?> ... properties) {
        return (MultiblockMachineBuilder)super.modelProperties(properties);
    }

    public MultiblockMachineBuilder modelProperties(Collection<Property<?>> properties) {
        return (MultiblockMachineBuilder)super.modelProperties(properties);
    }

    public MultiblockMachineBuilder modelProperties(Map<Property<?>, ? extends Comparable<?>> properties) {
        return (MultiblockMachineBuilder)super.modelProperties(properties);
    }

    public MultiblockMachineBuilder removeModelProperty(Property<?> property) {
        return (MultiblockMachineBuilder)super.removeModelProperty(property);
    }

    public MultiblockMachineBuilder clearModelProperties() {
        return (MultiblockMachineBuilder)super.clearModelProperties();
    }

    public MultiblockMachineBuilder paintingColor(int paintingColor) {
        return (MultiblockMachineBuilder)super.paintingColor(paintingColor);
    }

    public MultiblockMachineBuilder recipeModifier(RecipeModifier recipeModifier) {
        return (MultiblockMachineBuilder)super.recipeModifier(recipeModifier);
    }

    public MultiblockMachineBuilder recipeModifier(RecipeModifier recipeModifier, boolean alwaysTryModifyRecipe) {
        return (MultiblockMachineBuilder)super.recipeModifier(recipeModifier, alwaysTryModifyRecipe);
    }

    public MultiblockMachineBuilder recipeModifiers(RecipeModifier ... recipeModifiers) {
        return (MultiblockMachineBuilder)super.recipeModifiers(recipeModifiers);
    }

    public MultiblockMachineBuilder recipeModifiers(boolean alwaysTryModifyRecipe, RecipeModifier ... recipeModifiers) {
        return (MultiblockMachineBuilder)super.recipeModifiers(alwaysTryModifyRecipe, recipeModifiers);
    }

    public MultiblockMachineBuilder noRecipeModifier() {
        return (MultiblockMachineBuilder)super.noRecipeModifier();
    }

    public MultiblockMachineBuilder alwaysTryModifyRecipe(boolean alwaysTryModifyRecipe) {
        return (MultiblockMachineBuilder)super.alwaysTryModifyRecipe(alwaysTryModifyRecipe);
    }

    public MultiblockMachineBuilder beforeWorking(BiPredicate<IRecipeLogicMachine, GTRecipe> beforeWorking) {
        return (MultiblockMachineBuilder)super.beforeWorking(beforeWorking);
    }

    public MultiblockMachineBuilder onWorking(Predicate<IRecipeLogicMachine> onWorking) {
        return (MultiblockMachineBuilder)super.onWorking(onWorking);
    }

    public MultiblockMachineBuilder onWaiting(Consumer<IRecipeLogicMachine> onWaiting) {
        return (MultiblockMachineBuilder)super.onWaiting(onWaiting);
    }

    public MultiblockMachineBuilder afterWorking(Consumer<IRecipeLogicMachine> afterWorking) {
        return (MultiblockMachineBuilder)super.afterWorking(afterWorking);
    }

    public MultiblockMachineBuilder regressWhenWaiting(boolean regressWhenWaiting) {
        return (MultiblockMachineBuilder)super.regressWhenWaiting(regressWhenWaiting);
    }

    public MultiblockMachineBuilder editableUI(@Nullable EditableMachineUI editableUI) {
        return (MultiblockMachineBuilder)super.editableUI(editableUI);
    }

    public MultiblockMachineBuilder onBlockEntityRegister(NonNullConsumer<BlockEntityType<BlockEntity>> onBlockEntityRegister) {
        return (MultiblockMachineBuilder)super.onBlockEntityRegister(onBlockEntityRegister);
    }

    public MultiblockMachineBuilder allowExtendedFacing(boolean allowExtendedFacing) {
        return (MultiblockMachineBuilder)super.allowExtendedFacing(allowExtendedFacing);
    }

    public MultiblockMachineBuilder allowCoverOnFront(boolean allowCoverOnFront) {
        return (MultiblockMachineBuilder)super.allowCoverOnFront(allowCoverOnFront);
    }

    @Override
    @HideFromJS
    public MultiblockMachineDefinition register() {
        MultiblockMachineDefinition definition = (MultiblockMachineDefinition)super.register();
        definition.setGenerator(this.generator);
        if (this.pattern == null) {
            throw new IllegalStateException("missing pattern while creating multiblock " + this.name);
        }
        definition.setPatternFactory(GTMemoizer.memoize(() -> this.pattern.apply(definition)));
        definition.setShapes(() -> this.shapeInfos.stream().map(factory -> (List)factory.apply(definition)).flatMap(Collection::stream).toList());
        definition.setAllowFlip(this.allowFlip);
        if (!this.recoveryItems.isEmpty()) {
            definition.setRecoveryItems(() -> (ItemStack[])this.recoveryItems.stream().map(Supplier::get).flatMap(Arrays::stream).toArray(ItemStack[]::new));
        }
        definition.setPartSorter(GTMemoizer.memoizeFunctionWeakIdent(this.partSorter));
        if (this.partAppearance == null) {
            this.partAppearance = (controller, part, side) -> definition.getAppearance().get();
        }
        definition.setPartAppearance(this.partAppearance);
        definition.setAdditionalDisplay(this.additionalDisplay);
        this.value = definition;
        return this.value;
    }

    @NotNull
    @Generated
    public MultiblockMachineBuilder generator(boolean generator) {
        this.generator = generator;
        return this;
    }

    @NotNull
    @Generated
    public MultiblockMachineBuilder pattern(Function<MultiblockMachineDefinition, BlockPattern> pattern) {
        this.pattern = pattern;
        return this;
    }

    @NotNull
    @Generated
    public MultiblockMachineBuilder allowFlip(boolean allowFlip) {
        this.allowFlip = allowFlip;
        return this;
    }

    @NotNull
    @Generated
    public MultiblockMachineBuilder partSorter(Function<MultiblockControllerMachine, Comparator<IMultiPart>> partSorter) {
        this.partSorter = partSorter;
        return this;
    }

    @NotNull
    @Generated
    public MultiblockMachineBuilder partAppearance(TriFunction<IMultiController, IMultiPart, Direction, BlockState> partAppearance) {
        this.partAppearance = partAppearance;
        return this;
    }

    @Generated
    public BiConsumer<IMultiController, List<Component>> additionalDisplay() {
        return this.additionalDisplay;
    }

    @NotNull
    @Generated
    public MultiblockMachineBuilder additionalDisplay(BiConsumer<IMultiController, List<Component>> additionalDisplay) {
        this.additionalDisplay = additionalDisplay;
        return this;
    }
}

