/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.registry.registrate.forge;

import com.google.common.base.Preconditions;
import com.gregtechceu.gtceu.api.data.chemical.material.Material;
import com.gregtechceu.gtceu.api.fluids.FluidState;
import com.gregtechceu.gtceu.api.fluids.GTFluid;
import com.gregtechceu.gtceu.api.fluids.forge.GTFluidImpl;
import com.gregtechceu.gtceu.api.item.GTBucketItem;
import com.gregtechceu.gtceu.api.registry.registrate.IGTFluidBuilder;
import com.gregtechceu.gtceu.api.registry.registrate.forge.GTClientFluidTypeExtensions;
import com.gregtechceu.gtceu.utils.GTUtil;
import com.tterrag.registrate.AbstractRegistrate;
import com.tterrag.registrate.builders.AbstractBuilder;
import com.tterrag.registrate.builders.BlockBuilder;
import com.tterrag.registrate.builders.Builder;
import com.tterrag.registrate.builders.BuilderCallback;
import com.tterrag.registrate.builders.ItemBuilder;
import com.tterrag.registrate.providers.ProviderType;
import com.tterrag.registrate.providers.RegistrateTagsProvider;
import com.tterrag.registrate.util.OneTimeEventReceiver;
import com.tterrag.registrate.util.entry.RegistryEntry;
import com.tterrag.registrate.util.nullness.NonNullBiConsumer;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import com.tterrag.registrate.util.nullness.NonNullConsumer;
import com.tterrag.registrate.util.nullness.NonNullSupplier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.BucketItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.SoundActions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class GTFluidBuilder<P>
extends AbstractBuilder<Fluid, GTFluidImpl.Flowing, P, GTFluidBuilder<P>>
implements IGTFluidBuilder {
    public int temperature = 300;
    public int density = 1000;
    public int luminance = 0;
    public int viscosity = 1000;
    public int color = -1;
    public int burnTime = -1;
    public FluidState state;
    private final String sourceName;
    private final String bucketName;
    private final Material material;
    private final String langKey;
    private final ResourceLocation stillTexture;
    private final ResourceLocation flowingTexture;
    @Nullable
    private final NonNullSupplier<FluidType> fluidType;
    @Nullable
    private Boolean defaultSource;
    @Nullable
    private Boolean defaultBlock;
    @Nullable
    private Boolean defaultBucket;
    private NonNullConsumer<FluidType.Properties> typeProperties = $ -> {};
    @Nullable
    private Supplier<RenderType> layer = null;
    private boolean registerType;
    @Nullable
    private NonNullSupplier<? extends GTFluid> source;
    @Nullable
    private NonNullSupplier<? extends LiquidBlock> block;
    @Nullable
    private NonNullSupplier<? extends BucketItem> bucket;
    private final List<TagKey<Fluid>> tags = new ArrayList<TagKey<Fluid>>();

    public GTFluidBuilder(AbstractRegistrate<?> owner, P parent, Material material, String name, String langKey, BuilderCallback callback, ResourceLocation stillTexture, ResourceLocation flowingTexture, FluidTypeFactory typeFactory) {
        super(owner, parent, "flowing_" + name, callback, ForgeRegistries.Keys.FLUIDS);
        this.sourceName = name;
        this.bucketName = name + "_bucket";
        this.material = material;
        this.langKey = langKey;
        this.stillTexture = stillTexture;
        this.flowingTexture = flowingTexture;
        this.fluidType = NonNullSupplier.lazy(() -> typeFactory.create(langKey, material, this.makeTypeProperties(), this.stillTexture, this.flowingTexture, this.color));
        this.registerType = true;
        this.defaultBucket();
    }

    public GTFluidBuilder<P> defaultLang() {
        return (GTFluidBuilder)this.lang(f -> f.getFluidType().getDescriptionId(), this.langKey);
    }

    public GTFluidBuilder<P> lang(String name) {
        return (GTFluidBuilder)this.lang(f -> f.getFluidType().getDescriptionId(), name);
    }

    public GTFluidBuilder<P> renderType(Supplier<RenderType> layer) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> GTFluidBuilder.lambda$renderType$4((Supplier)layer));
        if (this.layer == null) {
            this.onRegister(this::registerRenderType);
        }
        this.layer = layer;
        return this;
    }

    protected void registerRenderType(GTFluidImpl.Flowing entry) {
        DistExecutor.runWhenOn((Dist)Dist.CLIENT, () -> () -> OneTimeEventReceiver.addModListener((AbstractRegistrate)this.getOwner(), FMLClientSetupEvent.class, $ -> {
            if (this.layer != null) {
                RenderType layer = this.layer.get();
                ItemBlockRenderTypes.setRenderLayer((Fluid)entry, (RenderType)layer);
                ItemBlockRenderTypes.setRenderLayer((Fluid)this.getSource(), (RenderType)layer);
            }
        }));
    }

    public GTFluidBuilder<P> defaultSource() {
        if (this.defaultSource != null) {
            throw new IllegalStateException("Cannot set a default source after a custom source has been created");
        }
        this.defaultSource = true;
        return this;
    }

    public GTFluidBuilder<P> source(NonNullSupplier<? extends GTFluid> factory) {
        this.defaultSource = false;
        this.source = NonNullSupplier.lazy(() -> factory.get());
        return this;
    }

    public GTFluidBuilder<P> defaultBlock() {
        if (this.defaultBlock != null) {
            throw new IllegalStateException("Cannot set a default block after a custom block has been created");
        }
        this.defaultBlock = true;
        return this;
    }

    public BlockBuilder<LiquidBlock, GTFluidBuilder<P>> block() {
        return this.block(LiquidBlock::new);
    }

    public <B extends LiquidBlock> BlockBuilder<B, GTFluidBuilder<P>> block(NonNullBiFunction<NonNullSupplier<GTFluidImpl.Flowing>, BlockBehaviour.Properties, ? extends B> factory) {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        NonNullSupplier supplier = this.asSupplier();
        return (BlockBuilder)((BlockBuilder)this.getOwner().block((Object)this, this.sourceName, p -> (LiquidBlock)factory.apply((Object)supplier, p)).properties(p -> BlockBehaviour.Properties.copy((BlockBehaviour)Blocks.WATER).noLootTable()).properties(p -> p.lightLevel(blockState -> ((FluidType)this.fluidType.get()).getLightLevel())).properties(p -> p.mapColor(GTUtil.determineMapColor(this.material.getMaterialRGB()))).setData(ProviderType.LANG, NonNullBiConsumer.noop())).blockstate((ctx, prov) -> prov.simpleBlock((Block)ctx.getEntry(), (ModelFile)((BlockModelBuilder)prov.models().getBuilder(this.sourceName)).texture("particle", this.stillTexture))).onRegister(block -> {
            this.block = () -> block;
        });
    }

    public GTFluidBuilder<P> noBlock() {
        if (this.defaultBlock == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to block/noBlock per builder allowed");
        }
        this.defaultBlock = false;
        return this;
    }

    public GTFluidBuilder<P> noBucket() {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        this.defaultBucket = false;
        return this;
    }

    public GTFluidBuilder<P> defaultBucket() {
        if (this.defaultBucket != null) {
            throw new IllegalStateException("Cannot set a default bucket after a custom bucket has been created");
        }
        this.defaultBucket = true;
        return this;
    }

    public ItemBuilder<GTBucketItem, GTFluidBuilder<P>> bucket() {
        if (this.defaultBucket == Boolean.FALSE) {
            throw new IllegalStateException("Only one call to bucket/noBucket per builder allowed");
        }
        return (ItemBuilder)((ItemBuilder)this.getOwner().item((Object)this, this.bucketName, p -> new GTBucketItem((Supplier<? extends Fluid>)this.source, (Item.Properties)p, this.material, this.langKey)).properties(p -> p.craftRemainder(Items.BUCKET).stacksTo(1)).color(() -> () -> GTBucketItem::color).setData(ProviderType.LANG, NonNullBiConsumer.noop())).model(NonNullBiConsumer.noop()).onRegister(bucket -> {
            this.bucket = () -> bucket;
        });
    }

    @SafeVarargs
    public final GTFluidBuilder<P> tag(TagKey<Fluid> ... tags) {
        GTFluidBuilder ret = (GTFluidBuilder)this.tag(ProviderType.FLUID_TAGS, tags);
        if (this.tags.isEmpty()) {
            ret.getOwner().setDataGenerator(ret.sourceName, this.getRegistryKey(), ProviderType.FLUID_TAGS, prov -> this.tags.stream().map(arg_0 -> ((RegistrateTagsProvider)prov).addTag(arg_0)).forEach(p -> p.add(this.getSource().builtInRegistryHolder().key())));
        }
        this.tags.addAll(Arrays.asList(tags));
        return ret;
    }

    private GTFluid getSource() {
        NonNullSupplier<? extends GTFluid> source = this.source;
        Preconditions.checkNotNull(source, (Object)("Fluid has no source block: " + this.sourceName));
        return (GTFluid)source.get();
    }

    private FluidType.Properties makeTypeProperties() {
        FluidType.Properties properties = FluidType.Properties.create();
        RegistryEntry block = this.getOwner().getOptional(this.sourceName, ForgeRegistries.Keys.BLOCKS);
        this.typeProperties.accept((Object)properties);
        if (block.isPresent()) {
            properties.descriptionId(((Block)block.get()).getDescriptionId());
        } else {
            properties.descriptionId(this.langKey);
        }
        this.setData(ProviderType.LANG, NonNullBiConsumer.noop());
        return properties.sound(SoundActions.BUCKET_FILL, SoundEvents.BUCKET_FILL).sound(SoundActions.BUCKET_EMPTY, SoundEvents.BUCKET_EMPTY).temperature(this.temperature).density(this.density).viscosity(this.viscosity).lightLevel(this.luminance);
    }

    protected GTFluidImpl.Flowing createEntry() {
        return new GTFluidImpl.Flowing(this.state, (Supplier<? extends Fluid>)((Supplier<Fluid>)() -> (Fluid)this.source.get()), (Supplier<? extends Fluid>)((Supplier<Fluid>)() -> (Fluid)this.get().get()), (Supplier<? extends LiquidBlock>)((Supplier<LiquidBlock>)() -> this.block != null ? (LiquidBlock)this.block.get() : null), (Supplier<? extends Item>)((Supplier<Item>)() -> this.bucket != null ? (Item)this.bucket.get() : null), this.burnTime, (Supplier<FluidType>)this.fluidType);
    }

    @Override
    public GTFluidBuilder<P> hasBlock(boolean hasBlock) {
        if (hasBlock && this.defaultBlock == null) {
            this.defaultBlock();
        }
        if (!hasBlock && this.defaultBlock != null) {
            this.noBlock();
        }
        return this;
    }

    @Override
    public IGTFluidBuilder hasBucket(boolean hasBucket) {
        if (hasBucket && this.defaultBucket == null) {
            this.defaultBucket();
        }
        if (!hasBucket && this.defaultBucket != null) {
            this.noBucket();
        }
        return this;
    }

    @Override
    public IGTFluidBuilder onFluidRegister(Consumer<Fluid> fluidConsumer) {
        return (IGTFluidBuilder)this.onRegister(fluidConsumer::accept);
    }

    public RegistryEntry<GTFluidImpl.Flowing> register() {
        NonNullSupplier<? extends GTFluid> source;
        if (this.fluidType != null) {
            if (this.registerType) {
                this.getOwner().simple((Object)this, this.sourceName, ForgeRegistries.Keys.FLUID_TYPES, this.fluidType);
            }
        } else {
            throw new IllegalStateException("Fluid must have a type: " + this.getName());
        }
        if (this.defaultSource == Boolean.TRUE) {
            this.source((NonNullSupplier<GTFluid>)((NonNullSupplier)() -> new GTFluidImpl.Source(this.state, (Supplier<? extends Fluid>)((Supplier<Fluid>)() -> (Fluid)this.source.get()), (Supplier<? extends Fluid>)((Supplier<Fluid>)() -> (Fluid)this.get().get()), (Supplier<? extends LiquidBlock>)((Supplier<LiquidBlock>)() -> this.block != null ? (LiquidBlock)this.block.get() : null), (Supplier<? extends Item>)((Supplier<Item>)() -> this.bucket != null ? (Item)this.bucket.get() : null), this.burnTime, (Supplier<FluidType>)this.fluidType)));
        }
        if (this.defaultBlock == Boolean.TRUE) {
            this.block().register();
        }
        if (this.defaultBucket == Boolean.TRUE) {
            this.bucket().register();
        }
        if ((source = this.source) == null) {
            throw new IllegalStateException("Fluid must have a source version: " + this.getName());
        }
        this.getCallback().accept(this.sourceName, ForgeRegistries.Keys.FLUIDS, (Builder)this, () -> source.get());
        return super.register();
    }

    @Override
    public Supplier<? extends Fluid> registerFluid() {
        this.register();
        return this.source;
    }

    public static FluidType defaultFluidType(final String langKey, final Material material, FluidType.Properties properties, final ResourceLocation stillTexture, final ResourceLocation flowingTexture, final int color) {
        return new FluidType(properties){

            public void initializeClient(Consumer<IClientFluidTypeExtensions> consumer) {
                consumer.accept(new GTClientFluidTypeExtensions(stillTexture, flowingTexture, color));
            }

            public String getDescriptionId() {
                return material.getUnlocalizedName();
            }

            public Component getDescription() {
                return Component.translatable((String)langKey, (Object[])new Object[]{material.getLocalizedName()});
            }

            public Component getDescription(FluidStack stack) {
                return this.getDescription();
            }
        };
    }

    @Override
    @NotNull
    @Generated
    public GTFluidBuilder<P> temperature(int temperature) {
        this.temperature = temperature;
        return this;
    }

    @Override
    @NotNull
    @Generated
    public GTFluidBuilder<P> density(int density) {
        this.density = density;
        return this;
    }

    @Override
    @NotNull
    @Generated
    public GTFluidBuilder<P> luminance(int luminance) {
        this.luminance = luminance;
        return this;
    }

    @Override
    @NotNull
    @Generated
    public GTFluidBuilder<P> viscosity(int viscosity) {
        this.viscosity = viscosity;
        return this;
    }

    @Override
    @NotNull
    @Generated
    public GTFluidBuilder<P> color(int color) {
        this.color = color;
        return this;
    }

    @Override
    @NotNull
    @Generated
    public GTFluidBuilder<P> burnTime(int burnTime) {
        this.burnTime = burnTime;
        return this;
    }

    @Override
    @NotNull
    @Generated
    public GTFluidBuilder<P> state(FluidState state) {
        this.state = state;
        return this;
    }

    private static /* synthetic */ void lambda$renderType$4(Supplier layer) {
        Preconditions.checkArgument((boolean)RenderType.chunkBufferLayers().contains(layer.get()), (Object)("Invalid render type: " + String.valueOf(layer)));
    }

    @FunctionalInterface
    public static interface FluidTypeFactory {
        public FluidType create(String var1, Material var2, FluidType.Properties var3, ResourceLocation var4, ResourceLocation var5, int var6);
    }
}

