/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.api.sound;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.gregtechceu.gtceu.api.sound.ConfiguredSoundEvent;
import com.gregtechceu.gtceu.api.sound.SoundEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class WrappedSoundEntry
extends SoundEntry {
    private final List<ConfiguredSoundEvent> wrappedEvents;
    private final List<CompiledSoundEvent> compiledEvents;

    public WrappedSoundEntry(ResourceLocation id, String subtitle, List<ConfiguredSoundEvent> wrappedEvents, SoundSource category, int attenuationDistance) {
        super(id, subtitle, category, attenuationDistance);
        this.wrappedEvents = wrappedEvents;
        this.compiledEvents = new ArrayList<CompiledSoundEvent>();
    }

    @Override
    public void prepare() {
        for (int i = 0; i < this.wrappedEvents.size(); ++i) {
            ConfiguredSoundEvent wrapped = this.wrappedEvents.get(i);
            ResourceLocation location = this.getIdOf(i);
            this.compiledEvents.add(new CompiledSoundEvent(SoundEvent.createVariableRangeEvent((ResourceLocation)location), wrapped.volume(), wrapped.pitch()));
        }
    }

    @Override
    public void register(Consumer<SoundEvent> registry) {
        for (CompiledSoundEvent compiledEvent : this.compiledEvents) {
            registry.accept(compiledEvent.event());
        }
    }

    @Override
    public SoundEvent getMainEvent() {
        return this.compiledEvents.get(0).event();
    }

    protected ResourceLocation getIdOf(int i) {
        return new ResourceLocation(this.id.getNamespace(), (String)(i == 0 ? this.id.getPath() : this.id.getPath() + "_compounded_" + i));
    }

    @Override
    public void write(JsonObject json) {
        for (int i = 0; i < this.wrappedEvents.size(); ++i) {
            ConfiguredSoundEvent event = this.wrappedEvents.get(i);
            JsonObject entry = new JsonObject();
            JsonArray list = new JsonArray();
            JsonObject s = new JsonObject();
            s.addProperty("name", event.event().get().getLocation().toString());
            s.addProperty("type", "event");
            if (this.attenuationDistance != 0) {
                s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
            }
            list.add((JsonElement)s);
            entry.add("sounds", (JsonElement)list);
            if (i == 0 && this.hasSubtitle()) {
                entry.addProperty("subtitle", this.getSubtitleKey());
            }
            json.add(this.getIdOf(i).getPath(), (JsonElement)entry);
        }
    }

    @Override
    public void play(Level world, Player entity, double x, double y, double z, float volume, float pitch) {
        for (CompiledSoundEvent event : this.compiledEvents) {
            world.playSound(entity, x, y, z, event.event(), this.category, event.volume() * volume, event.pitch() * pitch);
        }
    }

    @Override
    public void playAt(Level world, double x, double y, double z, float volume, float pitch, boolean fade) {
        for (CompiledSoundEvent event : this.compiledEvents) {
            world.playLocalSound(x, y, z, event.event(), this.category, event.volume() * volume, event.pitch() * pitch, fade);
        }
    }

    private record CompiledSoundEvent(SoundEvent event, float volume, float pitch) {
    }
}

