/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client;

import com.gregtechceu.gtceu.common.capability.EnvironmentalHazardSavedData;
import com.gregtechceu.gtceu.common.particle.HazardParticleOptions;
import com.gregtechceu.gtceu.config.ConfigHolder;
import com.gregtechceu.gtceu.core.mixins.client.ClientLevelAccessor;
import it.unimi.dsi.fastutil.floats.FloatIntPair;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import lombok.Generated;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.FastColor;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.MinecraftForge;

@OnlyIn(value=Dist.CLIENT)
public class EnvironmentalHazardClientHandler {
    public static final int PARTICLE_THRESHOLD = 200;
    public static final int MAX_PARTICLE_DISTANCE = 96;
    public static final int MAX_PARTICLE_DISTANCE_SQR = 9216;
    public static final float COLORING_LOW = 200.0f;
    public static final float COLORING_HIGH = 600.0f;
    public static final EnvironmentalHazardClientHandler INSTANCE = new EnvironmentalHazardClientHandler();
    private final Map<ChunkPos, EnvironmentalHazardSavedData.HazardZone> hazardZones = new ConcurrentHashMap<ChunkPos, EnvironmentalHazardSavedData.HazardZone>();
    private final Map<ChunkPos, FloatIntPair> chunkColorCache = new ConcurrentHashMap<ChunkPos, FloatIntPair>();

    private EnvironmentalHazardClientHandler() {
        if (ConfigHolder.INSTANCE.gameplay.hazardsEnabled) {
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }

    public void onClientTick() {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (level == null) {
            return;
        }
        RandomSource random = level.random;
        Vec3 playerPosition = Minecraft.getInstance().player.getEyePosition();
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos();
        for (Map.Entry<ChunkPos, EnvironmentalHazardSavedData.HazardZone> entry : this.hazardZones.entrySet()) {
            BlockPos source;
            EnvironmentalHazardSavedData.HazardZone zone;
            ChunkPos chunkPos = entry.getKey();
            if (!level.hasChunk(chunkPos.x, chunkPos.z) || (zone = entry.getValue()).strength() < 200.0f || (source = chunkPos.getMiddleBlockPosition(zone.source().getY())).distToCenterSqr((Position)playerPosition) > 9216.0) continue;
            for (int i = 0; i < 32; ++i) {
                int randX = source.getX() - random.nextInt(9) + random.nextInt(9);
                int randY = source.getY() - random.nextInt(9) + random.nextInt(9);
                int randZ = source.getZ() - random.nextInt(9) + random.nextInt(9);
                pos.set(randX, randY, randZ);
                if (level.getBlockState((BlockPos)pos).isCollisionShapeFullBlock((BlockGetter)level, (BlockPos)pos)) continue;
                level.addParticle((ParticleOptions)new HazardParticleOptions(zone.condition().color, zone.strength() / 250.0f), (double)pos.getX() + random.nextDouble(), (double)pos.getY() + random.nextDouble(), (double)pos.getZ() + random.nextDouble(), 0.0, 0.0, 0.0);
            }
        }
    }

    public void updateHazardMap(Map<ChunkPos, EnvironmentalHazardSavedData.HazardZone> newZones) {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        this.hazardZones.clear();
        this.hazardZones.putAll(newZones);
        for (Map.Entry<ChunkPos, EnvironmentalHazardSavedData.HazardZone> entry : newZones.entrySet()) {
            if (!(entry.getValue().strength() > 200.0f)) continue;
            ChunkPos pos = entry.getKey();
            for (int y = Minecraft.getInstance().level.getMinSection(); y < Minecraft.getInstance().level.getMaxSection(); ++y) {
                Minecraft.getInstance().levelRenderer.setSectionDirtyWithNeighbors(pos.x, y, pos.z);
            }
            ((ClientLevelAccessor)Minecraft.getInstance().level).getTintCaches().forEach((colorResolver, blockTintCache) -> blockTintCache.invalidateForChunk(pos.x, pos.z));
        }
    }

    public void updateHazardStrength(ChunkPos pos, float newStrength) {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        if (this.hazardZones.containsKey(pos)) {
            this.hazardZones.get(pos).strength(newStrength);
        }
        if (newStrength > 200.0f) {
            this.updateChunks(pos);
        }
    }

    public void addHazardZone(ChunkPos pos, EnvironmentalHazardSavedData.HazardZone zone) {
        if (!ConfigHolder.INSTANCE.gameplay.environmentalHazards) {
            return;
        }
        this.hazardZones.put(pos, zone);
        if (zone.strength() > 200.0f) {
            this.updateChunks(pos);
        }
    }

    public void removeHazardZone(ChunkPos pos) {
        this.hazardZones.remove(pos);
        this.updateChunks(pos);
    }

    private void updateChunks(ChunkPos pos) {
        for (int y = Minecraft.getInstance().level.getMinSection(); y < Minecraft.getInstance().level.getMaxSection(); ++y) {
            Minecraft.getInstance().levelRenderer.setSectionDirtyWithNeighbors(pos.x, y, pos.z);
        }
        ((ClientLevelAccessor)Minecraft.getInstance().level).getTintCaches().forEach((colorResolver, blockTintCache) -> blockTintCache.invalidateForChunk(pos.x, pos.z));
    }

    public int colorZone(int color, ChunkPos pos) {
        EnvironmentalHazardSavedData.HazardZone zone = this.hazardZones.get(pos);
        if (zone == null) {
            return color;
        }
        FloatIntPair entry = this.chunkColorCache.get(pos);
        if (entry != null && (entry.firstFloat() > zone.strength() + 0.5f || entry.firstFloat() < zone.strength() - 0.5f)) {
            return entry.valueInt();
        }
        color = EnvironmentalHazardClientHandler.colorize(color, zone.strength(), zone.condition().color);
        this.chunkColorCache.put(pos, FloatIntPair.of((float)zone.strength(), (int)color));
        return color;
    }

    private static int colorize(int color, float pollution, int newColor) {
        if (pollution < 200.0f) {
            return color;
        }
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color & 0xFF;
        float ratio = (pollution - 200.0f) / 600.0f;
        if (ratio > 1.0f) {
            ratio = 1.0f;
        }
        float complement = 1.0f - ratio;
        r = (int)((float)r * complement + ratio * (float)FastColor.ARGB32.red((int)newColor)) & 0xFF;
        g = (int)((float)g * complement + ratio * (float)FastColor.ARGB32.green((int)newColor)) & 0xFF;
        b = (int)((float)b * complement + ratio * (float)FastColor.ARGB32.blue((int)newColor)) & 0xFF;
        return FastColor.ARGB32.color((int)255, (int)r, (int)g, (int)b);
    }

    @Generated
    public Map<ChunkPos, EnvironmentalHazardSavedData.HazardZone> getHazardZones() {
        return this.hazardZones;
    }
}

