/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.model.IDynamicBakedModel;
import org.jetbrains.annotations.NotNull;

public interface IBlockEntityRendererBakedModel<T extends BlockEntity>
extends IDynamicBakedModel,
BlockEntityRenderer<T> {
    public BlockEntityType<? extends T> getBlockEntityType();

    public void render(@NotNull T var1, float var2, @NotNull PoseStack var3, @NotNull MultiBufferSource var4, int var5, int var6);

    default public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
    }

    default public boolean shouldRender(T blockEntity, @NotNull Vec3 cameraPos) {
        return Vec3.atCenterOf((Vec3i)blockEntity.getBlockPos()).closerThan((Position)cameraPos, (double)this.getViewDistance());
    }

    default public AABB getRenderBoundingBox(T blockEntity) {
        BlockPos pos = blockEntity.getBlockPos();
        return new AABB(pos.offset(-1, 0, -1), pos.offset(2, 2, 2));
    }

    default public boolean isCustomRenderer() {
        return true;
    }
}

