/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model;

import com.gregtechceu.gtceu.client.util.GTQuadTransformers;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.BakedModelWrapper;
import net.minecraftforge.client.model.IQuadTransformer;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TextureOverrideModel<T extends BakedModel>
extends BakedModelWrapper<T> {
    public static final IQuadTransformer OVERLAY_OFFSET = GTQuadTransformers.offset(0.002f);
    @NotNull
    protected final Map<String, TextureAtlasSprite> textureOverrides;

    public TextureOverrideModel(T child, Map<String, TextureAtlasSprite> textureOverrides) {
        super(child);
        this.textureOverrides = textureOverrides;
    }

    public BakedModel getChild() {
        return this.originalModel;
    }

    @NotNull
    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, @NotNull RandomSource rand, @NotNull ModelData extraData, @Nullable RenderType renderType) {
        return TextureOverrideModel.retextureQuads(super.getQuads(state, side, rand, extraData, renderType), this.textureOverrides);
    }

    public static List<BakedQuad> retextureQuads(List<BakedQuad> quads, Map<String, TextureAtlasSprite> overrides) {
        LinkedList<BakedQuad> newQuads = new LinkedList<BakedQuad>();
        for (BakedQuad quad : quads) {
            TextureAtlasSprite replacement;
            String textureKey = quad.gtceu$getTextureKey();
            if (textureKey == null || textureKey.isEmpty()) continue;
            if (textureKey.charAt(0) == '#') {
                textureKey = textureKey.substring(1);
            }
            if ((replacement = overrides.get(textureKey)) != null) {
                newQuads.add(GTQuadTransformers.setSprite(quad, replacement));
                continue;
            }
            newQuads.add(quad);
        }
        return newQuads;
    }

    @NotNull
    @Generated
    public Map<String, TextureAtlasSprite> getTextureOverrides() {
        return this.textureOverrides;
    }
}

