/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model.machine;

import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.IMachineFeature;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.model.data.ModelData;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IMachineRendererModel<T extends IMachineFeature> {
    public MachineDefinition getDefinition();

    @OnlyIn(value=Dist.CLIENT)
    @NotNull
    default public List<BakedQuad> getRenderQuads(@Nullable T machine, @Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState blockState, @Nullable Direction side, RandomSource rand, @NotNull ModelData modelData, @Nullable RenderType renderType) {
        return Collections.emptyList();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(T var1, float var2, PoseStack var3, MultiBufferSource var4, int var5, int var6);

    @OnlyIn(value=Dist.CLIENT)
    default public void renderByItem(ItemStack stack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource buffer, int packedLight, int packedOverlay) {
    }

    default public boolean shouldRenderOffScreen(T machine) {
        return false;
    }

    default public boolean shouldRender(T machine, Vec3 cameraPos) {
        return Vec3.atCenterOf((Vec3i)machine.self().getPos()).closerThan((Position)cameraPos, (double)this.getViewDistance());
    }

    default public int getViewDistance() {
        return 64;
    }

    default public AABB getRenderBoundingBox(T machine) {
        BlockPos pos = machine.self().getPos();
        return new AABB(pos.offset(-1, 0, -1), pos.offset(2, 2, 2));
    }

    default public boolean isBlockEntityRenderer() {
        return false;
    }
}

