/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model.machine.multipart;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.gregtechceu.gtceu.api.machine.MachineDefinition;
import com.gregtechceu.gtceu.client.model.machine.MachineModelLoader;
import com.gregtechceu.gtceu.client.model.machine.MachineRenderState;
import com.gregtechceu.gtceu.client.model.machine.multipart.MultiPartBakedModel;
import com.gregtechceu.gtceu.client.model.machine.multipart.MultiPartSelector;
import com.gregtechceu.gtceu.client.model.machine.variant.MultiVariantModel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.Material;
import net.minecraft.client.resources.model.ModelBaker;
import net.minecraft.client.resources.model.ModelState;
import net.minecraft.client.resources.model.UnbakedModel;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.state.StateDefinition;

public record MultiPartUnbakedModel(StateDefinition<MachineDefinition, MachineRenderState> definition, List<MultiPartSelector> selectors) implements UnbakedModel
{
    public Set<MultiVariantModel> getModels() {
        HashSet<MultiVariantModel> set = new HashSet<MultiVariantModel>();
        for (MultiPartSelector selector : this.selectors()) {
            set.add(selector.getVariant());
        }
        return set;
    }

    public Collection<ResourceLocation> getDependencies() {
        return this.selectors().stream().flatMap(selector -> selector.getVariant().getDependencies().stream()).collect(Collectors.toSet());
    }

    public void resolveParents(Function<ResourceLocation, UnbakedModel> resolver) {
        this.selectors().forEach(selector -> selector.getVariant().resolveParents(resolver));
    }

    public MultiPartBakedModel bake(ModelBaker baker, Function<Material, TextureAtlasSprite> spriteGetter, ModelState state, ResourceLocation location) {
        MultiPartBakedModel.Builder builder = new MultiPartBakedModel.Builder();
        for (MultiPartSelector selector : this.selectors()) {
            BakedModel bakedmodel = selector.getVariant().bake(baker, spriteGetter, state, location);
            if (bakedmodel == null) continue;
            builder.add(selector.getPredicate(this.definition), bakedmodel);
        }
        return builder.build();
    }

    public static MultiPartUnbakedModel deserialize(MachineDefinition definition, JsonArray elements) {
        return new MultiPartUnbakedModel(definition.getStateDefinition(), MultiPartUnbakedModel.getSelectors(elements));
    }

    private static List<MultiPartSelector> getSelectors(JsonArray elements) {
        ArrayList<MultiPartSelector> list = new ArrayList<MultiPartSelector>();
        for (JsonElement e : elements) {
            list.add((MultiPartSelector)MachineModelLoader.GSON.fromJson(e, MultiPartSelector.class));
        }
        return list;
    }
}

