/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.model.machine.overlays;

import com.gregtechceu.gtceu.api.machine.trait.RecipeLogic;
import com.gregtechceu.gtceu.api.registry.registrate.provider.GTBlockstateProvider;
import com.gregtechceu.gtceu.common.data.models.GTModels;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import javax.annotation.ParametersAreNonnullByDefault;
import lombok.Generated;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.data.ExistingFileHelper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class WorkableOverlays {
    private final ResourceLocation location;
    private final Map<OverlayFace, StatusTextures> textures = new EnumMap<OverlayFace, StatusTextures>(OverlayFace.class);

    public static WorkableOverlays get(ResourceLocation textureDir, ExistingFileHelper fileHelper) {
        WorkableOverlays model = new WorkableOverlays(textureDir);
        for (OverlayFace overlayFace : OverlayFace.VALUES) {
            ResourceLocation pausedSpriteEmissive;
            ResourceLocation activeSpriteEmissive;
            ResourceLocation normalSpriteEmissive;
            ResourceLocation pausedSprite;
            String overlayPath = "/overlay_" + overlayFace.getName();
            ResourceLocation normalSprite = textureDir.withSuffix(overlayPath);
            if (!fileHelper.exists(normalSprite, (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
                model.textures.put(overlayFace, StatusTextures.EMPTY);
                continue;
            }
            ResourceLocation activeSprite = normalSprite.withSuffix("_active");
            if (!fileHelper.exists(activeSprite, (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
                activeSprite = normalSprite;
            }
            if (!fileHelper.exists(pausedSprite = normalSprite.withSuffix("_paused"), (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
                pausedSprite = normalSprite;
            }
            if (!fileHelper.exists(normalSpriteEmissive = normalSprite.withSuffix("_emissive"), (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
                normalSpriteEmissive = null;
            }
            if (!fileHelper.exists(activeSpriteEmissive = activeSprite.withSuffix("_emissive"), (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
                activeSpriteEmissive = null;
            }
            if (!fileHelper.exists(pausedSpriteEmissive = pausedSprite.withSuffix("_emissive"), (ExistingFileHelper.IResourceType)GTBlockstateProvider.TEXTURE)) {
                pausedSpriteEmissive = null;
            }
            model.textures.put(overlayFace, new StatusTextures(normalSprite, activeSprite, pausedSprite, normalSpriteEmissive, activeSpriteEmissive, pausedSpriteEmissive));
        }
        return model;
    }

    public WorkableOverlays(ResourceLocation location) {
        this.location = location;
    }

    @Generated
    public ResourceLocation getLocation() {
        return this.location;
    }

    @Generated
    public Map<OverlayFace, StatusTextures> getTextures() {
        return this.textures;
    }

    public static enum OverlayFace {
        FRONT,
        BACK,
        TOP,
        BOTTOM,
        SIDE;

        public static final OverlayFace[] VALUES;

        public static OverlayFace bySide(Direction side) {
            return switch (side) {
                default -> throw new IncompatibleClassChangeError();
                case Direction.DOWN -> BOTTOM;
                case Direction.UP -> TOP;
                case Direction.NORTH -> FRONT;
                case Direction.SOUTH -> BACK;
                case Direction.WEST, Direction.EAST -> SIDE;
            };
        }

        public String getName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        static {
            VALUES = OverlayFace.values();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class StatusTextures {
        public static final StatusTextures EMPTY = new StatusTextures();
        private final Map<RecipeLogic.Status, ResourceLocation> textures = new EnumMap<RecipeLogic.Status, ResourceLocation>(RecipeLogic.Status.class);
        private final Map<RecipeLogic.Status, ResourceLocation> emissiveTextures = new EnumMap<RecipeLogic.Status, ResourceLocation>(RecipeLogic.Status.class);

        public StatusTextures(@Nullable ResourceLocation normalSprite, @Nullable ResourceLocation activeSprite, @Nullable ResourceLocation pausedSprite, @Nullable ResourceLocation normalSpriteEmissive, @Nullable ResourceLocation activeSpriteEmissive, @Nullable ResourceLocation pausedSpriteEmissive) {
            this.textures.put(RecipeLogic.Status.IDLE, normalSprite);
            this.emissiveTextures.put(RecipeLogic.Status.IDLE, normalSpriteEmissive);
            this.textures.put(RecipeLogic.Status.WORKING, activeSprite);
            this.emissiveTextures.put(RecipeLogic.Status.WORKING, activeSpriteEmissive);
            this.textures.put(RecipeLogic.Status.WAITING, activeSprite);
            this.emissiveTextures.put(RecipeLogic.Status.WAITING, activeSpriteEmissive);
            this.textures.put(RecipeLogic.Status.SUSPEND, pausedSprite);
            this.emissiveTextures.put(RecipeLogic.Status.SUSPEND, pausedSpriteEmissive);
        }

        private StatusTextures() {
        }

        @NotNull
        public ResourceLocation getTexture(@NotNull RecipeLogic.Status status) {
            ResourceLocation value = this.textures.get((Object)status);
            return value != null ? value : GTModels.BLANK_TEXTURE;
        }

        @NotNull
        public ResourceLocation getEmissiveTexture(@NotNull RecipeLogic.Status status) {
            ResourceLocation value = this.emissiveTextures.get((Object)status);
            return value != null ? value : GTModels.BLANK_TEXTURE;
        }
    }
}

