/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.particle;

import com.gregtechceu.gtceu.common.particle.HazardParticleOptions;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class HazardParticle
extends TextureSheetParticle {
    private final SpriteSet sprites;

    protected HazardParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, HazardParticleOptions options, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.friction = 0.96f;
        this.gravity = 0.0125f;
        this.speedUpWhenYMotionIsBlocked = true;
        this.sprites = sprites;
        this.xd *= (double)0.1f;
        this.yd *= (double)0.1f;
        this.zd *= (double)0.1f;
        float colorMultiplier = this.random.nextFloat() * 0.4f + 0.6f;
        this.rCol = this.randomizeColor((float)FastColor.ARGB32.red((int)options.color()) / 255.0f, colorMultiplier);
        this.gCol = this.randomizeColor((float)FastColor.ARGB32.green((int)options.color()) / 255.0f, colorMultiplier);
        this.bCol = this.randomizeColor((float)FastColor.ARGB32.blue((int)options.color()) / 255.0f, colorMultiplier);
        this.quadSize *= 0.75f * options.scale();
        this.lifetime = (int)((double)this.lifetime / ((double)level.random.nextFloat() * 0.8 + 0.2) * 2.0);
        this.setSpriteFromAge(sprites);
        this.hasPhysics = false;
    }

    protected float randomizeColor(float coordMultiplier, float multiplier) {
        return (this.random.nextFloat() * 0.2f + 0.8f) * coordMultiplier * multiplier;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float scaleFactor) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + scaleFactor) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        super.tick();
        this.setSpriteFromAge(this.sprites);
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<HazardParticleOptions> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(HazardParticleOptions options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            RandomSource randomSource = level.random;
            return new HazardParticle(level, x, y, z, xSpeed += (double)randomSource.nextFloat() * -1.9 * (double)randomSource.nextFloat() * 0.1, ySpeed += (double)randomSource.nextFloat() * -0.5 * (double)randomSource.nextFloat() * 0.1 * 5.0, zSpeed += (double)randomSource.nextFloat() * -1.9 * (double)randomSource.nextFloat() * 0.1, options, this.sprites);
        }
    }
}

