/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.particle;

import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.ParticleRenderType;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.client.particle.TextureSheetParticle;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.util.FastColor;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
@OnlyIn(value=Dist.CLIENT)
public class MufflerParticle
extends TextureSheetParticle {
    private static final int COLOR = 1973277;
    private final SpriteSet sprites;

    protected MufflerParticle(ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed, SimpleParticleType options, SpriteSet sprites) {
        super(level, x, y, z, xSpeed, ySpeed, zSpeed);
        this.speedUpWhenYMotionIsBlocked = true;
        this.sprites = sprites;
        this.xd *= (double)0.1f;
        this.yd *= 0.5;
        this.zd *= (double)0.1f;
        float colorMultiplier = this.random.nextFloat() * 4.4f + 1.3f;
        this.rCol = this.randomizeColor((float)FastColor.ARGB32.red((int)1973277) / 255.0f, colorMultiplier);
        this.gCol = this.randomizeColor((float)FastColor.ARGB32.green((int)1973277) / 255.0f, colorMultiplier);
        this.bCol = this.randomizeColor((float)FastColor.ARGB32.blue((int)1973277) / 255.0f, colorMultiplier + 1.0f);
        this.quadSize *= 1.5f;
        this.lifetime = (int)((double)this.lifetime / ((double)level.random.nextFloat() * 0.8 + 0.2) * 2.0);
        this.setSpriteFromAge(sprites);
        this.hasPhysics = true;
    }

    protected float randomizeColor(float coordMultiplier, float multiplier) {
        return (this.random.nextFloat() * 0.2f + 0.8f) * coordMultiplier * multiplier;
    }

    public ParticleRenderType getRenderType() {
        return ParticleRenderType.PARTICLE_SHEET_OPAQUE;
    }

    public float getQuadSize(float scaleFactor) {
        return this.quadSize * Mth.clamp((float)(((float)this.age + scaleFactor) / (float)this.lifetime * 32.0f), (float)0.0f, (float)1.0f);
    }

    public void tick() {
        this.xo = this.x;
        this.yo = this.y;
        this.zo = this.z;
        this.setSpriteFromAge(this.sprites);
        if (this.age++ < this.lifetime && !(this.alpha <= 0.0f)) {
            this.yd -= (double)this.gravity;
            this.move(this.xd, this.yd, this.zd);
            if (this.age >= this.lifetime - 60 && this.alpha > 0.01f) {
                this.alpha -= 0.015f;
            }
        } else {
            this.remove();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Provider
    implements ParticleProvider<SimpleParticleType> {
        private final SpriteSet sprites;

        public Provider(SpriteSet sprites) {
            this.sprites = sprites;
        }

        public Particle createParticle(SimpleParticleType options, ClientLevel level, double x, double y, double z, double xSpeed, double ySpeed, double zSpeed) {
            RandomSource randomSource = level.random;
            return new MufflerParticle(level, x, y, z, xSpeed, ySpeed += (double)randomSource.nextFloat() * -1.9 * (double)randomSource.nextFloat() * 0.1 * 5.0, zSpeed, options, this.sprites);
        }
    }
}

