/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer;

import com.gregtechceu.gtceu.api.blockentity.PipeBlockEntity;
import com.gregtechceu.gtceu.api.capability.GTCapabilityHelper;
import com.gregtechceu.gtceu.api.capability.ICoverable;
import com.gregtechceu.gtceu.api.gui.GuiTextures;
import com.gregtechceu.gtceu.api.item.PipeBlockItem;
import com.gregtechceu.gtceu.api.item.tool.GTToolType;
import com.gregtechceu.gtceu.api.item.tool.IToolGridHighlight;
import com.gregtechceu.gtceu.api.item.tool.ToolHelper;
import com.gregtechceu.gtceu.api.pattern.util.RelativeDirection;
import com.gregtechceu.gtceu.api.pipenet.IPipeType;
import com.gregtechceu.gtceu.client.util.RenderUtil;
import com.gregtechceu.gtceu.common.item.CoverPlaceBehavior;
import com.gregtechceu.gtceu.common.item.tool.rotation.CustomBlockRotations;
import com.gregtechceu.gtceu.common.item.tool.rotation.ICustomRotationBehavior;
import com.gregtechceu.gtceu.utils.GTMatrixUtils;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector3fc;

@OnlyIn(value=Dist.CLIENT)
public class BlockHighlightRenderer {
    private static float rColour;
    private static float gColour;
    private static float bColour;

    public static void renderBlockHighlight(PoseStack poseStack, Camera camera, BlockHitResult target, MultiBufferSource multiBufferSource, float partialTick) {
        Minecraft mc = Minecraft.getInstance();
        ClientLevel level = mc.level;
        LocalPlayer player = mc.player;
        if (level != null && player != null) {
            Object pipeType;
            Item texture2;
            ItemStack held = player.getMainHandItem();
            BlockPos blockPos = target.getBlockPos();
            Vector3f blockCenter = blockPos.getCenter().toVector3f();
            Set<GTToolType> toolType = ToolHelper.getToolTypes(held);
            BlockEntity blockEntity = level.getBlockEntity(blockPos);
            Vec3 cameraPos = camera.getPosition();
            if (!toolType.isEmpty() || held.isEmpty() && player.isShiftKeyDown()) {
                IToolGridHighlight gridHighlight = null;
                if (blockEntity instanceof IToolGridHighlight) {
                    IToolGridHighlight highLight;
                    gridHighlight = highLight = (IToolGridHighlight)blockEntity;
                } else {
                    ICustomRotationBehavior behavior;
                    Block block = level.getBlockState(blockPos).getBlock();
                    if (block instanceof IToolGridHighlight) {
                        IToolGridHighlight highLight;
                        gridHighlight = highLight = (IToolGridHighlight)block;
                    } else if (toolType.contains(GTToolType.WRENCH) && (behavior = CustomBlockRotations.getCustomRotation(level.getBlockState(blockPos).getBlock())) != null && behavior.showGrid()) {
                        gridHighlight = new IToolGridHighlight(){

                            @Override
                            @Nullable
                            public ResourceTexture sideTips(Player player, BlockPos pos, BlockState state, Set<GTToolType> toolTypes, Direction side) {
                                return behavior.showSideTip(state, side) ? GuiTextures.TOOL_FRONT_FACING_ROTATION : null;
                            }
                        };
                    }
                }
                if (gridHighlight == null) {
                    return;
                }
                BlockState state = level.getBlockState(blockPos);
                poseStack.pushPose();
                if (gridHighlight.shouldRenderGrid((Player)player, blockPos, state, held, toolType)) {
                    IToolGridHighlight finalGridHighlight = gridHighlight;
                    BlockHighlightRenderer.drawGridOverlays(poseStack, multiBufferSource, cameraPos, target, side -> finalGridHighlight.sideTips((Player)player, blockPos, state, toolType, (Direction)side));
                } else {
                    Direction facing = target.getDirection();
                    ResourceTexture texture2 = gridHighlight.sideTips((Player)player, blockPos, state, toolType, facing);
                    if (texture2 != null) {
                        RenderSystem.disableDepthTest();
                        RenderSystem.enableBlend();
                        RenderSystem.defaultBlendFunc();
                        poseStack.translate((float)facing.getStepX() * 0.01f, (float)facing.getStepY() * 0.01f, (float)facing.getStepZ() * 0.01f);
                        poseStack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
                        RenderUtil.moveToFace(poseStack, (Vector3fc)blockCenter, facing);
                        if (facing.getAxis() == Direction.Axis.Y) {
                            RenderUtil.rotateToFace(poseStack, facing, Direction.SOUTH);
                        } else {
                            RenderUtil.rotateToFace(poseStack, facing, Direction.NORTH);
                        }
                        poseStack.scale(0.0625f, 0.0625f, 0.0f);
                        poseStack.translate(-8.0f, -8.0f, 0.0f);
                        BlockHighlightRenderer.drawResourceTexture(poseStack, multiBufferSource, texture2, -1, 4.0f, 4.0f, 8.0f, 8.0f);
                        RenderSystem.disableBlend();
                        RenderSystem.enableDepthTest();
                    }
                }
                poseStack.popPose();
                return;
            }
            ICoverable coverable = GTCapabilityHelper.getCoverable((Level)level, blockPos, target.getDirection());
            if (coverable != null) {
                if (CoverPlaceBehavior.isCoverBehaviorItem(held, coverable::hasAnyCover, coverDef -> ICoverable.canPlaceCover(coverDef, coverable))) {
                    poseStack.pushPose();
                    BlockHighlightRenderer.drawGridOverlays(poseStack, multiBufferSource, cameraPos, target, side -> coverable.hasCover((Direction)side) ? null : GuiTextures.TOOL_ATTACH_COVER);
                    poseStack.popPose();
                }
            }
            if ((texture2 = held.getItem()) instanceof PipeBlockItem) {
                PipeBlockItem pipeBlockItem = (PipeBlockItem)texture2;
                v0 = pipeBlockItem.getBlock().pipeType;
            } else {
                v0 = pipeType = null;
            }
            if (pipeType instanceof IPipeType) {
                PipeBlockEntity pipeBlockEntity;
                IPipeType type = pipeType;
                if (blockEntity instanceof PipeBlockEntity && ((IPipeType)((Object)(pipeBlockEntity = (PipeBlockEntity)blockEntity).getPipeType())).type().equals((Object)type.type())) {
                    poseStack.pushPose();
                    BlockHighlightRenderer.drawGridOverlays(poseStack, multiBufferSource, cameraPos, target, side -> level.isEmptyBlock(blockPos.relative(side)) ? pipeBlockEntity.getPipeTexture(true) : null);
                    poseStack.popPose();
                }
            }
        }
    }

    private static void drawGridOverlays(PoseStack poseStack, MultiBufferSource bufferSource, Vec3 cameraPos, BlockHitResult blockHitResult, Function<Direction, ResourceTexture> texture) {
        int color;
        rColour = gColour = 0.2f + (float)Math.sin((float)System.currentTimeMillis() % 2513.2742f / 800.0f) / 2.0f;
        bColour = 1.0f;
        BlockPos blockPos = blockHitResult.getBlockPos();
        float minX = blockPos.getX();
        float maxX = blockPos.getX() + 1;
        float minY = blockPos.getY();
        float maxY = blockPos.getY() + 1;
        float maxZ = (float)blockPos.getZ() + 1.01f;
        Direction attachSide = ICoverable.traceCoverSide(blockHitResult);
        Vector3f topRight = new Vector3f(maxX, maxY, maxZ);
        Vector3f bottomRight = new Vector3f(maxX, minY, maxZ);
        Vector3f bottomLeft = new Vector3f(minX, minY, maxZ);
        Vector3f topLeft = new Vector3f(minX, maxY, maxZ);
        Vector3f shiftX = new Vector3f(0.25f, 0.0f, 0.0f);
        Vector3f shiftY = new Vector3f(0.0f, 0.25f, 0.0f);
        Vector3f cubeCenter = blockPos.getCenter().toVector3f();
        topRight.sub((Vector3fc)cubeCenter);
        bottomRight.sub((Vector3fc)cubeCenter);
        bottomLeft.sub((Vector3fc)cubeCenter);
        topLeft.sub((Vector3fc)cubeCenter);
        Direction front = blockHitResult.getDirection();
        Direction back = front.getOpposite();
        Direction left = RelativeDirection.LEFT.getActualDirection(front);
        Direction right = RelativeDirection.RIGHT.getActualDirection(front);
        Direction top = RelativeDirection.UP.getActualDirection(front);
        Direction bottom = RelativeDirection.DOWN.getActualDirection(front);
        Quaternionf rotation = GTMatrixUtils.getRotation(Direction.SOUTH, front);
        topRight.rotate((Quaternionfc)rotation);
        bottomRight.rotate((Quaternionfc)rotation);
        bottomLeft.rotate((Quaternionfc)rotation);
        topLeft.rotate((Quaternionfc)rotation);
        shiftX.rotate((Quaternionfc)rotation);
        shiftY.rotate((Quaternionfc)rotation);
        ResourceTexture leftBlocked = texture.apply(left);
        ResourceTexture rightBlocked = texture.apply(right);
        ResourceTexture topBlocked = texture.apply(top);
        ResourceTexture bottomBlocked = texture.apply(bottom);
        ResourceTexture frontBlocked = texture.apply(front);
        ResourceTexture backBlocked = texture.apply(back);
        topRight.add((Vector3fc)cubeCenter);
        bottomRight.add((Vector3fc)cubeCenter);
        bottomLeft.add((Vector3fc)cubeCenter);
        topLeft.add((Vector3fc)cubeCenter);
        poseStack.pushPose();
        poseStack.translate(-cameraPos.x(), -cameraPos.y(), -cameraPos.z());
        VertexConsumer buffer = bufferSource.getBuffer(RenderType.lines());
        RenderSystem.lineWidth((float)3.0f);
        PoseStack.Pose pose = poseStack.last();
        BlockHighlightRenderer.drawLine(pose, buffer, (Vector3fc)new Vector3f((Vector3fc)topRight).sub((Vector3fc)shiftX), (Vector3fc)new Vector3f((Vector3fc)bottomRight).sub((Vector3fc)shiftX));
        BlockHighlightRenderer.drawLine(pose, buffer, (Vector3fc)new Vector3f((Vector3fc)bottomLeft).add((Vector3fc)shiftX), (Vector3fc)new Vector3f((Vector3fc)topLeft).add((Vector3fc)shiftX));
        BlockHighlightRenderer.drawLine(pose, buffer, (Vector3fc)new Vector3f((Vector3fc)topLeft).sub((Vector3fc)shiftY), (Vector3fc)new Vector3f((Vector3fc)topRight).sub((Vector3fc)shiftY));
        BlockHighlightRenderer.drawLine(pose, buffer, (Vector3fc)new Vector3f((Vector3fc)bottomLeft).add((Vector3fc)shiftY), (Vector3fc)new Vector3f((Vector3fc)bottomRight).add((Vector3fc)shiftY));
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        poseStack.pushPose();
        poseStack.translate((float)front.getStepX() * 0.01f, (float)front.getStepY() * 0.01f, (float)front.getStepZ() * 0.01f);
        RenderUtil.moveToFace(poseStack, (Vector3fc)cubeCenter, front);
        RenderUtil.rotateToFace(poseStack, front, Direction.SOUTH);
        poseStack.scale(0.0625f, 0.0625f, 0.0f);
        poseStack.translate(-8.0f, -8.0f, 0.0f);
        float MARGIN = 0.2f;
        if (leftBlocked != null) {
            color = attachSide == left ? -1 : 0x44FFFFFF;
            BlockHighlightRenderer.drawResourceTextureWithMargin(poseStack, bufferSource, leftBlocked, color, 0.0f, 6.0f, 4.0f, 4.0f, MARGIN);
        }
        if (topBlocked != null) {
            color = attachSide == top ? -1 : 0x44FFFFFF;
            BlockHighlightRenderer.drawResourceTextureWithMargin(poseStack, bufferSource, topBlocked, color, 6.0f, 12.0f, 4.0f, 4.0f, MARGIN);
        }
        if (rightBlocked != null) {
            color = attachSide == right ? -1 : 0x44FFFFFF;
            BlockHighlightRenderer.drawResourceTextureWithMargin(poseStack, bufferSource, rightBlocked, color, 12.0f, 6.0f, 4.0f, 4.0f, MARGIN);
        }
        if (bottomBlocked != null) {
            color = attachSide == bottom ? -1 : 0x44FFFFFF;
            BlockHighlightRenderer.drawResourceTextureWithMargin(poseStack, bufferSource, bottomBlocked, color, 6.0f, 0.0f, 4.0f, 4.0f, MARGIN);
        }
        if (frontBlocked != null) {
            color = attachSide == front ? -1 : 0x44FFFFFF;
            BlockHighlightRenderer.drawResourceTextureWithMargin(poseStack, bufferSource, frontBlocked, color, 6.0f, 6.0f, 4.0f, 4.0f, MARGIN);
        }
        if (backBlocked != null) {
            color = attachSide == back ? -1 : 0x44FFFFFF;
            BlockHighlightRenderer.drawResourceTextureWithMargin(poseStack, bufferSource, backBlocked, color, 0.0f, 0.0f, 4.0f, 4.0f, MARGIN);
            BlockHighlightRenderer.drawResourceTextureWithMargin(poseStack, bufferSource, backBlocked, color, 12.0f, 0.0f, 4.0f, 4.0f, MARGIN);
            BlockHighlightRenderer.drawResourceTextureWithMargin(poseStack, bufferSource, backBlocked, color, 0.0f, 12.0f, 4.0f, 4.0f, MARGIN);
            BlockHighlightRenderer.drawResourceTextureWithMargin(poseStack, bufferSource, backBlocked, color, 12.0f, 12.0f, 4.0f, 4.0f, MARGIN);
        }
        RenderSystem.disableBlend();
        RenderSystem.enableDepthTest();
        poseStack.popPose();
        poseStack.popPose();
    }

    private static void drawLine(PoseStack.Pose pose, VertexConsumer buffer, Vector3fc from, Vector3fc to) {
        Vector3f normal = from.sub(to, new Vector3f());
        buffer.vertex(pose.pose(), from.x(), from.y(), from.z()).color(rColour, gColour, bColour, 1.0f).normal(pose.normal(), normal.x(), normal.y(), normal.z()).endVertex();
        buffer.vertex(pose.pose(), to.x(), to.y(), to.z()).color(rColour, gColour, bColour, 1.0f).normal(pose.normal(), normal.x(), normal.y(), normal.z()).endVertex();
    }

    private static void drawResourceTexture(PoseStack poseStack, MultiBufferSource bufferSource, ResourceTexture texture, int color, float x, float y, float w, float h) {
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.text((ResourceLocation)texture.imageLocation));
        Matrix4f pose = poseStack.last().pose();
        float u0 = texture.offsetX;
        float v0 = texture.offsetY;
        float u1 = texture.imageWidth;
        float v1 = texture.imageHeight;
        consumer.vertex(pose, x, y + h, 0.0f).color(color).uv(u0, v0 + v1).uv2(0xF000F0).endVertex();
        consumer.vertex(pose, x + w, y + h, 0.0f).color(color).uv(u0 + u1, v0 + v1).uv2(0xF000F0).endVertex();
        consumer.vertex(pose, x + w, y, 0.0f).color(color).uv(u0 + u1, v0).uv2(0xF000F0).endVertex();
        consumer.vertex(pose, x, y, 0.0f).color(color).uv(u0, v0).uv2(0xF000F0).endVertex();
    }

    private static void drawResourceTextureWithMargin(PoseStack poseStack, MultiBufferSource bufferSource, ResourceTexture texture, int color, float x, float y, float w, float h, float m) {
        BlockHighlightRenderer.drawResourceTexture(poseStack, bufferSource, texture, color, x + m, y + m, w - 2.0f * m, h - 2.0f * m);
    }
}

