/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer;

import com.gregtechceu.gtceu.client.model.IBlockEntityRendererBakedModel;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HalfTransparentBlock;
import net.minecraft.world.level.block.StainedGlassPaneBlock;
import org.jetbrains.annotations.NotNull;

public class ItemWithBERModelRenderer
extends BlockEntityWithoutLevelRenderer {
    public static final ItemWithBERModelRenderer INSTANCE = new ItemWithBERModelRenderer();
    protected final ItemRenderer itemRenderer = Minecraft.getInstance().getItemRenderer();

    protected ItemWithBERModelRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public void renderByItem(@NotNull ItemStack stack, @NotNull ItemDisplayContext displayContext, @NotNull PoseStack poseStack, @NotNull MultiBufferSource buffer, int packedLight, int packedOverlay) {
        Item item;
        ClientLevel level = Minecraft.getInstance().level;
        LocalPlayer player = Minecraft.getInstance().player;
        BakedModel model = this.itemRenderer.getModel(stack, (Level)level, (LivingEntity)player, 0);
        if (model instanceof IBlockEntityRendererBakedModel) {
            IBlockEntityRendererBakedModel berModel = (IBlockEntityRendererBakedModel)model;
            berModel.renderByItem(stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
        } else {
            super.renderByItem(stack, displayContext, poseStack, buffer, packedLight, packedOverlay);
        }
        boolean fabulous = true;
        if (displayContext != ItemDisplayContext.GUI && !displayContext.firstPerson() && (item = stack.getItem()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)item;
            Block block = blockItem.getBlock();
            fabulous = !(block instanceof HalfTransparentBlock) && !(block instanceof StainedGlassPaneBlock);
        }
        for (BakedModel renderPass : model.getRenderPasses(stack, fabulous)) {
            for (RenderType renderType : renderPass.getRenderTypes(stack, fabulous)) {
                VertexConsumer consumer = fabulous ? ItemRenderer.getFoilBufferDirect((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (boolean)stack.hasFoil()) : ItemRenderer.getFoilBuffer((MultiBufferSource)buffer, (RenderType)renderType, (boolean)true, (boolean)stack.hasFoil());
                this.itemRenderer.renderModelLists(renderPass, stack, packedLight, packedOverlay, poseStack, consumer);
            }
        }
    }
}

