/*
 * Decompiled with CFR 0.152.
 */
package com.gregtechceu.gtceu.client.renderer;

import com.gregtechceu.gtceu.api.GTValues;
import com.gregtechceu.gtceu.api.block.IMachineBlock;
import com.gregtechceu.gtceu.api.block.MetaMachineBlock;
import com.gregtechceu.gtceu.api.data.RotationState;
import com.gregtechceu.gtceu.api.machine.IMachineBlockEntity;
import com.gregtechceu.gtceu.api.machine.MultiblockMachineDefinition;
import com.gregtechceu.gtceu.api.machine.feature.multiblock.IMultiController;
import com.gregtechceu.gtceu.api.machine.multiblock.MultiblockControllerMachine;
import com.gregtechceu.gtceu.api.pattern.MultiblockShapeInfo;
import com.lowdragmc.lowdraglib.client.scene.WorldSceneRenderer;
import com.lowdragmc.lowdraglib.client.scene.forge.WorldSceneRendererImpl;
import com.lowdragmc.lowdraglib.utils.BlockInfo;
import com.lowdragmc.lowdraglib.utils.TrackedDummyWorld;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import lombok.Generated;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.ItemBlockRenderTypes;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public class MultiblockInWorldPreviewRenderer {
    private static final AtomicReference<Object> BUFFERS = new AtomicReference();
    @Nullable
    private static TrackedDummyWorld LEVEL = null;
    @Nullable
    private static Thread THREAD = null;
    @Nullable
    private static Set<BlockPos> BLOCK_ENTITIES;
    private static final AtomicInteger LEFT_TICK;
    private static final AtomicReference<CacheState> CACHE_STATE;
    @Nullable
    private static BlockPos LAST_POS;
    private static int LAST_LAYER;

    private static VertexBuffer[] initBuffers() {
        List layers = RenderType.chunkBufferLayers();
        VertexBuffer[] buffers = new VertexBuffer[layers.size()];
        for (int j = 0; j < layers.size(); ++j) {
            buffers[j] = new VertexBuffer(VertexBuffer.Usage.STATIC);
        }
        return buffers;
    }

    public static void cleanPreview() {
        CACHE_STATE.set(CacheState.UNUSED);
        LEVEL = null;
        BLOCK_ENTITIES = null;
        LEFT_TICK.set(-1);
        LAST_POS = null;
        LAST_LAYER = -1;
    }

    public static void removePreview(BlockPos pos) {
        if (LAST_POS != null && LAST_POS.equals((Object)pos)) {
            MultiblockInWorldPreviewRenderer.cleanPreview();
        }
    }

    public static void showPreview(BlockPos pos, MultiblockControllerMachine controller, int duration) {
        BlockState blockState;
        int z;
        BlockInfo[] column;
        int y;
        BlockInfo[][] aisle;
        int x;
        if (!controller.getDefinition().isRenderWorldPreview()) {
            return;
        }
        Direction front = controller.getFrontFacing();
        Direction up = controller.getUpwardsFacing();
        MultiblockShapeInfo shapeInfo = controller.getDefinition().getMatchingShapes().get(0);
        HashMap<BlockPos, BlockInfo> blockMap = new HashMap<BlockPos, BlockInfo>();
        IMultiController controllerBase = null;
        LEVEL = new TrackedDummyWorld();
        BlockInfo[][][] blocks = shapeInfo.getBlocks();
        BlockPos controllerPatternPos = null;
        int maxY = 0;
        for (x = 0; x < blocks.length; ++x) {
            aisle = blocks[x];
            maxY = Math.max(maxY, aisle.length);
            for (y = 0; y < aisle.length; ++y) {
                column = aisle[y];
                for (z = 0; z < column.length; ++z) {
                    IMachineBlock machineBlock;
                    blockState = column[z].getBlockState();
                    Block block = blockState.getBlock();
                    if (!(block instanceof IMachineBlock) || !((machineBlock = (IMachineBlock)block).getDefinition() instanceof MultiblockMachineDefinition)) continue;
                    controllerPatternPos = new BlockPos(x, y, z);
                }
            }
        }
        if (controllerPatternPos == null) {
            return;
        }
        if (LAST_POS != null && LAST_POS.equals((Object)pos)) {
            if (++LAST_LAYER >= maxY) {
                LAST_LAYER = -1;
            }
        } else {
            LAST_LAYER = -1;
        }
        LAST_POS = pos;
        for (x = 0; x < blocks.length; ++x) {
            aisle = blocks[x];
            for (y = 0; y < aisle.length; ++y) {
                column = aisle[y];
                if (LAST_LAYER != -1 && LAST_LAYER != y) continue;
                for (z = 0; z < column.length; ++z) {
                    IMachineBlockEntity holder;
                    BlockPos realPos;
                    Object object;
                    MetaMachineBlock machineBlock;
                    RotationState rotationState;
                    blockState = column[z].getBlockState();
                    BlockPos offset = new BlockPos(x, y, z).subtract((Vec3i)controllerPatternPos);
                    switch (front) {
                        default: {
                            throw new IncompatibleClassChangeError();
                        }
                        case NORTH: 
                        case UP: 
                        case DOWN: {
                            BlockPos blockPos = offset.rotate(Rotation.NONE);
                            break;
                        }
                        case SOUTH: {
                            BlockPos blockPos = offset.rotate(Rotation.CLOCKWISE_180);
                            break;
                        }
                        case EAST: {
                            BlockPos blockPos = offset.rotate(Rotation.COUNTERCLOCKWISE_90);
                            break;
                        }
                        case WEST: {
                            BlockPos blockPos = offset = offset.rotate(Rotation.CLOCKWISE_90);
                        }
                    }
                    Rotation r = up == Direction.NORTH ? Rotation.NONE : (up == Direction.EAST ? Rotation.CLOCKWISE_90 : (up == Direction.SOUTH ? Rotation.CLOCKWISE_180 : (up == Direction.WEST ? Rotation.COUNTERCLOCKWISE_90 : Rotation.NONE)));
                    offset = MultiblockInWorldPreviewRenderer.rotateByFrontAxis(offset, front, r);
                    Block block = blockState.getBlock();
                    if (block instanceof MetaMachineBlock && (rotationState = (machineBlock = (MetaMachineBlock)block).getRotationState()) != RotationState.NONE) {
                        Direction face = (Direction)blockState.getValue((Property)rotationState.property);
                        if (face.getAxis() != Direction.Axis.Y) {
                            switch (front) {
                                default: {
                                    throw new IncompatibleClassChangeError();
                                }
                                case NORTH: 
                                case UP: 
                                case DOWN: {
                                    Direction direction = front;
                                    break;
                                }
                                case SOUTH: {
                                    Direction direction = face.getOpposite();
                                    break;
                                }
                                case WEST: {
                                    Direction direction = face.getCounterClockWise();
                                    break;
                                }
                                case EAST: {
                                    Direction direction = face = face.getClockWise();
                                }
                            }
                        }
                        if (rotationState.test(face)) {
                            blockState = (BlockState)blockState.setValue((Property)rotationState.property, (Comparable)face);
                        }
                    }
                    if ((object = column[z].getBlockEntity(realPos = pos.offset((Vec3i)offset))) instanceof IMachineBlockEntity && (object = (holder = (IMachineBlockEntity)object).getMetaMachine()) instanceof IMultiController) {
                        IMultiController cont = (IMultiController)object;
                        holder.getSelf().setLevel((Level)LEVEL);
                        controllerBase = cont;
                        continue;
                    }
                    blockMap.put(realPos, BlockInfo.fromBlockState((BlockState)blockState));
                }
            }
        }
        LEVEL.addBlocks(blockMap);
        if (controllerBase != null) {
            LEVEL.setInnerBlockEntity(controllerBase.self().holder.getSelf());
        }
        MultiblockInWorldPreviewRenderer.prepareBuffers(LEVEL, blockMap.keySet(), duration);
    }

    private static BlockPos rotateByFrontAxis(BlockPos pos, Direction front, Rotation rotation) {
        if (front.getAxis() == Direction.Axis.X) {
            return switch (rotation) {
                default -> new BlockPos(-pos.getX(), pos.getY(), -pos.getZ());
                case Rotation.CLOCKWISE_90 -> new BlockPos(-pos.getX(), -front.getAxisDirection().getStep() * pos.getZ(), front.getAxisDirection().getStep() * -pos.getY());
                case Rotation.CLOCKWISE_180 -> new BlockPos(-pos.getX(), -pos.getY(), pos.getZ());
                case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(-pos.getX(), front.getAxisDirection().getStep() * pos.getZ(), front.getAxisDirection().getStep() * pos.getY());
            };
        }
        if (front.getAxis() == Direction.Axis.Y) {
            return switch (rotation) {
                default -> new BlockPos(-front.getAxisDirection().getStep() * pos.getX(), -front.getAxisDirection().getStep() * pos.getZ(), -pos.getY());
                case Rotation.CLOCKWISE_90 -> new BlockPos(pos.getY(), -front.getAxisDirection().getStep() * pos.getZ(), -front.getAxisDirection().getStep() * pos.getX());
                case Rotation.CLOCKWISE_180 -> new BlockPos(front.getAxisDirection().getStep() * pos.getX(), -front.getAxisDirection().getStep() * pos.getZ(), pos.getY());
                case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(-pos.getY(), -front.getAxisDirection().getStep() * pos.getZ(), front.getAxisDirection().getStep() * pos.getX());
            };
        }
        if (front.getAxis() == Direction.Axis.Z) {
            return switch (rotation) {
                default -> pos;
                case Rotation.CLOCKWISE_90 -> new BlockPos(front.getAxisDirection().getStep() * pos.getY(), -front.getAxisDirection().getStep() * pos.getX(), pos.getZ());
                case Rotation.CLOCKWISE_180 -> new BlockPos(-pos.getX(), -pos.getY(), pos.getZ());
                case Rotation.COUNTERCLOCKWISE_90 -> new BlockPos(front.getAxisDirection().getStep() * -pos.getY(), front.getAxisDirection().getStep() * pos.getX(), pos.getZ());
            };
        }
        return pos;
    }

    public static void onClientTick() {
        if (LEFT_TICK.get() > 0 && LEFT_TICK.decrementAndGet() <= 0) {
            MultiblockInWorldPreviewRenderer.cleanPreview();
        }
    }

    public static void renderInWorldPreview(PoseStack poseStack, Camera camera, float partialTicks) {
        if (CACHE_STATE.get() == CacheState.COMPILED && LEVEL != null) {
            poseStack.pushPose();
            Vec3 projectedView = camera.getPosition();
            poseStack.translate(-projectedView.x, -projectedView.y, -projectedView.z);
            for (int i = 0; i < RenderType.chunkBufferLayers().size(); ++i) {
                VertexBuffer vertexbuffer = MultiblockInWorldPreviewRenderer.getBUFFERS()[i];
                if (vertexbuffer.isInvalid() || vertexbuffer.getFormat() == null) continue;
                RenderType layer = (RenderType)RenderType.chunkBufferLayers().get(i);
                if (layer == RenderType.translucent() && BLOCK_ENTITIES != null) {
                    MultiBufferSource.BufferSource buffers = Minecraft.getInstance().renderBuffers().bufferSource();
                    for (BlockPos pos : BLOCK_ENTITIES) {
                        BlockEntity tile = LEVEL.getBlockEntity(pos);
                        if (tile == null) continue;
                        poseStack.pushPose();
                        poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                        BlockEntityRenderer ber = Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(tile);
                        if (ber != null && tile.hasLevel() && tile.getType().isValid(tile.getBlockState())) {
                            ber.render(tile, partialTicks, poseStack, (MultiBufferSource)buffers, 0xF000F0, OverlayTexture.NO_OVERLAY);
                        }
                        poseStack.popPose();
                    }
                    buffers.endBatch();
                }
                layer.setupRenderState();
                poseStack.pushPose();
                ShaderInstance shaderInstance = RenderSystem.getShader();
                for (int j = 0; j < 12; ++j) {
                    int k = RenderSystem.getShaderTexture((int)j);
                    shaderInstance.setSampler("Sampler" + j, (Object)k);
                }
                if (shaderInstance.MODEL_VIEW_MATRIX != null) {
                    shaderInstance.MODEL_VIEW_MATRIX.set(poseStack.last().pose());
                }
                if (shaderInstance.PROJECTION_MATRIX != null) {
                    shaderInstance.PROJECTION_MATRIX.set(RenderSystem.getProjectionMatrix());
                }
                if (shaderInstance.COLOR_MODULATOR != null) {
                    shaderInstance.COLOR_MODULATOR.set(RenderSystem.getShaderColor());
                }
                if (shaderInstance.FOG_START != null) {
                    shaderInstance.FOG_START.set(Float.MAX_VALUE);
                }
                if (shaderInstance.FOG_END != null) {
                    shaderInstance.FOG_END.set(RenderSystem.getShaderFogEnd());
                }
                if (shaderInstance.FOG_COLOR != null) {
                    shaderInstance.FOG_COLOR.set(RenderSystem.getShaderFogColor());
                }
                if (shaderInstance.FOG_SHAPE != null) {
                    shaderInstance.FOG_SHAPE.set(RenderSystem.getShaderFogShape().getIndex());
                }
                if (shaderInstance.TEXTURE_MATRIX != null) {
                    shaderInstance.TEXTURE_MATRIX.set(RenderSystem.getTextureMatrix());
                }
                if (shaderInstance.GAME_TIME != null) {
                    shaderInstance.GAME_TIME.set(RenderSystem.getShaderGameTime());
                }
                RenderSystem.setupShaderLights((ShaderInstance)shaderInstance);
                shaderInstance.apply();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (layer == RenderType.translucent()) {
                    RenderSystem.enableBlend();
                    RenderSystem.blendFunc((int)770, (int)771);
                    RenderSystem.depthMask((boolean)false);
                } else {
                    RenderSystem.enableDepthTest();
                    RenderSystem.disableBlend();
                    RenderSystem.depthMask((boolean)true);
                }
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                vertexbuffer.bind();
                vertexbuffer.draw();
                poseStack.popPose();
                shaderInstance.clear();
                VertexBuffer.unbind();
                layer.clearRenderState();
            }
            poseStack.popPose();
        }
    }

    private static void prepareBuffers(TrackedDummyWorld level, Collection<BlockPos> renderedBlocks, int duration) {
        if (THREAD != null) {
            THREAD.interrupt();
        }
        CACHE_STATE.set(CacheState.COMPILING);
        MultiblockInWorldPreviewRenderer.getBUFFERS();
        THREAD = new Thread(() -> {
            BlockRenderDispatcher dispatcher = Minecraft.getInstance().getBlockRenderer();
            ModelBlockRenderer.enableCaching();
            PoseStack poseStack = new PoseStack();
            for (int i = 0; i < RenderType.chunkBufferLayers().size(); ++i) {
                if (Thread.interrupted()) {
                    return;
                }
                RenderType layer = (RenderType)RenderType.chunkBufferLayers().get(i);
                BufferBuilder buffer = new BufferBuilder(layer.bufferSize());
                buffer.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.BLOCK);
                MultiblockInWorldPreviewRenderer.renderBlocks(level, poseStack, dispatcher, layer, new WorldSceneRenderer.VertexConsumerWrapper((VertexConsumer)buffer), renderedBlocks);
                BufferBuilder.RenderedBuffer builder = buffer.end();
                VertexBuffer vertexBuffer = MultiblockInWorldPreviewRenderer.getBUFFERS()[i];
                Runnable toUpload = () -> {
                    if (!vertexBuffer.isInvalid()) {
                        vertexBuffer.bind();
                        vertexBuffer.upload(builder);
                        VertexBuffer.unbind();
                    }
                };
                CompletableFuture.runAsync(toUpload, runnable -> RenderSystem.recordRenderCall(runnable::run));
            }
            ModelBlockRenderer.clearCache();
            HashSet<BlockPos> poses = new HashSet<BlockPos>();
            for (BlockPos pos : renderedBlocks) {
                if (Thread.interrupted()) {
                    return;
                }
                BlockEntity tile = level.getBlockEntity(pos);
                if (tile == null || Minecraft.getInstance().getBlockEntityRenderDispatcher().getRenderer(tile) == null) continue;
                poses.add(pos);
            }
            if (Thread.interrupted()) {
                return;
            }
            BLOCK_ENTITIES = poses;
            CACHE_STATE.set(CacheState.COMPILED);
            THREAD = null;
            LEFT_TICK.set(duration);
        });
        THREAD.start();
    }

    private static void renderBlocks(TrackedDummyWorld level, PoseStack poseStack, BlockRenderDispatcher dispatcher, RenderType layer, WorldSceneRenderer.VertexConsumerWrapper wrapperBuffer, Collection<BlockPos> renderedBlocks) {
        for (BlockPos pos : renderedBlocks) {
            BlockState state = level.getBlockState(pos);
            FluidState fluidState = state.getFluidState();
            Block block = state.getBlock();
            BlockEntity te = level.getBlockEntity(pos);
            if (block == Blocks.AIR) continue;
            if (state.getRenderShape() != RenderShape.INVISIBLE && ItemBlockRenderTypes.getRenderLayers((BlockState)state).contains(layer)) {
                poseStack.pushPose();
                poseStack.translate((float)pos.getX(), (float)pos.getY(), (float)pos.getZ());
                poseStack.translate(0.5, 0.5, 0.5);
                poseStack.scale(0.8f, 0.8f, 0.8f);
                poseStack.translate(-0.5, -0.5, -0.5);
                level.setRenderFilter(p -> p.equals((Object)pos));
                WorldSceneRendererImpl.renderBlocksForge((BlockRenderDispatcher)dispatcher, (BlockState)state, (BlockPos)pos, (BlockAndTintGetter)level, (PoseStack)poseStack, (VertexConsumer)wrapperBuffer, (RandomSource)GTValues.RNG, (RenderType)layer);
                level.setRenderFilter(p -> true);
                poseStack.popPose();
            }
            if (!fluidState.isEmpty() && ItemBlockRenderTypes.getRenderLayer((FluidState)fluidState) == layer) {
                wrapperBuffer.addOffset((double)(pos.getX() - (pos.getX() & 0xF)), (double)(pos.getY() - (pos.getY() & 0xF)), (double)(pos.getZ() - (pos.getZ() & 0xF)));
                dispatcher.renderLiquid(pos, (BlockAndTintGetter)level, (VertexConsumer)wrapperBuffer, state, fluidState);
            }
            wrapperBuffer.clerOffset();
            wrapperBuffer.clearColor();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Generated
    public static VertexBuffer[] getBUFFERS() {
        VertexBuffer[] $value = BUFFERS.get();
        if ($value == null) {
            AtomicReference<Object> atomicReference = BUFFERS;
            synchronized (atomicReference) {
                $value = BUFFERS.get();
                if ($value == null) {
                    VertexBuffer[] actualValue = MultiblockInWorldPreviewRenderer.initBuffers();
                    $value = actualValue == null ? BUFFERS : actualValue;
                    BUFFERS.set($value);
                }
            }
        }
        return $value == BUFFERS ? null : $value;
    }

    static {
        LEFT_TICK = new AtomicInteger(-1);
        CACHE_STATE = new AtomicReference<CacheState>(CacheState.UNUSED);
        LAST_POS = null;
        LAST_LAYER = -1;
    }

    private static enum CacheState {
        UNUSED,
        COMPILING,
        COMPILED;

    }
}

